-------------------------------------------------------
--! @file 
--! @brief Priority-condition check for the intMAN hardware
--! @author Josef Strnadel, Brno University of Technology, Faculty of Information Technology
--! @email strnadel@fit.vutbr.cz
--! @date 2013-04-17
-------------------------------------------------------

library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.NUMERIC_STD.ALL;
use work.intMAN_package.all;

--
--
--
--! Entity of the priority-condition check unit for the intMAN hardware (interface)     
--
entity c_prio is
	port (
		monpri : in  STD_LOGIC_VECTOR(t_pri_width_range);    --! priority of the running task (being monitored) 
		hstipri : in  STD_LOGIC_VECTOR(t_pri_width_range);   --! the highest pending-interrupt priority 
		valid : out STD_LOGIC                                --! priority-condition result
	);
end entity c_prio;

--
--
--
--! Architecture of the priority-condition check unit for the intMAN hardware (inner structure)     
--
architecture arch of c_prio is
begin
  --! Priority-condition check process being sensitive to the change of pending interrupt and monitored task priorities  
	process(monpri, hstipri)
	begin
		if(hstipri < monpri) then
			valid <= '1';
		else
			valid <= '0';
		end if;
	end process;	
end architecture arch;
