/******************************************************************************
 * \file
 *
 * $Id:$
 *
 * Copyright (C) Brno University of Technology
 *
 * This file is part of software developed by Robo@FIT group.
 *
 * Author: Jaroslav Rozman
 * Supervised by: Vitezslav Beran (beranv@fit.vutbr.cz), Michal Spanel (spanel@fit.vutbr.cz)
 * Date: 20.11.2012
 *
 * This file is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This file is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this file.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
  ... short description, important information, modules in belongs to, etc.
*/ 


#include <vector>
#include <ros/ros.h>
#include <actionlib/server/simple_action_server.h>
#include <path_planning_action_server/PathPlanAction.h>

#include <geometry_msgs/Twist.h>
#include <tf/transform_listener.h>

#include <tf/tf.h>

//#include <robot_msgs/obstacles.h>
#include <data_bridge/DTB_ObjReport.h>
#include <data_bridge/DTB_Trajectory.h>
#include <geometry_msgs/Pose2D.h>
#include <geometry_msgs/PoseStamped.h>
//#include <LGV_simulator/obstacles.h>

/*
#define WAITING_WHILE_MISSING_TARGET 7//second
#define ToRAD M_PI/180
#define ToDEG 180/M_PI

#define MAX_Dist 3.50
#define MIN_Dist 0.5
*/
using namespace std;


class PathPlanAction
{
protected:

  ros::NodeHandle nh_;
  actionlib::SimpleActionServer<path_planning_action_server::PathPlanAction> as_;
  std::string action_name_;
  // create messages that are used to published feedback/result
  path_planning_action_server::PathPlanFeedback feedback_;
  path_planning_action_server::PathPlanResult result_;
  
  //! We will be publishing to the "cmd_vel" topic to issue commands
  ros::Publisher cmd_vel_pub_;
  //! We will be listening to TF transforms as well
  tf::TransformListener listener_;

  ros::Subscriber sub2;
  ros::Subscriber sub1;
  geometry_msgs::PoseStamped newGoal;

  ros::Publisher pub1; 
 
public:

  PathPlanAction(std::string name) :
    as_(nh_, name, boost::bind(&PathPlanAction::executeCB, this, _1), false),
    action_name_(name)
  {
    pub1 = nh_.advertise<data_bridge::DTB_Trajectory>("/tb2_traj_to_follow", 1);
    sub1 = nh_.subscribe("/move_base_simple/goal", 1, &PathPlanAction::getGoal, this);
    as_.start();
    
 //   cmd_vel_pub_ = nh_.advertise<geometry_msgs::Twist>("cmd_vel", 1);
   // sub2 = nh_.subscribe("/obstacles", 1, &PathPlanAction::detectObstacles, this);
  }

  ~PathPlanAction(void)
  {
  }

 /*
  void detectObstacles(const robot_msgs::obstacles::ConstPtr& msg)
  {
	if (msg->objectType > 0 && msg->areaType > 0)
	{    
		ROS_INFO("%i: Read from driveBase", msg->objectType);
		as_.setPreempted();
		ROS_INFO("%s: Preempted", action_name_.c_str());
	}
  }*/

 
   void getGoal(const geometry_msgs::PoseStamped::ConstPtr& msg)
  {
  	newGoal = *msg;
  	ROS_INFO("Souradnice x je: %f", newGoal.pose.position.x);
  	ROS_INFO("Souradnice y je: %f", newGoal.pose.position.y);
  	ROS_INFO("Souradnice z je: %f", newGoal.pose.position.z);
  	ROS_INFO("Souradnice x je: %f", newGoal.pose.orientation.x);
  	ROS_INFO("Souradnice y je: %f", newGoal.pose.orientation.y);
  	ROS_INFO("Souradnice z je: %f", newGoal.pose.orientation.z);
    	ROS_INFO("Souradnice w je: %f", newGoal.pose.orientation.w);
  }


  void executeCB(const path_planning_action_server::PathPlanGoalConstPtr &goal)
  {
 
        static int seq = 0;


	//HMI::forceDrive()
	//driveForce();
	//result_.result = goal->goal;
	data_bridge::DTB_Trajectory output_traj;
	geometry_msgs::Pose2D traj_point;
	btQuaternion q;
	btScalar roll,pitch, yaw;
	tf::quaternionMsgToTF(newGoal.pose.orientation ,q);
	btMatrix3x3(q).getRPY(roll,pitch,yaw);
	
	traj_point.x = newGoal.pose.position.x;
	traj_point.y = newGoal.pose.position.y;
	traj_point.theta = yaw;
	
	//tf::Transform transform;
        //transform.setOrigin( newGoal.pose.position );
        //transform.setRotation( newGoal.pose.orientation );
  /*
	traj_point.x = newGoal.pose.position.x;
	traj_point.y = newGoal.pose.position.y;
	traj_point.theta = acos(newGoal.pose.orientation.w)*2.0;
	*/
	output_traj.traj_points.push_back(traj_point);
	output_traj.header.frame_id = "/odom_combined";
	output_traj.header.seq = seq++;
	
	pub1.publish(output_traj); //publikujeme trajektorii, po ktere bude driver_base cestovat
	///potreba jeste nastavit timestamp a normalni mod
	 
	ROS_INFO("Executing path planning action.");
	as_.setSucceeded();
	ROS_INFO("%s: Succeeded XXX", action_name_.c_str());

 /*     if (as_.isPreemptRequested() || !ros::ok())
      {
        ROS_INFO("%s: Preempted", action_name_.c_str());
        // set the action state to preempted
        as_.setPreempted();
//        success = false;
       
      }*/
  }


};


int main(int argc, char** argv)
{
  ros::init(argc, argv, "pathPlanning");

  PathPlanAction pathPlanning(ros::this_node::getName());
  ros::spin();

  return 0;
}
