/******************************************************************************
 * \file
 *
 * $Id:$
 *
 * Copyright (C) Brno University of Technology
 *
 * This file is part of software developed by Robo@FIT group.
 *
 * Author: Jaroslav Rozman
 * Supervised by: Vitezslav Beran (beranv@fit.vutbr.cz), Michal Spanel (spanel@fit.vutbr.cz)
 * Date: 20.11.2012
 *
 * This file is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This file is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this file.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
  ... short description, important information, modules in belongs to, etc.
*/ 


#include <data_bridge/DTB_ObjReport.h>
#include <data_bridge/DTB_Trajectory.h>
#include <data_bridge/definitions.h>

#include <vector>
#include <ros/ros.h>
#include <actionlib/server/simple_action_server.h>
#include <drive_base_action_server/driveBaseAction.h>

#include <geometry_msgs/Pose.h>
#include <tf/transform_listener.h>

#include <tf/tf.h>
#include <geometry_msgs/Twist.h>

#include <iostream>
#include <math.h>


using namespace std;


class RobotDriver
{
private:
  //! The node handle we'll be using
  ros::NodeHandle nh_;
  //! We will be publishing to the "cmd_vel" topic to issue commands
  ros::Publisher cmd_vel_pub_;
  //! We will be listening to TF transforms as well
  tf::TransformListener listener_;
  //geometry_msgs::/*Pose2D*/PoseStamped current_destination;
  //data_bridge::DTB_Trajectory current_trajectory;

public:
  //! ROS node initialization
  RobotDriver(ros::NodeHandle &nh)
  {
    nh_ = nh;
    //set up the publisher for the cmd_vel topic
    cmd_vel_pub_ = nh_.advertise<geometry_msgs::Twist>("cmd_vel", 1);
     //cmd_vel_pub_ = nh_.advertise<geometry_msgs::Twist>("/base_controller/command", 1);
  }

   tf::StampedTransform GetCurrentTransform() {
      listener_.waitForTransform("odom_combined", "base_footprint", 
                               ros::Time(0), ros::Duration(1000.0));
       
      tf::StampedTransform current_transform; 
      listener_.lookupTransform("odom_combined", "base_footprint", 
                              ros::Time(0), current_transform);
      return current_transform;
   }
  /*
  geometry_msgs::PoseStamped GetCurrentDestination() {
    return current_destination;
  }*/
  
  double GetAngleBetweenCoordinates(double x1, double y1, double x2, double y2){
    double delta_x = x2-x1;
    double delta_y = y2-y1;
    double vysledek;
    std::cerr << "Uhel - vypocet x1: " << x1 << " y1: " << y1 << " x2: " << x2 << " y2: " << y2 << " delta_x : " << delta_x <<  " delta_y: " << delta_y << "\n";
    vysledek = atan2(delta_y, delta_x);
    ROS_INFO("ATAN2 je: %f", vysledek);
    return vysledek;
    
   // return 0;
  }
  
  //uhel natoceni k dalsimu navigacnimu bodu
  double GetTurnToNextPoint(geometry_msgs::PoseStamped current_destination) {
     listener_.waitForTransform("odom_combined", "base_footprint", 
                               ros::Time(0), ros::Duration(1000.0));
     tf::StampedTransform current_transform;
     //get the current transform
      try
      {
        listener_.lookupTransform("odom_combined", "base_footprint", 
                                  ros::Time(0), current_transform);
      }
      catch (tf::TransformException ex)
      {
        ROS_ERROR("%s",ex.what());
      }
     std::cerr << "Rotace robota je: " << tf::getYaw(current_transform.getRotation()) << "\n";
     double total_angle = GetAngleBetweenCoordinates(current_transform.getOrigin().x(), current_transform.getOrigin().y(),current_destination.pose.position.x, current_destination.pose.position.y) - tf::getYaw(current_transform.getRotation());//current_transform.getRotation().getAngle();
     while (fabs(total_angle) > 2*M_PI){ //normalizace uhlu do intervalu 0.. 2*Pi
       if (total_angle > 0)
         total_angle =  total_angle - 2*M_PI;
       else
         total_angle =  total_angle + 2*M_PI;
     }
     if (fabs(total_angle > M_PI)) {
       if (total_angle > 0)
         total_angle = -(2.0*M_PI - total_angle);
       else
         total_angle = 2.0*M_PI + total_angle;
     } 
     std::cerr << "Vracim uhel: " <<  total_angle << "\n";
     return  total_angle;
  }
  
  static double GetDistanceBetweenPoints(double x1, double y1, double x2, double y2) {
    return sqrt((x2-x1)*(x2-x1)+(y2-y1)*(y2-y1));
  }
  
  double GetDistanceToNextPoint(geometry_msgs::PoseStamped current_destination){
     listener_.waitForTransform("odom_combined", "base_footprint", 
                               ros::Time(0), ros::Duration(1000.0));
     tf::StampedTransform current_transform;
     //get the current transform
      try
      {
        listener_.lookupTransform("odom_combined", "base_footprint", 
                                  ros::Time(0), current_transform);
      }
      catch (tf::TransformException ex)
      {
        ROS_ERROR("%s",ex.what());
      }
//       	ROS_INFO("Souradnice startu x je: %f", current_transform.getOrigin().x());
//   	ROS_INFO("Souradnice startu y je: %f", current_transform.getOrigin().y());
//   	ROS_INFO("Souradnice startu z je: %f", current_transform.getOrigin().z());
//   	ROS_INFO("Souradnice startu rotace je: %f", tf::getYaw(current_transform.getRotation()));
    return GetDistanceBetweenPoints(current_transform.getOrigin().x(), current_transform.getOrigin().y(),current_destination.pose.position.x, current_destination.pose.position.y);
  }
  
  static data_bridge::DTB_Trajectory SplitTrajectory(data_bridge::DTB_Trajectory trajectory, double trajectory_step) {
    data_bridge::DTB_Trajectory output_trajectory;
    
    geometry_msgs::Pose2D last_point;
    geometry_msgs::Pose2D current_point;
    
    //the first point of the trajectory will be a current location of the robot - this should be done outside this function
    
    
    std::cerr << "BOD - AAA00001 \n";
    if (trajectory.traj_points.size() <= 1) //trajectory is empty or has only one point - we can not split it
      return trajectory;
    
    std::cerr << "BOD - AAA00001 \n";
   
    
    output_trajectory.traj_points.push_back(trajectory.traj_points[0]); //insertion of the first point of given trajectory to output
    
    for (int i=1; i < trajectory.traj_points.size(); i++) { //walking through all points of given trajectory
      last_point = trajectory.traj_points[i-1];
      current_point = trajectory.traj_points[i];

      std::cerr << "BOD - AAAA \n";
      geometry_msgs::Pose2D direction_unit_vector;
      double original_traj_step = GetDistanceBetweenPoints(current_point.x , current_point.y, last_point.x, last_point.y);
      direction_unit_vector.x = (current_point.x - last_point.x)/original_traj_step;
      direction_unit_vector.y = (current_point.y - last_point.y)/original_traj_step;
      direction_unit_vector.theta = current_point.theta - last_point.theta;
      while (GetDistanceBetweenPoints(current_point.x , current_point.y, last_point.x, last_point.y) > trajectory_step) {
	last_point.x += direction_unit_vector.x*trajectory_step; //we move a step towards ne current_point of trajectory
	last_point.y += direction_unit_vector.y*trajectory_step;
	output_trajectory.traj_points.push_back(last_point); //and we push the currently generated point to the output trajectory
      }
      output_trajectory.traj_points.push_back(current_point); //here we push a current point that we were heading to into the trajectory
      last_point = current_point; //now the current point becomes last point for a next iteration
    }
    return output_trajectory;
  }

  
  //! Drive forward a specified distance based on odometry information
  bool driveForwardOdom(double distance)
  {
//     ROS_INFO("Jsme tady");
    //wait for the listener to get the first message
    listener_.waitForTransform("base_footprint", "odom_combined", 
                               ros::Time(0), ros::Duration(1000.0));
//     ROS_INFO("Jsme zde");
    
    //we will record transforms here
    tf::StampedTransform start_transform;
    tf::StampedTransform current_transform;
// ROS_INFO("Jsme zde2");
    //record the starting transform from the odometry to the base frame
    listener_.lookupTransform("base_footprint", "odom_combined", 
                              ros::Time(0), start_transform);

// 	ROS_INFO("Souradnice x je: %f", start_transform.getOrigin().x());
//   	ROS_INFO("Souradnice y je: %f", start_transform.getOrigin().y());
//   	ROS_INFO("Souradnice z je: %f", start_transform.getOrigin().z());
//   	ROS_INFO("Souradnice rotace je: %f", tf::getYaw(start_transform.getRotation()));

//  ROS_INFO("Jsme zde2");   
    //we will be sending commands of type "twist"
    geometry_msgs::Twist base_cmd;
    //the command will be to go forward at 0.25 m/s
    base_cmd.linear.y = base_cmd.angular.z = 0;
    base_cmd.linear.x = 0.25;
    
    ros::Rate rate(10.0);
    bool done = false;
    int i = 0;
    while (!done && nh_.ok())
    {
      //send the drive command
//      cmd_vel_pub_.publish(base_cmd);
//      rate.sleep();

     // GetTurnToNextPoint();
     
      
      //get the current transform
      try
      {
        listener_.lookupTransform("base_footprint", "odom_combined", 
                                  ros::Time(0), current_transform);
      }
      catch (tf::TransformException ex)
      {
        ROS_ERROR("%s",ex.what());
        break;
      }
      
      //see how far we've traveled
      tf::Transform relative_transform = 
        start_transform.inverse() * current_transform;
      double dist_moved = relative_transform.getOrigin().length();

      //ROS_INFO("dist_moved %lf", dist_moved);
      //ROS_INFO("distance %lf", distance);
      //ROS_INFO("pocitadlo %d", i);
      if(dist_moved >= distance) 
      {
      	done = true;
      }	
      else
      {
      	//ROS_INFO("JEDU");
      	cmd_vel_pub_.publish(base_cmd);
      	rate.sleep();
      }
      i++;
    }
    if (done) return true;
    return false;
  }
  
  
   bool turnOdom(bool clockwise, double radians)
  {
  //ROS_INFO("Jsme zde 1");
    while(radians < 0) 
    {
    	radians += 2*M_PI;
    }	
    while(radians > 2*M_PI) 
    {
    	radians -= 2*M_PI;
    }
    //wait for the listener to get the first message
    listener_.waitForTransform("base_footprint", "odom_combined", 
                               ros::Time(0), ros::Duration(1.0));
    //  ROS_INFO("Jsme zde 2");
    //we will record transforms here
    tf::StampedTransform start_transform;
    tf::StampedTransform current_transform;

    //record the starting transform from the odometry to the base frame
    listener_.lookupTransform("base_footprint", "odom_combined", 
                              ros::Time(0), start_transform);
//       ROS_INFO("Jsme zde 3");
    //we will be sending commands of type "twist"
    geometry_msgs::Twist base_cmd;
    //the command will be to turn at 0.25 rad/s
    base_cmd.linear.x = base_cmd.linear.y = 0.0;
    base_cmd.angular.z = 0.25;
    if (clockwise) base_cmd.angular.z = -base_cmd.angular.z;
    
    //the axis we want to be rotating by
    tf::Vector3 desired_turn_axis(0,0,1);
    if (!clockwise) desired_turn_axis = -desired_turn_axis;
//       ROS_INFO("Jsme zde 4");
    ros::Rate rate(10.0);
    bool done = false;
    while (!done && nh_.ok())
    {
      //send the drive command
//      cmd_vel_pub_.publish(base_cmd);
//      rate.sleep();
      //get the current transform
      try
      {
        listener_.lookupTransform("base_footprint", "odom_combined", 
                                  ros::Time(0), current_transform);
      }
      catch (tf::TransformException ex)
      {
        ROS_ERROR("%s",ex.what());
        break;
      }
//         ROS_INFO("Jsme zde 5");
      tf::Transform relative_transform = start_transform.inverse() * current_transform;
      tf::Vector3 actual_turn_axis = relative_transform.getRotation().getAxis();
      double angle_turned = relative_transform.getRotation().getAngle();
     
   //   if ( fabs(angle_turned) < 1.0e-2) continue;	ALE NEVIM, PROC TO TU JE

      if ( actual_turn_axis.dot( desired_turn_axis ) < 0 ) 
        angle_turned = 2 * M_PI - angle_turned;

//       ROS_INFO("angle_turned %lf", angle_turned);
//       ROS_INFO("radians %lf", radians);
   //   ROS_INFO("pocitadlo %d", i);
      if (angle_turned >= radians) 
      {
      	done = true;
      }
      else
      {
      	cmd_vel_pub_.publish(base_cmd);
      	rate.sleep();
      }
      
    }
    if (done) return true;
    return false;
  }
  
  
   //! Loop forever while sending drive commands based on keyboard input
  bool driveKeyboard()
  {
    std::cout << "Type a command and then press enter.  "
      "Use '+' to move forward, 'l' to turn left, "
      "'r' to turn right, '.' to exit.\n";

    //we will be sending commands of type "twist"
    geometry_msgs::Twist base_cmd;

    char cmd[50];
    while(nh_.ok()){

      std::cin.getline(cmd, 50);
      if(cmd[0]!='+' && cmd[0]!='l' && cmd[0]!='r' && cmd[0]!='.')
      {
        std::cout << "unknown command:" << cmd << "\n";
        continue;
      }

      base_cmd.linear.x = base_cmd.linear.y = base_cmd.angular.z = 0;   
      //move forward
      if(cmd[0]=='+'){
        base_cmd.linear.x = 0.25;
      } 
      //turn left (yaw) and drive forward at the same time
      else if(cmd[0]=='l'){
        base_cmd.angular.z = 0.75;
        base_cmd.linear.x = 0.25;
      } 
      //turn right (yaw) and drive forward at the same time
      else if(cmd[0]=='r'){
        base_cmd.angular.z = -0.75;
        base_cmd.linear.x = 0.25;
      } 
      //quit
      else if(cmd[0]=='.'){
        break;
      }
      
      //publish the assembled command
      cmd_vel_pub_.publish(base_cmd);
    }
    return true;
  }
};






RobotDriver *driver; ///global pointer for robot driver - here will be placed initialized robot driver
 
class driveBaseAction
{
protected:

  ros::NodeHandle nh_;
  actionlib::SimpleActionServer<drive_base_action_server::driveBaseAction> as_;
  std::string action_name_;
  // create messages that are used to published feedback/result
  drive_base_action_server::driveBaseFeedback feedback_;
  drive_base_action_server::driveBaseResult result_;
  
  //! We will be publishing to the "cmd_vel" topic to issue commands
  ros::Publisher cmd_vel_pub_;
  //! We will be listening to TF transforms as well
  tf::TransformListener listener_;

  ros::Subscriber sub1;
  ros::Subscriber sub2;
  ros::Subscriber sub3;
  volatile int preemptRequested;
  //geometry_msgs::PoseStamped newGoal;
  data_bridge::DTB_Trajectory pending_trajectory;
  geometry_msgs::Pose2D current_waypoint;
  int trajectory_index;
  int breakpoint;

public:

  driveBaseAction(std::string name) :
  //  as_(nh_, name, boost::bind(&driveBaseAction::executeCB, this, _1), false),
    as_(nh_, name, false),
    action_name_(name)
  {
    //ros::Publisher vis_pub = node_handle.advertise<visualization_msgs::Marker>( "visualization_marker", 0 );
    as_.registerGoalCallback(boost::bind(&driveBaseAction::executeCB, this));
   // cmd_vel_pub_ = nh_.advertise<geometry_msgs::Twist>("cmd_vel", 1);
    sub2 = nh_.subscribe("/data_bridge_objdet", 1, &driveBaseAction::detectObstacles, this);
    //sub1 = nh_.subscribe("/move_base_simple/goal", 1, &driveBaseAction::getGoal, this);
    sub3 = nh_.subscribe("/tb2_traj_to_follow"/*EXPAND(TRAJECTORY_IN_TOPIC_NAME)*/,1, &driveBaseAction::getTrajectory,this); //vstup trajektorii
    current_waypoint.x=0; //reset waypointu - cil je 0,0,0 - tedy tam, kde robot stoji
    current_waypoint.y=0;
    current_waypoint.theta=0;
    trajectory_index = 0; //jsme u prvniho bodu trajektorie
    preemptRequested = 0;
    breakpoint = 0;
    as_.start();
  }

  ~driveBaseAction(void)
  {
  }

  void getTrajectory(const data_bridge::DTB_Trajectory::ConstPtr& traj ){
    trajectory_index = 0; 
    pending_trajectory = *traj;
    if (traj->traj_points.size() > 0) {
      current_waypoint = pending_trajectory.traj_points[trajectory_index];
    }
    trajectory_index++; //rovnou zacneme ukazovat na dalsi bod trajektorie
    std::cerr << "Updated trajectory\n";
    breakpoint = 1;
  }
  

  void detectObstacles(const data_bridge::DTB_ObjReport::ConstPtr& msg)
  {
	volatile int priority = 0;
  	ROS_INFO("Callback entered"); 
	ROS_INFO("Number of objects is: %ul", msg->objects.size() );
        //if (msg->objects.size()>0) 
	for (uint i = 0; i < msg->objects.size(); i++)
	{
		if (msg->objects[i].m_zone > priority)
			priority = msg->objects[i].m_zone;
	} 
			
	//  if (msg->objects[0].m_class > 0 && msg->objects[0].m_zone > 0)
	if (priority > 0)	 
	{    
		preemptRequested = 1;
		//ROS_INFO("%i: Read from driveBase", msg->objectType);
		//as_.cancelGoal();
		//as_.setPreempted();
		ROS_INFO("%d: Priorita je", priority);
	  }
      
  }


 
  void executeCB(/*const drive_base_action_server::driveBaseGoalConstPtr &goal*/)
  {


	geometry_msgs::Pose goal = as_.acceptNewGoal()->goal;
	
	ros::spinOnce(); //drive, nez budeme nasledovat trajektorii, udelame jeste spin - aby se nastavily trajektorie v bufferu
	int success = 1;
	std::cerr << "BOD0\n";
	ROS_INFO("ahoj");
      ros::Rate rate(1.0);
      int poc = 0;
        double rot_step = 0.05;
	double dist_step = 0.1;
        double rot_tollerance = 0.11;
	double dist_tollerance = 0.15;
	std::cerr << "BOD1\n";
	
	while(breakpoint == 0)
	{
		ROS_INFO("Cekam na cestu");
		ros::spinOnce();
	}
	
        tf::StampedTransform current_transform = driver->GetCurrentTransform(); //transformace popisujici aktualni pozici robota 
	
	data_bridge::DTB_Trajectory input_trajectory =  pending_trajectory;
	geometry_msgs::Pose2D current_robot_position;
	current_robot_position.x = current_transform.getOrigin().x();
	current_robot_position.y =  current_transform.getOrigin().y();
	current_robot_position.theta = tf::getYaw(current_transform.getRotation());
	pending_trajectory.traj_points.insert(pending_trajectory.traj_points.begin(),current_robot_position);
	for (int i = 0; i < pending_trajectory.traj_points.size(); i++) {
	  std::cerr << "----------- BOD TRAJEKTORIE: " << pending_trajectory.traj_points[i].x << " - " << pending_trajectory.traj_points[i].y << " - " << pending_trajectory.traj_points[i].theta << "\n";
	}
	
	pending_trajectory  = RobotDriver::SplitTrajectory(pending_trajectory, 0.2); //splitting the trajectory for 0.2m steps
	
	std::cerr << "\n\n\n"; 
	for (int i = 0; i < pending_trajectory.traj_points.size(); i++) {
	  std::cerr << "----------- BOD TRAJEKTORIE: " << pending_trajectory.traj_points[i].x << " - " << pending_trajectory.traj_points[i].y << " - " << pending_trajectory.traj_points[i].theta << "\n";
	}
	geometry_msgs::PoseStamped current_destination;// = newGoal;//driver->GetCurrentDestination(); //aktualni cil
	
	
	current_destination.pose.position.x = pending_trajectory.traj_points[0].x;
	current_destination.pose.position.y = pending_trajectory.traj_points[0].y;
	current_destination.pose.position.z = 0;
	
	current_destination.pose.orientation.x = 0;
	current_destination.pose.orientation.y = 0;
	current_destination.pose.orientation.z = sin(pending_trajectory.traj_points[0].theta/2.0);
	current_destination.pose.orientation.w = cos(pending_trajectory.traj_points[0].theta/2.0);
	
	double rotation_to_next_point = driver->GetTurnToNextPoint(current_destination);
        double distance_to_next_point =  driver->/*GetDistanceBetweenPoints(newGoal.pose.position.x, newGoal.pose.position.y, );*/GetDistanceToNextPoint(current_destination);
	std::cerr << "BOD2\n";
	
	
	//current_destination.x = 1.5;
	//current_destination.y = -0.5;
	
        std::cerr << "Uhel do ciloveho bodu: "<< rotation_to_next_point << "\n";
        std::cerr << "Vzdalenost do ciloveho bodu: " <<distance_to_next_point << "\n";
        ROS_INFO("%d: poc na zacatku je", poc);
	bool final_turn = false;
	while (preemptRequested == 0 /* poc < 1*/)
	{
		ROS_INFO("%d: poc je", poc);
		//HMI::forceDrive()
	//	driveForce();
		
		if ((fabs(distance_to_next_point) > dist_tollerance) && (fabs(rotation_to_next_point) > rot_tollerance)) {
		  std::cerr << "Rotuji smerem k cili\n";
		  //rotace o jeden krok smerem k cili
		  if (fabs(rotation_to_next_point) > rot_step) { //we need to perform step of rotation
			  if (rotation_to_next_point > 0)
			    driver->turnOdom(0,rot_step);
			  else
			    driver->turnOdom(1,rot_step);
		  } else { //we do the small rotation completely
			    driver->turnOdom(0,rotation_to_next_point);
		  }
		} else if (!final_turn && (fabs(distance_to_next_point) > dist_tollerance)) {
		  std::cerr << "Posouvam se k cili\n";
		  //posun o jeden krok smerem k cili
		  if (fabs(distance_to_next_point) > dist_step) //krok smerem k cili
		  	driver->driveForwardOdom(dist_step);
		  else //dokroceni k cili
		  	driver->driveForwardOdom(fabs(distance_to_next_point));
		} else { //vse sedi - jsme na miste - muzeme prejit na dalsi bod trajektorie, pokud je nejaky
		  
		  std::cerr << "----------\n Jsme u jednoho bodu trajektorie: x=" << current_waypoint.x << " y=" << current_waypoint.y << "\n";
		  if (pending_trajectory.traj_points.size() > 0 && pending_trajectory.traj_points.size() > trajectory_index) {
		        current_waypoint = pending_trajectory.traj_points[trajectory_index++]; //vezmeme dalsi bod trajektorie a posuneme index v trajektorii
		    	current_destination.pose.position.x = current_waypoint.x;
			current_destination.pose.position.y = current_waypoint.y;
			current_destination.pose.position.z = 0;
	
			current_destination.pose.orientation.x = 0;
			current_destination.pose.orientation.y = 0;
			current_destination.pose.orientation.z = sin(current_waypoint.theta/2.0);
			current_destination.pose.orientation.w = cos(current_waypoint.theta/2.0);
			std::cerr << "==========\n Dalsi bod trajektorie....\n";
		  } else if (!final_turn){
		    final_turn = true;
		    current_transform = driver->GetCurrentTransform();
		    rotation_to_next_point = pending_trajectory.traj_points.rbegin()->theta /*asin(current_destination.pose.orientation.z)*2.0*/ -  tf::getYaw(current_transform.getRotation()) ;
		    std::cerr << "******\n"<< "Finalka - Musim dotocit: " << rotation_to_next_point << "\n";
		    distance_to_next_point =  2*dist_tollerance; //a trick - we say that we are not close enought
		  } else {
		      break;
		  }
		}
		//driver->turnOdom(0, /*0*3.1415/180*/rotation_to_next_point);
		rate.sleep();
		ros::spinOnce();
                //driver->driveForwardOdom(distance_to_next_point);
		//result_.result = goal->goal;
		ROS_INFO("%d: PreemptREquested je", preemptRequested);
	
		poc++;
		if (preemptRequested != 0 || !ros::ok())
		{
			as_.setPreempted();
			ROS_INFO("%s: Preempted", action_name_.c_str());
			success = 0;
			break;
		}
		
		if (final_turn) { //turning to the final point direction
		  current_transform = driver->GetCurrentTransform();
		  rotation_to_next_point = pending_trajectory.traj_points.rbegin()->theta -  tf::getYaw(current_transform.getRotation()) ;
		  std::cerr << "******\n"<< "Finalka - Musim dotocit: " << rotation_to_next_point << " cilova rotace: " <<  asin(current_destination.pose.orientation.z)*2.0   << " ro ma rotaci: " <<  tf::getYaw(current_transform.getRotation()) <<  "\n";
		  distance_to_next_point =  2*dist_tollerance; //a trick - we say that we are not close enought
		} else { //normal mode - inside the trajectory we ignore turning of points
		  rotation_to_next_point = driver->GetTurnToNextPoint(current_destination);
		  std::cerr << "******\n"<< "Musim dotocit: " << rotation_to_next_point << "\n";
		  distance_to_next_point =  driver->GetDistanceToNextPoint(current_destination);
		}
	}
		
	if (success == 1)	
	{
		as_.setSucceeded();
		ROS_INFO("%s: Succeeded XXX", action_name_.c_str());
		//break;
	}
/*	if (success == 0)
	{
		as_.setPreempted();
		ROS_INFO("%s: Preempted XYX", action_name_.c_str());
		//break;
	}
*/	
	preemptRequested = 0;
	breakpoint = 0;
 /*     if (as_.isPreemptRequested() || !ros::ok())
      {
        ROS_INFO("%s: Preempted", action_name_.c_str());
        // set the action state to preempted
        as_.setPreempted();
//        success = false;
       
      }*/
  }

};


int main(int argc, char** argv)
{
  ros::init(argc, argv, "driveBase");
  ros::NodeHandle nh;
  driver = new RobotDriver(nh);
  //RobotDriver driver(nh);
//driver.driveKeyboard();
//driver.turnOdom(1, 2.54);
 // driver.driveForwardOdom(0.5);
  
  driveBaseAction driveBase(ros::this_node::getName());
  ros::spin();

  return 0;
}
