/******************************************************************************
 * \file
 *
 * $Id:$
 *
 * Copyright (C) Brno University of Technology
 *
 * This file is part of software developed by Robo@FIT group.
 *
 * Author: Jaroslav Rozman
 * Supervised by: Vitezslav Beran (beranv@fit.vutbr.cz), Michal Spanel (spanel@fit.vutbr.cz)
 * Date: 20.11.2012
 *
 * This file is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This file is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this file.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
  ... short description, important information, modules in belongs to, etc.
*/ 


#include <ros/ros.h>
#include <actionlib/server/simple_action_server.h>
#include <avoidance_planning_action_server/AvoidancePlanningAction.h>
#include <data_bridge/DTB_ObjReport.h>
#include <data_bridge/DTB_Trajectory.h>
#include <data_bridge/DTB_AbsPosition.h>
#include <data_bridge/definitions.h>


#include<iostream>
#include<fstream>

using namespace std;

class AvoidancePlanningAction
{
protected:

  ros::NodeHandle nh_;
  volatile int needInfo;
  volatile int needPosition;
  volatile int needPath;
  volatile int waitForAnswer;
  data_bridge::DTB_AbsPosition robotPosition;
  data_bridge::DTB_Trajectory oldPath;
  data_bridge::DTB_Trajectory newPath;
  data_bridge::DTB_ObjReport detectedObstacles;
    ros::Subscriber sub;
    ros::Subscriber sub2;
    ros::Subscriber sub3;
    ros::Subscriber sub4;
    ros::Publisher pub;
    ros::Publisher pub2;

  actionlib::SimpleActionServer<avoidance_planning_action_server::AvoidancePlanningAction> as_;
  std::string action_name_;
  // create messages that are used to published feedback/result
  avoidance_planning_action_server::AvoidancePlanningFeedback feedback_;
  avoidance_planning_action_server::AvoidancePlanningResult result_;

public:

  AvoidancePlanningAction(std::string name) :
    as_(nh_, name, boost::bind(&AvoidancePlanningAction::executeCB, this, _1), false),
    action_name_(name)
  {
    needInfo = 1;
    needPosition = 1;
    needPath = 1;
    waitForAnswer = 1;
    as_.start();
  }

  ~AvoidancePlanningAction(void)
  {
  }


  void getInfo(const data_bridge::DTB_ObjReport::ConstPtr& msg)
  {
  	ROS_INFO("Callback entered");
        if (msg->objects.size()>0  && needInfo == 1)
	{
  	//  for (int i = 0; i < msg->objects.size(); i++)
	//	{
	  //	if (msg->objects[i].m_class > 0 && msg->objects[i].m_zone < 2 && needInfo == 1)
	  //		{      
				needInfo = 0;
				//ROS_INFO("We are getting info about obstacle");
				detectedObstacles = *msg;
				ROS_INFO("We are getting info about obstacle");
				//detectedObstacle.m_id = msg->;
			//	break;
	//		}


	//  	}
        }
  }

  void getRobotPosition(const data_bridge::DTB_AbsPosition::ConstPtr& msg)
  {
  	ROS_INFO("Callback getRobotPosition entered");
	if (needPosition == 1)
	{    
		needPosition = 0;
		ROS_INFO("We are getting robot position");
		robotPosition = *msg;
	}
  }
/*
  void getOldPath(data_bridge::DTB_Trajectory::ConstPtr& msg)
  {
  	ROS_INFO("Callback getOldPath entered");
	if (needPath == 1)
	{    
		needPath = 0;
		ROS_INFO("We are getting old path");
		oldPath = *msg;
	}
  }*/

  void getNewPath(const data_bridge::DTB_Trajectory::ConstPtr& msg)
  {
  	ROS_INFO("Callback getNewPath entered");
	if (waitForAnswer == 1)
	{    
		waitForAnswer = 0;
		ROS_INFO("We are getting new path");
		newPath = *msg;
	}
  }

  int line_num(std::string fm)
  {
      FILE *f;char c;
      int lines = 0;
      f = fopen(fm.c_str(), "r");
      if(f == NULL)
      return 0;
      while((c = fgetc(f)) != EOF)
      if(c == '\n')
      lines++;
      fclose(f);
      if(c != '\n')
      lines++;
      return lines;
  }

bool readOldPath() {
  cout <<" +++++++++++++++++++++++ start mainREADPATH 1"<< endl;
      int PathSize=0;
      /*std::string*/ const char * fm = "/../../../../but_avoidance_path/path_request/RobotoriginalPath.txt";
      PathSize = line_num(fm);
      newPath.traj_points.resize(PathSize);
      //FILE *inpA = fopen("/home/bkhelifa/ros/stacks/ros/but_r3cop/but_data_bridge/data_bridge/odometry_file_name.txt", "r");
      FILE *inpA = fopen(fm, "r");
      bool endSeg=false;
      int inc=0;double eps=0.0001;
      double inpATemp[PathSize][4];
      for(int j=0;j<PathSize;j++){
	      for(int i=0;i<4;i++)
	      {
		      fscanf(inpA,"%lf",&inpATemp[j][i]);
	      }
      }
      for(int j=0;j<PathSize;j++){
	      newPath.traj_points[j].x=inpATemp[j][1];
	      newPath.traj_points[j].y=inpATemp[j][2];
	      newPath.traj_points[j].theta=inpATemp[j][3];
      }

return 1;
}


  void executeCB(const avoidance_planning_action_server::AvoidancePlanningGoalConstPtr &goal)
  {
    // helper variables
//    ros::Rate r(1);
    bool success = true;
    ros::Rate rate(10);

    /*
    sub3 = nh_.subscribe("data_bridge_Trajectory_in", 1, &AvoidancePlanningAction::getOldPath, this);
    while (needPath == 1)	
	{
		ROS_INFO("Waiting for info about old path");
		rate.sleep();
	}
*/
    
    
    
    sub = nh_.subscribe("data_bridge_objdet", 1, &AvoidancePlanningAction::getInfo, this);
//    sub = nh_.subscribe<data_bridge::DTB_Trajectory>(EXPAND(TRAJECTORY_OUT_TOPIC_NAME), 1, &AvoidancePlanningAction::getInfo, this);
    while (needInfo == 1)	
	{
		ROS_INFO("Waiting for info about obstacles");
		rate.sleep();
	}

   
    newPath.header = detectedObstacles.header;
     
    
    readOldPath();

    for(int i = 0; i <detectedObstacles.objects.size(); i++)
	{
	//	if ((detectedObstacles.objects[i].m_zone == 2) && (detectedObstacles.objects[i].m_speed_class == 0) && ((detectedObstacles.objects[i].m_class == 2) || (detectedObstacles.objects[i].m_class == 3)))
			/*newPath.object_IDs[i]*/newPath.object_IDs.push_back(detectedObstacles.objects[i].m_id);// I am sending obstacles in all zones (danger, warning, safe)
	}
    newPath.mode = 123456789;
    

/*
    sub2 = nh_.subscribe("data_bridge_abs_position", 1, &AvoidancePlanningAction::getRobotPosition, this);
    while (needPosition == 1)	
	{
		ROS_INFO("Waiting for info about robot position");
		rate.sleep();
	}

*/

    // publish info to the console for the user
    ROS_INFO("%s: Executing: ", action_name_.c_str());

    // start executing the action
//    for(int i=1; i<=goal->order; i++)
//    {
      // check that preempt has not been requested by the client
      if (as_.isPreemptRequested() || !ros::ok())
      {
//        ROS_INFO("%s: Preempted", action_name_.c_str());
        // set the action state to preempted
//        as_.setPreempted();
//        success = false;
//        break;
      }
//      feedback_.sequence.push_back(feedback_.sequence[i] + feedback_.sequence[i-1]);
      // publish the feedback
      as_.publishFeedback(feedback_);
      // this sleep is not necessary, the sequence is computed at 1 Hz for demonstration purposes
//      r.sleep();
//    }

 
    pub2 = nh_.advertise<data_bridge::DTB_Trajectory>("/avoiding_IDs", 1000, true);//true means "latch = true"
	pub2.publish(newPath);

    pub = nh_.advertise<data_bridge::DTB_Trajectory>(EXPAND(TRAJECTORY_IN_TOPIC_NAME), 1000);
  //  pub.publish(newPath);

    
   sub4 = nh_.subscribe<data_bridge::DTB_Trajectory>(EXPAND(TRAJECTORY_OUT_TOPIC_NAME), 1, &AvoidancePlanningAction::getNewPath, this);    
    
    int i = 0;
    bool waitForAnswer_till=true;
    while((waitForAnswer == 1) && (waitForAnswer_till))
    {
	ROS_INFO("Waiting for new path: %d", i);
	rate.sleep();
	if(i<=50)
		pub.publish(newPath);
	
        i++;
	if (i>50)
	    waitForAnswer_till=false;
    }
    if (i >= 50)
	success = 0;
    else 
	success = 1;

/* ACCORDING VITA WE DO NOT NEED THIS
    pub2 = nh_.advertise<data_bridge::DTB_Trajectory>(EXPAND(TRAJECTORY_OUT_TOPIC_NAME), 1);
    pub2.publish(newPath);//OPRAVDU JE TO newPath??
*/

    //IF ACTION FINISHED SUCCESSFULLY, SET success = 1....
    if(success != 0)
    {
	
//      result_.sequence = feedback_.sequence;
      ROS_INFO("%s: Succeeded", action_name_.c_str());
      // set the action state to succeeded
      as_.setSucceeded();
    }

    //... OTHERWISE SET success = 0
    if(success == 0)
    {
//      result_.sequence = feedback_.sequence;
      ROS_INFO("%s: Preempted", action_name_.c_str());
      // set the action state to succeeded
      as_.setPreempted();
    }

    needInfo = 1;
    needPosition = 1;
    needPath = 1;
    waitForAnswer = 1;
  }


};


int main(int argc, char** argv)
{
  ros::init(argc, argv, "avoidancePlanning");

  AvoidancePlanningAction avoidancePlanning(ros::this_node::getName());
  ros::spin();

  return 0;
}
