/**
 * Developed by dcgm-robotics@FIT group
 * Author: Khelifa baizid (baizid@fit.vutbr.cz. OR baizid.khelifa@gmail.com)
 * Date: 10.04.2012 (version 1.0)
 *
 * License: BUT OPEN SOURCE LICENSE
 *
 * Description:
 * Path Avoidance
 * 
 *------------------------------------------------------------------------------
 */
#include "but_path_node/GetNewPath.h"

#define Threshold 120// mm
#define MaxObjectSize 1000// mm
#define DepthForObstacle 300// mm
#define toMetre 0.001
#define toMMetre 1000

using namespace std;

GetNewPath::GetNewPath(float W, float H, float R)
{
   
   //mRRTPathPlanner=NULL;
   //mFirstUpdate=true;
   //mThereAreObjects=false;
   
   //mPathPlanner=NULL;
   
   mPublishComments=false;
   
   
   mBackToOriginalPath=false;
   mUsedFarePointAfterObstacles=true;
   mPointExtreme.mX=0;
   mPointExtreme.mY=0;
   
   mThereIsAvoidPath=false;
   mSecurityDis=3500;//mm
}

GetNewPath::~GetNewPath()
{
  //delete mPathPlanner;//NOTE 
}

geometry_msgs::PoseArray GetNewPath::GetAvoidancePath(geometry_msgs::PoseArray OriginalPath, /*geometry_msgs::PoseStamped*/ geometry_msgs::Pose2D RobotPose, vector<mObstacleSize> mCircleObjDisOri)
{
       mPointFare.mX=0;// = Point2dDouble(0,0);
       mPointFare.mY=0;//
       mPointExtreme.mX=0;// = Point2dDouble(0,0);
       mPointExtreme.mY=0;
       mClosestObsPointToRobot.mX = 0;
       mClosestObsPointToRobot.mY = 0;
   //cout<<"starting GetAvoidancePath:...............................................................................................................:::  "<<mSecurityDis<<endl;
        //mThereIsAvoidPath=false;
	//TEST
	//int tes= spline();
	//END TEST
	//return OriginalPath;
	//bool LaserProcessing::LaserObstacleAvoidness(std::vector<ObjectsParameter> mCircleObjDisOri)
	geometry_msgs::PoseArray out;
	VectorPointD SafePath;
	//delete mObstAvoidParam;
	LaserObstacleAvoidnessParts mObstAvoidParam;
	mObstAvoidParam.FirstRot=0;
	mObstAvoidParam.FirstTrans=0;
	mObstAvoidParam.SecondRot=0;
	mObstAvoidParam.SecondTrans=0;
	//check closer object to the robot
	//this are the paramater to avbode the obstacle: FirstRot, FirstTrans, SecondRot, SecondTrans
	double SecurityDis = mSecurityDis;//3500;
	std::vector<int> CloserObjID;
	std::vector<int> CloserProjectedObjID;
	short MinObstDist=(1000);//380/2mm //should be the size of the robot 500
	double gobackbythisDis=0;
	
	for(int i=0;i<mCircleObjDisOri.size();i++)
	{
		if(mCircleObjDisOri[i].Closer>200)
		{
			//cout<<"Closer here "<<mCircleObjDisOri[i].Closer<<" : "<<mCircleObjDisOri[i].Size<<endl;
			if(mCircleObjDisOri[i].Size>10){
				//calculate the min distance to this object
				Point2dDouble ff(mCircleObjDisOri[i].f.mX,mCircleObjDisOri[i].f.mY);
				Point2dDouble ll(mCircleObjDisOri[i].l.mX,mCircleObjDisOri[i].l.mY);
				Point2dDouble cc(0,0);cc=mCircleObjDisOri[i].c;
				//Point2dDouble ff(2,1);Point2dDouble ll(1,2);Point2dDouble cc(0,0);

				//double d = 123456789;//GeometryTools::DistanceToLine(ff, cc, ll);
				float df = DistanceTwoPointsk(ff.mX, ff.mY)-mCircleObjDisOri[i].Size/2;
				float dl = DistanceTwoPointsk(ll.mX, ll.mY)-mCircleObjDisOri[i].Size/2;
				float dc = mCircleObjDisOri[i].Closer-mCircleObjDisOri[i].Size/2;

				if((df<SecurityDis)||(dl<SecurityDis)||(dc<SecurityDis))
				{
					CloserObjID.push_back(i);//TODO why is not used
					if(mPublishComments)
					      cout<<"we have one object here "<<ff.mX<<" : "<<ll.mX<<endl;
					if((fabs(ff.mY)<MinObstDist)||(fabs(ll.mY)<MinObstDist)||(fabs(cc.mY)<MinObstDist))
					{
						CloserProjectedObjID.push_back(i);
					}
					if(mPublishComments)
					  cout<<"df here "<<df<<" : "<<dl<<" :dc: "<<dc<<" size "<<mCircleObjDisOri[i].Size<<endl;
				}
				/*Point2dDouble dpoint = DistanceToLinek(ff, cc, ll);
				double d = DistanceTwoPointsk(dpoint.mX, dpoint.mY);
				double dfl = DistanceTwoPointsk(ff, ll);
				double dcf = DistanceTwoPointsk(cc, ff);
				double dcl = DistanceTwoPointsk(cc, ll);
				if((dcf>dfl)||(dcl>dfl))
				{
					if((dcf<SecurityDis)||(dcl<SecurityDis))
					{
						CloserObjID.push_back(i);
						if((fabs(ff.mX)<MinObstDist)||(fabs(ll.mX)<MinObstDist))
						{
							CloserProjectedObjID.push_back(i);
						}
					}
				}else{
					if(d<SecurityDis)
					{
						CloserObjID.push_back(i);
						if(fabs(dpoint.mX)<MinObstDist)
						{
							CloserProjectedObjID.push_back(i);
						}
					}
				}*/

			}
			
		}
	}
	
	//if not object return EMPTY vector
	if (CloserProjectedObjID.size()==0)
	{
		    //cout<<"************::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::: [ NO Obstacles Near to the Robot ] ************"<<endl;
		    mThereIsAvoidPath=false;
		    return out;
	}
 //cout<<"starting GetAvoidancePath_1"<<endl;
	std::vector<double> CloserProjectedCloserObjID;
	std::vector<double> CloserDisID;
	//VectorPointD CloserProjectedCloserObjID;
	std::vector<double> CloserTEMP;
	//fine the closed PROJECTED object to the robot
	int Detectedobjects = 0;
	Detectedobjects = CloserProjectedObjID.size();
	float maxDistanceAfterObstacle=0;
	Point2dDouble fareP(0,0);
	double fardist =0;
	if(Detectedobjects!=0){
		for(int i=0;i<Detectedobjects;i++)
		{
			int k=CloserProjectedObjID[i];
			//Point2dDouble(x, y);
			double xF = mCircleObjDisOri[k].f.mX;//xFirst;
			double yF = mCircleObjDisOri[k].f.mY;//yFirst;
			double gamaFirst = AngleDistanceTwoPointsk(xF,yF)*180/M_PI;
			
			double xL = mCircleObjDisOri[k].l.mX;//xLast;
			double yL = mCircleObjDisOri[k].l.mY;//yLast;
			double gamaLast = AngleDistanceTwoPointsk(xL,yL)*180/M_PI;
			
			double FirstDis = DistanceTwoPointsk(mCircleObjDisOri[k].f.mX,mCircleObjDisOri[k].f.mY);
			double LastDis = DistanceTwoPointsk(mCircleObjDisOri[k].l.mX,mCircleObjDisOri[k].l.mY);
			
			CloserProjectedCloserObjID.push_back(/*90-*/gamaFirst/*Point2dDouble(gamaFirst, FirstDis)*/);
			CloserProjectedCloserObjID.push_back(/*90-*/gamaLast/*Point2dDouble(gamaLast, LastDis)*/);
			
			CloserDisID.push_back(FirstDis);
			CloserDisID.push_back(LastDis);

			//calsulate the fare point
			if(yF>yL||maxDistanceAfterObstacle<yF) maxDistanceAfterObstacle=yF;
			if(yL>yF||maxDistanceAfterObstacle<yL) maxDistanceAfterObstacle=yL;
			//calculate the fare point
			double dd = DistanceTwoPointsk(mCircleObjDisOri[k].maxp.mX,mCircleObjDisOri[k].maxp.mY);
			if(dd>fardist){ 
			  fardist = dd;
			  fareP.mX = dd;
			  fareP.mY = 0;
			}
			//cout<<"fare point: "<<i<<" : "<<fareP.mY.mY<<endl;
		}
		
		mPointFare = fareP;//TransformSinglePointToGlobalFrame(fareP,  RobotPose);
		//find the direction and the distance of the object
		double CloserObjectDir = MinArrayk(CloserProjectedCloserObjID);
		
		int ijij = ThisElementArray(CloserProjectedCloserObjID, CloserObjectDir);
		ijij=ijij+2;
		double DisForDir;
		int ijijik =0;
		if((ijij%2)==1){
			ijijik=(ijij-1)/2;
			DisForDir = CloserDisID[ijijik];
		}else{
			ijijik=(ijij-2)/2;
			DisForDir = CloserDisID[ijijik];
			
		}
		mClosestObsPointToRobot.mX = DisForDir * sin((CloserObjectDir*3.14159)/180);
		mClosestObsPointToRobot.mY = DisForDir * cos((CloserObjectDir*3.14159)/180);
		mClosestObsPointToRobot = TransformSinglePointToGlobalFrame(mClosestObsPointToRobot, RobotPose);
		mClosestObsPointToRobot.mX = mClosestObsPointToRobot.mX /1;
		mClosestObsPointToRobot.mY = mClosestObsPointToRobot.mY /1;
		/*if(fabs(DisForDir)>1000)
		{
			DisForDir=800;//cout<<" === Obstacle === Obstacle === Obstacle === Obstacle === Obstacle === Obstacle === "<< mObstAvoidParam.FirstRot<<endl;
		}*/
		double arccoss;
		arccoss=MinObstDist/DisForDir;
		double Gama = acos(arccoss)*180/M_PI;
		double NewDirectionRobot=0;
		double gb=fabs(CloserObjectDir)+fabs(Gama);

		if(gb<180)
		{
			NewDirectionRobot = -180+gb;
		}else{
			NewDirectionRobot = -360+gb;	
		}

		mObstAvoidParam.FirstRot=-NewDirectionRobot*1.5;
		if((mObstAvoidParam.FirstRot<10)&&(mObstAvoidParam.FirstRot!=0))
		{
			mObstAvoidParam.FirstRot=10;
		}
		mObstAvoidParam.FirstTrans=DisForDir;//mCircleObjDisOri[ijij].Closer;
		if(mObstAvoidParam.FirstTrans>SecurityDis+500) mObstAvoidParam.FirstTrans=SecurityDis;
		mObstAvoidParam.SecondRot=0;//-(/*mObstAvoidParam.FirstRot +*/ mObstAvoidParam.FirstRot/2);
		mObstAvoidParam.SecondTrans=0;//mObstAvoidParam.FirstTrans/2;
		//cout<<"....................................................................................................NewDirectionRobot: "<<mObstAvoidParam.FirstRot<<" distance: "<<DisForDir<<endl;
	}
	//cout<<maxDistanceAfterObstacle<<" :Obstacle === Obstacle === Obstacle === Obstacle === Obstacle === Obstacle === Obstacle === "<< mObstAvoidParam.FirstRot<<endl;
	float xp =SecurityDis*cos(mObstAvoidParam.FirstRot*3.14159/180);
	float yp =SecurityDis*sin(mObstAvoidParam.FirstRot*3.14159/180);
	
	if(mObstAvoidParam.FirstRot>90)
	{
		//cout<<"************ [ Direction of the robot is more than 90deg No SOLUTION, Obstacle are very close to the robot ] ************"<<endl;
		mThereIsAvoidPath=false;
		return out;
	}
 
	//calculate the way points
	SafePath.resize(4);
	SafePath[0]=Point2dDouble(0, 0);//first point is the robot location
	SafePath[1]=Point2dDouble(500, 0);//second point in front of the robot
	SafePath[2]=Point2dDouble(xp, yp);//Point2dDouble(mCircleObjDisOri[0].l.mY, mCircleObjDisOri[0].l.mX);//
	SafePath[3]=Point2dDouble(xp, yp+SecurityDis/2);//500//
	
	VectorPointD SafePath_a;
	SafePath_a = GenerateSmouthPath(OriginalPath, SafePath, mObstAvoidParam.FirstRot, mObstAvoidParam.FirstTrans, RobotPose);
	
//cout<<"starting GetAvoidancePath_3"<<endl;
	mThereIsAvoidPath=true;
	float di=sqrt((mCircleObjDisOri[0].f.mX-xp)*(mCircleObjDisOri[0].f.mX-xp)+(mCircleObjDisOri[0].f.mY-yp)*(mCircleObjDisOri[0].f.mY-yp));
	Point2dDouble cc(0,0);
	float dif = DistancePointToLinek(cc, mCircleObjDisOri[0].f, Point2dDouble(yp,-xp));
	float dil = DistancePointToLinek(cc, mCircleObjDisOri[0].l, Point2dDouble(yp,-xp));
	if(mPublishComments){
	    cout<<"Free Point "<<xp<<" "<<yp<<" "<<mObstAvoidParam.FirstRot<<"   distance "<<dif<<" "<<dil<<endl;
	    /*for(int i=0;i<SafePath_a.size();i++)
		cout<<SafePath_a[i].mX<<endl;*/
	    cout<<"+++++++++++++++++++++++++++++++++++++++"<<SafePath_a.size()<<endl;
	    for(int i=0;i<SafePath_a.size();i++)
		cout<<SafePath_a[i].mY<<endl;
	}
	
	for(int i=0;i<SafePath_a.size();i++){
	    geometry_msgs::Pose ps;
	    ps.position.x=SafePath_a[i].mX;ps.position.y = SafePath_a[i].mY;
	    out.poses.push_back(ps);
	}
	
//cout<<"finishing GetAvoidancePath"<<endl;
return out;
}

VectorPointD GetNewPath::GenerateSmouthPath(geometry_msgs::PoseArray OriginalPath, VectorPointD SafePath,float alpha, float FirstTrans,geometry_msgs::Pose2D RobotPose)
{
//cout<<"starting GenerateSmouthPath"<<endl;
      VectorPointD temp;
      temp=SafePath;
      SafePath.clear();
      //first part
      for(int i=0;i<5;i++)//3 //0.5 metre
      {
	    SafePath.push_back(Point2dDouble(temp[0].mX+i*100, temp[0].mY));//10cm=100 mm
      }
      //second part
      for(int i=0;i<20;i++)//8 //3.5 to 4 metre metre
      {
	    float xp =i*(FirstTrans/20)*cos(alpha*3.14159/180)+temp[1].mX;//i*(100)*cos(alpha*3.14159/180)+temp[1].mX;
	    float yp =i*(FirstTrans/20)*sin(alpha*3.14159/180)+temp[1].mY;//i*(100)*sin(alpha*3.14159/180)+temp[1].mY;
	    SafePath.push_back(Point2dDouble(xp, yp));
      }
      //Third part (see the condition in .h file)
      VectorPointD SavevePathNew;
      //check if we can comme back the original path or not
      Point2dDouble p(0,0);
      Point2dDouble pmax(OriginalPath.poses[OriginalPath.poses.size()-1].position.x,OriginalPath.poses[OriginalPath.poses.size()-1].position.y);//end of the path
      p = TransformSinglePointToGlobalFrame(mPointFare,  RobotPose);
      //p.mX= mPointFare.mX+RobotPose.x*1000;
      //p.mY= mPointFare.mY+RobotPose.y*1000;
      //cout<<" WE CANT COOOOOOOOOOOOOOMMMMMMMMMMMMMMMMMMMMMMEEEEEEEEEEEEEEE BACK=====================: "<< mPointFare.mX/1000 <<" "<<" "<< mPointFare.mY/1000 <<" "<<DistanceTwoPointsk(p, pmax)<<endl;
      mPointFare = p;
      //TEST ONLY
      mPointFare = mClosestObsPointToRobot;
      //thsi used to find visible portion of the path
      mClosestObsPointToRobot = TransformSinglePointToGlobalFrame(mClosestObsPointToRobot, RobotPose);
     
      if(DistanceTwoPointsk(p, pmax)<2000){//3m
	mBackToOriginalPath=false;
	//cout<<" WE CAN DO it ---------------------------------------------------------------------------------------------------------------------------------------- "<< mPointFare.mX/1000 <<" "<<" "<< mPointFare.mY/1000 <<" "<<DistanceTwoPointsk(p, pmax)<<endl;
      }else {
	//cout<<" WE CAN DO it ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++: "<<DistanceTwoPointsk(p, pmax)<<endl;
	
      }
      
      //cout<<"  p "<<p.mX<<" : "<<p.mY<<endl;
      //cout<<"  pmax "<<pmax.mX<<" : "<<pmax.mY<<endl;
      //cout<<"  p "<<mPointFare.mX<<" : "<<mPointFare.mY<<endl;
      
      if(mBackToOriginalPath)
      {
	  //calculate the extrem point
	  if(SafePath.size()>0)
	    mPointExtreme = TransformSinglePointToGlobalFrame(SafePath[SafePath.size()-1],  RobotPose);
	  
	  Point2dDouble tp=SafePath[SafePath.size()-1];
	  for(int i=1;i<10;i++)//go forward by 1m
	  {
		SafePath.push_back(Point2dDouble(tp.mX+i*(FirstTrans/20), tp.mY));//SafePath.push_back(Point2dDouble(tp.mX+i*100, tp.mY));//10cm=100 mm SafePath.push_back(Point2dDouble(temp[2].mX+i*100, temp[2].mY));
	  }
	  
	  //transform the whole point of the safe path into global frame
	  SavevePathNew = TransformPathPointsToGlobalFrame(SafePath,  RobotPose);

	  //Fourth part
	  //find nearest point in the original path
	  float m=100000;
	  int Id=0;
	  float dis=0;
	  int SizeOrigP= OriginalPath.poses.size();
	  for(int i=1;i<SizeOrigP;i++)
	  {
		if(mUsedFarePointAfterObstacles){
		    float dx=p.mX-OriginalPath.poses[i].position.x;
		    float dy=p.mY-OriginalPath.poses[i].position.y;
		    dis=sqrt(dx*dx+dy*dy);
		    if(dis<=m) {
		      m=dis;Id=i;
		    }
		}else{
		    float dx=SavevePathNew[SavevePathNew.size()-1].mX-OriginalPath.poses[i].position.x;
		    float dy=SavevePathNew[SavevePathNew.size()-1].mY-OriginalPath.poses[i].position.y;
		    dis=sqrt(dx*dx+dy*dy);
		    if(dis<=m) {
		      m=dis;Id=i;
		    }
		}
	  }
	  if(mPublishComments)
	      cout<<SizeOrigP<<" Id "<<Id<<" dis: "<< dis<<endl;
	  Point2dDouble NesPoint(0,0);
	  bool stillpathExist=false;
	  if((Id+4)<SizeOrigP){
	      NesPoint.mX= OriginalPath.poses[Id+4].position.x; 
	      NesPoint.mY= OriginalPath.poses[Id+4].position.y;
	      stillpathExist=true;
	  }else{
	      NesPoint.mX= OriginalPath.poses[Id].position.x; 
	      NesPoint.mY= OriginalPath.poses[Id].position.y;
	  }

	  //decimate this path and add it to the original path
	  Point2dDouble ThisP=SavevePathNew[SavevePathNew.size()-1];
	  float ddx=NesPoint.mX-ThisP.mX;
	  float ddy=NesPoint.mY-ThisP.mY;
	  float dir=atan2(ddy, ddx);
	  //consider the direction of the robotic
	  dir=dir;//-RobotPose.theta;
	  if(mPublishComments)
		cout<<" dir "<<dir*180/3.14159<<endl;
	  for(int i=0;i<(int)(dis/100);i++)//8
	  {
		float xp =i*10*cos(dir)+ThisP.mX;
		float yp =i*10*sin(dir)+ThisP.mY;
		SavevePathNew.push_back(Point2dDouble(xp, yp));
	  }
	  
	  //continuetrhuought the path
	  if(stillpathExist){
	      for(int i=Id+4;i<SizeOrigP;i++)//8
	      {
		    SavevePathNew.push_back(Point2dDouble(OriginalPath.poses[i].position.x, OriginalPath.poses[i].position.y));
	      }
	  }else{
	      for(int i=Id;i<SizeOrigP;i++)//8
	      {
		    SavevePathNew.push_back(Point2dDouble(OriginalPath.poses[i].position.x, OriginalPath.poses[i].position.y));
	      }
	  }
      }
      else
      {
	//transform the whole point of the save path into global frame
	SavevePathNew = TransformPathPointsToGlobalFrame(SafePath,  RobotPose);
//cout<<"starting GenerateSmouthPath 1 "<<endl;
	//calculate the extrem point
	if(SavevePathNew.size()>0)
	  mPointExtreme=SavevePathNew[SavevePathNew.size()-1];
	
//cout<<"starting GenerateSmouthPath detecting problem 0: "<<SavevePathNew.size()<<endl;
	SavevePathNew.push_back(Point2dDouble(OriginalPath.poses[OriginalPath.poses.size()-1].position.x, OriginalPath.poses[OriginalPath.poses.size()-1].position.y));
//cout<<"starting GenerateSmouthPath detecting problem 1: "<<SavevePathNew.size()<<endl;
      }
      //SafePath.push_back(NesPoint);
      float xtst=SavevePathNew[SavevePathNew.size()-1].mX;
      float ytst=SavevePathNew[SavevePathNew.size()-1].mY;
//cout<<xtst<<" : "<<xtst<<" SavevePathNew size ===========##################################===========: "<<SavevePathNew.size()<<endl;
      VectorPointD SafePathback;
      DecimateLinek(SavevePathNew, SafePathback, 200, 200);
      VectorPointD SafePathOut;
      SafePathback = GenerateSmouthPathSecond(SafePathback);
      DecimateLinek(SafePathback, SafePathOut, 300, 200);
      if(mPublishComments)
	    cout<<" DistanceTwoPointsk ==================================================================: "<<endl;
      for (int i=0;i<SafePathOut.size()-1;i++){
	int d=DistanceTwoPointsk(SafePathOut[i],SafePathOut[i+1]);
	if(mPublishComments)
	    cout<<" inter point distance test: "<<d<<endl;
      }
      xtst=SafePathOut[SafePathOut.size()-1].mX;
      ytst=SafePathOut[SafePathOut.size()-1].mY;
//cout<<xtst<<" : "<<xtst<<" SafePathOut size ===========##################################===========: "<<SafePathOut.size()<<endl;

//cout<<"finishing GenerateSmouthPath"<<endl;
      return SafePathOut;//SafePathback;//SavevePathNew;//
}

bool GetNewPath::PathIsValid(Point2dDouble inP, geometry_msgs::Pose2D RobotPose){
  return true;
}

VectorPointD GetNewPath::GenerateSmouthPathSecond(VectorPointD SafePath)
{
//cout<<"starting GenerateSmouthPathSecond"<<endl;
 /* path = [[0, 0],
        [0, 1],
        [0, 2],
        [1, 2],
        [2, 2],
        [3, 2],
        [4, 2],
        [4, 3],
        [4, 2]]
    VectorPointD SafePath1;
    SafePath1.push_back(Point2dDouble(0,0));
    SafePath1.push_back(Point2dDouble(0,1));
    SafePath1.push_back(Point2dDouble(0,2));
    SafePath1.push_back(Point2dDouble(1,2));
    SafePath1.push_back(Point2dDouble(2,2));
    SafePath1.push_back(Point2dDouble(3,2));
    SafePath1.push_back(Point2dDouble(4,2));
    SafePath1.push_back(Point2dDouble(4,3));
    SafePath1.push_back(Point2dDouble(4,3));
*/
    // Make a deep copy of path into newpath
    float weight_data = 0.8;//0.5;
    float weight_smooth = 0.3;//0.1;
    VectorPointD out;

    int size=SafePath.size();
    float temp[size][2];
    float tempNew[size][2];
    for (int i=0;i<size;i++)
    {
      temp[i][0] = SafePath[i].mX/1000;
      temp[i][1] = SafePath[i].mY/1000;
      tempNew[i][0] = SafePath[i].mX/1000;
      tempNew[i][1] = SafePath[i].mY/1000;
    }
    SafePath.clear();
    //newpath = [[0 for row in range(len(path[0]))] for col in range(len(path))]
    //for i in range(len(path)):
    //    for j in range(len(path[0])):
    //        newpath[i][j] = path[i][j]
    //#for it in range(10)
    
    float tolerance=0.001;//0.000001;
    float change=tolerance;
    int inc=0;
    while (change>=tolerance)
    {   //cout<<" from GenerateSmouthPathSecond"<<endl;
       
        change=0.0;
	inc++;
        for (int i=1;i<size-1;i++){//i in range(1,len(path)-1):
            for (int j=0;j<2;j++){//j in range(len(path[0])):
                float aux=temp[i][j];
                tempNew[i][j] = tempNew[i][j]+weight_data*(temp[i][j]-tempNew[i][j]);
                tempNew[i][j] = tempNew[i][j]+weight_smooth*(tempNew[i+1][j]+tempNew[i-1][j]-2*tempNew[i][j]);
                change+=abs(aux-tempNew[i][j]);
		//if(inc==1)
		//cout<<" change i  "<<change<<endl;
	    }
	    //cout<<" i  "<<i<<endl;
	}
	 //cout<<change<<endl;
	 //if(inc==100) {cout<<inc<<endl;inc=0;}
	 if(inc>=10)break;//change=0.1;
    }
    //cout<<" change "<<change<<" size "<<size<<endl;
    
    out.resize(size);
    for (int i=0;i<size;i++)
    {
      //cout<<" i "<<i<<endl;
      out[i].mX=tempNew[i][0]*1000;
      out[i].mY=tempNew[i][1]*1000;

    }

 //cout<<"finishing GenerateSmouthPathSecond"<<endl;
    return out;//newpath # Leave this line for the grader!
 }

float GetNewPath::GetRobotOrientation(geometry_msgs::PoseStamped pMap)
{
  tf::Quaternion q(pMap.pose.orientation.x,pMap.pose.orientation.y,pMap.pose.orientation.z,pMap.pose.orientation.w);
  double yaw, pitch, roll;
  btMatrix3x3(q).getEulerYPR(yaw,pitch,roll);
  if(mPublishComments)
    cout<<" from GetRobotOrientation"<<endl;
  return yaw;
}

Point2dDouble GetNewPath::FromMMToMetre(Point2dDouble p)
{
    p.mX=p.mX*toMetre; p.mY=p.mY*toMetre;
    return p;
}

Point2dDouble GetNewPath::TransformSinglePointToGlobalFrame(Point2dDouble inP, geometry_msgs::Pose2D RobotPose)
{
      /*geometry_msgs::PoseArray*/
      Point2dDouble dets_map;
      //ets_map.resize(SafePath.size());
      
      float transR_to_Map[4][4];
      transR_to_Map[0][0]= cos(RobotPose.theta);transR_to_Map[0][1]=-sin(RobotPose.theta);transR_to_Map[0][2]=0;transR_to_Map[0][3]=RobotPose.x*1000;
      transR_to_Map[1][0]= sin(RobotPose.theta);transR_to_Map[1][1]=cos(RobotPose.theta); transR_to_Map[1][2]=0;transR_to_Map[1][3]=RobotPose.y*1000;
      transR_to_Map[2][0]= 0;                   transR_to_Map[2][1]= 0;                   transR_to_Map[2][2]=1;transR_to_Map[2][3]=0;
      transR_to_Map[3][0]= 0;                   transR_to_Map[3][1]= 0;                   transR_to_Map[3][2]=0;transR_to_Map[3][3]=1;

      float points_in_Robot[4][4];
      points_in_Robot[0][0]= 1; points_in_Robot[0][1]= 0; points_in_Robot[0][2]=0; points_in_Robot[0][3]=0;
      points_in_Robot[1][0]= 0; points_in_Robot[1][1]= 1; points_in_Robot[1][2]=0; points_in_Robot[1][3]=0;
      points_in_Robot[2][0]= 0; points_in_Robot[2][1]= 0; points_in_Robot[2][2]=1; points_in_Robot[2][3]=0;
      points_in_Robot[3][0]= 0; points_in_Robot[3][1]= 0; points_in_Robot[3][2]=0; points_in_Robot[3][3]=1;
  
      float points_in_Map[4][4];
      points_in_Map[0][0]= 1; points_in_Map[0][1]= 0; points_in_Map[0][2]=0; points_in_Map[0][3]=0;
      points_in_Map[1][0]= 0; points_in_Map[1][1]= 1; points_in_Map[1][2]=0; points_in_Map[1][3]=0;
      points_in_Map[2][0]= 0; points_in_Map[2][1]= 0; points_in_Map[2][2]=1; points_in_Map[2][3]=0;
      points_in_Map[3][0]= 0; points_in_Map[3][1]= 0; points_in_Map[3][2]=0; points_in_Map[3][3]=1;
  
      points_in_Robot[0][3]=inP.mX;
      points_in_Robot[1][3]=inP.mY;

      /*//TEST 
      if(i==dets_map.size()-1){
	  points_in_Robot[0][3]=2;
	  points_in_Robot[1][3]=2;
	  transR_to_Map[0][0]= cos(0.000261799166);transR_to_Map[0][1]=-sin(0.000261799166);transR_to_Map[0][2]=0;transR_to_Map[0][3]=0;
          transR_to_Map[1][0]= sin(0.000261799166);transR_to_Map[1][1]= cos(0.000261799166);transR_to_Map[1][2]=0;transR_to_Map[1][3]=0;
      }*/
      
      //transform all points
      for(int ii=0;ii<4;ii++)
	  for(int jj=0;jj<4;jj++)
	      for(int kk=0;kk<4;kk++)
		    points_in_Map[ii][jj]=points_in_Map[ii][jj]+(transR_to_Map[ii][kk]*points_in_Robot[kk][jj]);
      
      //get oints back
      dets_map.mX=points_in_Map[0][3];
      dets_map.mY=points_in_Map[1][3];

      /*//TEST 
      if(i==dets_map.size()-1){
	  cout<<" test transformation::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::: "<<dets_map[i].mX<<" y: "<<dets_map[i].mY<<endl;
      }*/
      
      //TEST
      /*if(dets_rob.objects[i].Closer<1000&&dets_rob.objects[i].Closer>800)
      {
	cout<<" objects in robot: "<<dets_rob.objects[i].xCent<<" y: "<<dets_rob.objects[i].yCent<<endl;
	cout<<" objects in   map: "<<dets_map.objects[i].xCent<<" y: "<<dets_map.objects[i].yCent<<endl;
      }*/
 
  
  return dets_map;
}
VectorPointD GetNewPath::TransformPathPointsToGlobalFrame(VectorPointD SafePath, geometry_msgs::Pose2D RobotPose)
{
  /*geometry_msgs::PoseArray*/
  VectorPointD dets_map;
  dets_map.resize(SafePath.size());
  
  float transR_to_Map[4][4];
  transR_to_Map[0][0]= cos(RobotPose.theta);transR_to_Map[0][1]=-sin(RobotPose.theta);transR_to_Map[0][2]=0;transR_to_Map[0][3]=RobotPose.x*1000;
  transR_to_Map[1][0]= sin(RobotPose.theta);transR_to_Map[1][1]=cos(RobotPose.theta); transR_to_Map[1][2]=0;transR_to_Map[1][3]=RobotPose.y*1000;
  transR_to_Map[2][0]= 0;                   transR_to_Map[2][1]= 0;                   transR_to_Map[2][2]=1;transR_to_Map[2][3]=0;
  transR_to_Map[3][0]= 0;                   transR_to_Map[3][1]= 0;                   transR_to_Map[3][2]=0;transR_to_Map[3][3]=1;

  float points_in_Robot[4][4];
  points_in_Robot[0][0]= 1; points_in_Robot[0][1]= 0; points_in_Robot[0][2]=0; points_in_Robot[0][3]=0;
  points_in_Robot[1][0]= 0; points_in_Robot[1][1]= 1; points_in_Robot[1][2]=0; points_in_Robot[1][3]=0;
  points_in_Robot[2][0]= 0; points_in_Robot[2][1]= 0; points_in_Robot[2][2]=1; points_in_Robot[2][3]=0;
  points_in_Robot[3][0]= 0; points_in_Robot[3][1]= 0; points_in_Robot[3][2]=0; points_in_Robot[3][3]=1;
 /*
  float points_in_Map[4][4];
  points_in_Map[0][0]= 1; points_in_Map[0][1]= 0; points_in_Map[0][2]=0; points_in_Map[0][3]=0;
  points_in_Map[1][0]= 0; points_in_Map[1][1]= 1; points_in_Map[1][2]=0; points_in_Map[1][3]=0;
  points_in_Map[2][0]= 0; points_in_Map[2][1]= 0; points_in_Map[2][2]=1; points_in_Map[2][3]=0;
  points_in_Map[3][0]= 0; points_in_Map[3][1]= 0; points_in_Map[3][2]=0; points_in_Map[3][3]=1;
  */
  
  for(int i=0;i<dets_map.size();i++)
  {
      float points_in_Map[4][4];
      points_in_Map[0][0]= 1; points_in_Map[0][1]= 0; points_in_Map[0][2]=0; points_in_Map[0][3]=0;
      points_in_Map[1][0]= 0; points_in_Map[1][1]= 1; points_in_Map[1][2]=0; points_in_Map[1][3]=0;
      points_in_Map[2][0]= 0; points_in_Map[2][1]= 0; points_in_Map[2][2]=1; points_in_Map[2][3]=0;
      points_in_Map[3][0]= 0; points_in_Map[3][1]= 0; points_in_Map[3][2]=0; points_in_Map[3][3]=1;


      points_in_Robot[0][3]=SafePath[i].mX;
      points_in_Robot[1][3]=SafePath[i].mY;

      /*//TEST 
      if(i==dets_map.size()-1){
	  points_in_Robot[0][3]=2;
	  points_in_Robot[1][3]=2;
	  transR_to_Map[0][0]= cos(0.000261799166);transR_to_Map[0][1]=-sin(0.000261799166);transR_to_Map[0][2]=0;transR_to_Map[0][3]=0;
          transR_to_Map[1][0]= sin(0.000261799166);transR_to_Map[1][1]= cos(0.000261799166);transR_to_Map[1][2]=0;transR_to_Map[1][3]=0;
      }*/
      
      //transform all points
      for(int ii=0;ii<4;ii++)
	  for(int jj=0;jj<4;jj++)
	      for(int kk=0;kk<4;kk++)
		    points_in_Map[ii][jj]=points_in_Map[ii][jj]+(transR_to_Map[ii][kk]*points_in_Robot[kk][jj]);
      
      //get oints back
      dets_map[i].mX=points_in_Map[0][3];
      dets_map[i].mY=points_in_Map[1][3];

      /*//TEST 
      if(i==dets_map.size()-1){
	  cout<<" test transformation::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::: "<<dets_map[i].mX<<" y: "<<dets_map[i].mY<<endl;
      }*/
      
      //TEST
      /*if(dets_rob.objects[i].Closer<1000&&dets_rob.objects[i].Closer>800)
      {
	cout<<" objects in robot: "<<dets_rob.objects[i].xCent<<" y: "<<dets_rob.objects[i].yCent<<endl;
	cout<<" objects in   map: "<<dets_map.objects[i].xCent<<" y: "<<dets_map.objects[i].yCent<<endl;
      }*/
  }
  
  return dets_map;
}
//NOTE ths method is not used but we keep it
/*
but_laser_segment::LaserObjectArray GetNewPath::TransformFrame(but_laser_segment::LaserObjectArray dets_rob, geometry_msgs::PoseStamped robotInMap, float ro)
{
  but_laser_segment::LaserObjectArray dets_map=dets_rob;
  float transR_to_Map[4][4];
  transR_to_Map[0][0]= sin(ro);transR_to_Map[0][1]=cos(ro);transR_to_Map[0][2]=0;transR_to_Map[0][3]=robotInMap.pose.position.x;
  transR_to_Map[1][0]=-cos(ro);transR_to_Map[1][1]=sin(ro);transR_to_Map[1][2]=0;transR_to_Map[1][3]=robotInMap.pose.position.y;
  transR_to_Map[2][0]= 0;      transR_to_Map[2][1]= 0;     transR_to_Map[2][2]=1;transR_to_Map[2][3]=0;
  transR_to_Map[3][0]= 0;      transR_to_Map[3][1]= 0;     transR_to_Map[3][2]=0;transR_to_Map[3][3]=1;

  float points_in_Robot[4][4];
  points_in_Robot[0][0]= 1; points_in_Robot[0][1]= 0; points_in_Robot[0][2]=0; points_in_Robot[0][3]=0;
  points_in_Robot[1][0]= 0; points_in_Robot[1][1]= 1; points_in_Robot[1][2]=0; points_in_Robot[1][3]=0;
  points_in_Robot[2][0]= 0; points_in_Robot[2][1]= 0; points_in_Robot[2][2]=1; points_in_Robot[2][3]=0;
  points_in_Robot[3][0]= 0; points_in_Robot[3][1]= 0; points_in_Robot[3][2]=0; points_in_Robot[3][3]=1;
  
  float points_in_Map[4][4];
  points_in_Map[0][0]= 1; points_in_Map[0][1]= 0; points_in_Map[0][2]=0; points_in_Map[0][3]=0;
  points_in_Map[1][0]= 0; points_in_Map[1][1]= 1; points_in_Map[1][2]=0; points_in_Map[1][3]=0;
  points_in_Map[2][0]= 0; points_in_Map[2][1]= 0; points_in_Map[2][2]=1; points_in_Map[2][3]=0;
  points_in_Map[3][0]= 0; points_in_Map[3][1]= 0; points_in_Map[3][2]=0; points_in_Map[3][3]=1;
  
  for(int i=0;i<dets_rob.objects.size();i++)
  {
      float points_in_Map[4][4];
      for(int j=0;j<3;j++)//3 points f, l and the center
      {
	  points_in_Map[0][0]= 1; points_in_Map[0][1]= 0; points_in_Map[0][2]=0; points_in_Map[0][3]=0;
	  points_in_Map[1][0]= 0; points_in_Map[1][1]= 1; points_in_Map[1][2]=0; points_in_Map[1][3]=0;
	  points_in_Map[2][0]= 0; points_in_Map[2][1]= 0; points_in_Map[2][2]=1; points_in_Map[2][3]=0;
	  points_in_Map[3][0]= 0; points_in_Map[3][1]= 0; points_in_Map[3][2]=0; points_in_Map[3][3]=1;
	  if(j==0){ 
	    points_in_Robot[0][3]=dets_rob.objects[i].xFirst;
	    points_in_Robot[1][3]=dets_rob.objects[i].yFirst;
	  }
	  
	  if(j==1){
	    points_in_Robot[0][3]=dets_rob.objects[i].xCent;
	    points_in_Robot[1][3]=dets_rob.objects[i].yCent;
	  }
	  if(j==2){
	    points_in_Robot[0][3]=dets_rob.objects[i].xLast;
	    points_in_Robot[1][3]=dets_rob.objects[i].yLast;
	  }   

	  //transform all points
	  for(int ii=0;ii<4;ii++)
	      for(int jj=0;jj<4;jj++)
		  for(int kk=0;kk<4;kk++)
			points_in_Map[ii][jj]=points_in_Map[ii][jj]+(transR_to_Map[ii][kk]*points_in_Robot[kk][jj]);
	  
	  //get oints back
	  if(j==0){
	    dets_map.objects[i].xFirst=points_in_Map[0][3];
	    dets_map.objects[i].yFirst=points_in_Map[1][3];
	    
	  }
	  if(j==1){
	    dets_map.objects[i].xCent=points_in_Map[0][3];
	    dets_map.objects[i].yCent=points_in_Map[1][3];
	    dets_map.objects[i].Closer=sqrt(points_in_Map[0][3]*points_in_Map[0][3]+points_in_Map[1][3]*points_in_Map[1][3]);
	  }
	  if(j==2){
	    dets_map.objects[i].xLast=points_in_Map[0][3];
	    dets_map.objects[i].yLast=points_in_Map[1][3];
	  }   
      }
      //TEST
      //if(dets_rob.objects[i].Closer<1000&&dets_rob.objects[i].Closer>800)
      //{
	//cout<<" objects in robot: "<<dets_rob.objects[i].xCent<<" y: "<<dets_rob.objects[i].yCent<<endl;
	//cout<<" objects in   map: "<<dets_map.objects[i].xCent<<" y: "<<dets_map.objects[i].yCent<<endl;
      //}
  }
  
  return dets_map;
}
*/
Point2dDouble GetNewPath::DistanceToLinek(const Point2dDouble ff, const Point2dDouble cc, const Point2dDouble ll)
{
	Point2dDouble OutPut(0,0);
	
	double U=((cc.mX-ff.mX)*(ll.mX-ff.mX)+(cc.mY-ff.mY)*(ll.mY-ff.mY))/(pow(DistanceTwoPointsk(ff,ll),2));
	OutPut.mX= ff.mX+U*(ll.mX-ff.mX);
	OutPut.mY = ff.mY+U*(ll.mY-ff.mY);
	
	return OutPut;
}
double GetNewPath::DistancePointToLinek(const Point2dDouble ff, const Point2dDouble cc, const Point2dDouble ll)
{
	Point2dDouble OutPut(0,0);
	
	double U=((cc.mX-ff.mX)*(ll.mX-ff.mX)+(cc.mY-ff.mY)*(ll.mY-ff.mY))/(pow(DistanceTwoPointsk(ff,ll),2));
	OutPut.mX= ff.mX+U*(ll.mX-ff.mX);
	OutPut.mY = ff.mY+U*(ll.mY-ff.mY);
	
	double dist = DistanceTwoPointsk(OutPut, cc);
	
	return dist;
}
double GetNewPath::DistanceTwoPointsk(const double xCurrLaser, const double yCurrLaser)
{
	double currDis=sqrt(pow((xCurrLaser), 2) + pow((yCurrLaser), 2));
	return currDis;
}
double GetNewPath::DistanceTwoPointsk(const Point2dDouble firstPoint, const Point2dDouble lastPoint)
{
	return DistanceTwoPointsk(lastPoint.mX-firstPoint.mX, lastPoint.mY-firstPoint.mY);
}
double GetNewPath::AngleDistanceTwoPointsk(const double x, const double y)
{
	double currAngle=atan2(x, y);
	return currAngle;
}
double GetNewPath::MinArrayk(const std::vector<double> & InputArr)
{
	double mavToReturn = *min_element(InputArr.begin(), InputArr.end());
	return mavToReturn;
}

int GetNewPath::ThisElementArray(VectorPointD mCircleObjDisOri, double ThisVal)
{
	int nSize=/*InputArr*/mCircleObjDisOri.size();
	int thisElmentWhichIsMax;
	
	/*for(int i=0;i<nSize;i++){
		double Currval=mCircleObjDisOri[i].Closer;
		double ThisVDiff = Currval-ThisVal;
		if(ThisVDiff==0){
			thisElmentWhichIsMax=i;
			i=nSize-1;
		}
	}*/
	return thisElmentWhichIsMax;
}

int GetNewPath::ThisElementArray(std::vector<double> InPutArray, double ThisVal)
{
	int nSize=InPutArray.size();
	int thisElmentWhichIsMax;
	
	for(int i=0;i<nSize;i++){
		double Currval= InPutArray[i];
		double ThisVDiff = Currval-ThisVal;
		if(ThisVDiff==0){
			thisElmentWhichIsMax=i;
			i=nSize-1;
		}
	}
	return thisElmentWhichIsMax;
}

void GetNewPath::DecimateLinek(const VectorPointD & vect, VectorPointD & res, double distMin, double distMaxOnLine)
{
	if (vect.size()<3) return;
	int indFirst=0;
	int indLast=2;
	double dist=0;
	int i=0;
	Point2dDouble pt((int)vect[0].mX, (int)vect[0].mY);
	res.push_back(pt);
	while (indLast<vect.size())
	{
		bool tooFar=false;
		for (i=(indFirst+1); i<indLast; i++)
		{
			dist = DistancePointToLinek(vect[indFirst], vect[i], vect[indLast]);
			if (dist>distMin)
			{
				tooFar = true;
				break;
			}
			// Set a maximum distance between 2 points on the line
			if (!tooFar && distMaxOnLine>0)
			{
				double distOnLine = DistanceTwoPointsk(vect[indFirst], vect[indLast]);
				if (distOnLine>=distMaxOnLine)
				{
					tooFar = true;
				}
			}
		}
		if (tooFar==false)
		{
			indLast++;
		}
		else
		{		
			res.push_back(vect[indLast-1]);
			indFirst=indLast-1;
			indLast=indFirst+2;
		}
	}
	res.push_back(vect[vect.size()-1]);
}

bool GetNewPath::found(std::vector<int> ve, int thisV)
{
        typedef std::vector<int> IntContainer;

        typedef IntContainer::iterator IntIterator;

	IntContainer vw;
	for(int i=0;i<ve.size();i++){
	   vw.push_back(ve[i]);
	}
        // find 5
        IntIterator i = find(vw.begin(), vw.end(), thisV);

        if (i != vw.end()) {
	  
          return true;
        }
        
        return false;
}