/**
 * ***************************************************************************
 * \file
 *
 * $Id:$
 *
 * Copyright (C) Brno University of Technology
 *
 * This file is part of software developed by dcgm-robotics@FIT group.
 *
 * Author: Khelifa Baizid (baizid.khelifa@gmail.com)
 * Supervised by: Vitezslav Beran (beranv@fit.vutbr.cz), Michal Spanel (spanel@fit.vutbr.cz)
 * Date: 19/11/2012
 *
 * This file is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This file is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this file.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef BUT_PATH_NODE_H
#define BUT_PATH_NODE_H
#include <ros/ros.h>
#include <data_bridge/definitions.h>
#include <data_bridge/DTB_Trajectory.h>
#include <data_bridge/DTB_Odometry.h>
//#include <data_bridge/DTB_ObjReport.h>
#include <geometry_msgs/PoseStamped.h>
#include <geometry_msgs/Pose.h>
#include <geometry_msgs/PoseArray.h>

#include <vector>
#include <string>
#include <visualization_msgs/Marker.h>
#include <visualization_msgs/MarkerArray.h>
#include <tf/transform_listener.h>

#include <nav_msgs/OccupancyGrid.h>
# include <nav_msgs/Path.h>

#include <but_object_localization/GetFusedObjects.h>
#include <but_object_localization/services_list.h>
//#include "but_path_node/GeneratePath.h"
#include <but_path_node/GetNewPath.h>

#include <tf/transform_broadcaster.h>
//#include <turtlesim/Pose.h>


struct st{
	bool requestAlreadyReceived, therIsSolution, obstaclesAreFareFromRobot, avoidancePathWasCalculated, noObstaclesFromLocalizationModule, RequestIsNotValid,firstRequest, weHaveSafePath;
	geometry_msgs::Pose2D robotLocationForThisPath;
	float pathScoor;
};

class but_path_node
{
	public:
		but_path_node(/*bool ShowObstacles, bool PublishComments*/);
		~but_path_node();

		/*FRAME OF THE ROBOT
		   x
		y__| 
		*/

		//ros::Subscriber get_robot_location;//NOTE NOT USED BUT WE KEEP IT
		//data_bridge Subscriber
		ros::Subscriber convertor_subscriber_trajectory;
		//data_bridge Publisher
		ros::Publisher convertor_publisher_trajectory;
		//Publisher of the free point calculated by the algorithm 
		ros::Publisher ShowExtPoint_pub;
		//Publisher of the obstacles in rviz 
		ros::Publisher obstacles_pub;
		//Publisher of the original path in rviz 
		ros::Publisher show_Orig_Path_pub;
		//Publisher of the save path in rviz 
		ros::Publisher show_Save_Path_pub;

		//node
		ros::NodeHandle n;
		//publish Comments
		bool mPublishCommt;
		//showing the obstacles in rviz or not: this flag is defined in the launch file
		bool mShowObstacles;
		//min distance to consider the obstacles
		double mMinDistanceToObstacles;
		//only for testing NOT for the real scienario
		bool mTesting;
		//come back to the original path
  		bool mComeBackToOriginalPath;
		//mMinMaxCorredor
		double mMinMaxOfCorredor;
		//LGV size
		double mLGV_size;
		//put obstacle in the why of the robot
		bool mPutObst;
		//use incremental position of the robot, but not from the object localization node
		bool mUseIncrementalRobPos;
		
		int mIncrementalRobPos;
		//use the safe mode means outputing only the safe part of the path
		bool mUseSafePathMode;
		
		//frame that the output paths define in
		std::string mFrame;
		//
		double mAvoidancePathLength;
		//if the path is over the siz specified by mAvoidancePathLength
		bool mOverSize;
	protected:
	  
		//****************** [Global var] ********************
		//geometry_msgs::PoseArray recalculateNewOriginalpath(geometry_msgs::PoseArray  mOriginalTrj_real, geometry_msgs::Pose2D robotPose);
		void intFunc();
		void publishObstacle(VectorPointD xy, VectorPointD dim);
		std::vector<mObstacleSize> getObstaclesInTheWay_real(geometry_msgs::PoseArray originalTrj, std::vector<int> IDs, std::vector<but_object_localization::FusedObject> localized_objects);
		
		std::vector<mObstacleSize> getObstaclesInTheWay_real_safepathMode(geometry_msgs::PoseArray originalTrj, std::vector<int> IDs, std::vector<but_object_localization::FusedObject> localized_objects);

		void poseCallback(geometry_msgs::Pose2D msg);
		void publish_original_path();
		void outputingOriginalPath();
		void Out_put_safe_path(std::string mode);
		//WE NEED THIS METHOD ONLY IN TESTING BECAUSE THE PATH COMMINH FROM THE LGV SHOULD BE STARTING FROM THE CURRENT LOCATION OF THE ROBOT
		//TODO WE ARE NOT USING THIS METHOD BUT WE KEEP IT
		std::vector<but_object_localization::FusedObject> getAndvisulizeObstacles();
		void convertor_trajectory_callback(data_bridge::DTB_Trajectory message);
		//TODO THIS METHOD IS NOT USED BUT WE KEEP IT
		//bool TEST_COM_WITH_OBJECT_LOCALZ=false;
		void get_robot_location_callback(data_bridge::DTB_Odometry msgOdm);
		
		//decimate the original path
		std::vector<geometry_msgs::Pose2D> calculateOriginalPath(geometry_msgs::PoseArray pathIn);
		//position and orientation of the robot and the goal in the MAP frame
		
		//this function returns the safe and visible portion for the LGV
		Point2dDouble /*geometry_msgs::PoseArray*/ safePortionOfThePath( geometry_msgs::PoseArray inputPath, std::vector<mObstacleSize> curr_obst_real);
		
		//this function connects the robot location to the original first path
		void ConnectRobotPoseToOriginalPath();
		//this function check the intersection between two segment defined by 4 points
		bool intersection(Point2dDouble p1, Point2dDouble p2, Point2dDouble p3, Point2dDouble p4);
		
		//check if the path save and inside the coredoor
		bool pathCkech();
		geometry_msgs::Pose2D mRobotLocationMap;
		//true if the robot location in the map frame was received
		//bool mThereIsRobotLocation=true;//NOTE this flag is not used but we keep it
		//if any ask for new path 
                //bool mGetingRobotLocation;//NOTE this flag is not used but we keep it
		//bool mWaitingForEnvirPerception;//NOTE this flag is not used but we keep it
		//IDs of coming request
		std::vector<int> mIDs;
		//state of the node
		st State;

		//free point calculated by the algorithm it is always on the left part of the robot
		geometry_msgs::PoseStamped mAvoidPoseToShow_pose;

		//Obstacles to be published
		visualization_msgs::MarkerArray markerAr;

		//original path
		geometry_msgs::PoseArray mOriginalTrj_real;
		
		//original first path
		geometry_msgs::PoseArray  mFirstOriginalTraj;

		//original first path
		geometry_msgs::PoseArray  mFirstSafeTraj;
		
		//safe Portion of the path
		geometry_msgs::PoseArray  mSafePortionPath;
		
		//Previous mode
		std::string  mPrevMode;
		
		//GetNewpath
		GetNewPath *mGs;

		//new avoidance path message
		data_bridge::DTB_Trajectory messagePUB;

		//iter how many times this function is caled
		int inctest;
};


#endif // BUT_PATH_NODE_H
