/**
 * ***************************************************************************
 * \file
 *
 * $Id:$
 *
 * Copyright (C) Brno University of Technology
 *
 * This file is part of software developed by dcgm-robotics@FIT group.
 *
 * Author: Khelifa Baizid (baizid.khelifa@gmail.com)
 * Supervised by: Vitezslav Beran (beranv@fit.vutbr.cz), Michal Spanel (spanel@fit.vutbr.cz)
 * Date: 19/11/2012
 *
 * This file is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This file is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this file.  If not, see <http://www.gnu.org/licenses/>.
 */
#ifndef GETNEWPATH_H
#define GETNEWPATH_H

#include <ros/ros.h>
//#include <move_base_msgs/MoveBaseAction.h>
//#include <actionlib/client/simple_action_client.h>
#include <geometry_msgs/PoseStamped.h>
#include <geometry_msgs/Pose.h>
#include <geometry_msgs/PoseArray.h>
#include <geometry_msgs/Pose2D.h>

#include <vector>
#include <string>
#include <algorithm>
#include <math.h>
#include <stdio.h>
#include <iostream>
#include <fstream>
#include <time.h>

#include <boost/thread.hpp>
#include <boost/bind.hpp>

#include <tf/transform_listener.h>
#include <tf/tf.h>
#include "tf/message_filter.h"
#include <sensor_msgs/LaserScan.h>
#include "std_msgs/String.h"
//#include "but_path_node/GeometryTools.h"
#include "but_path_node/Primitives.h"
//#include "but_path_node/RrtPathPlanner.h"

//#include <but_laser_segment/LaserObject.h>
//#include <but_laser_segment/LaserObjectArray.h>

//#include <nav_msgs/GetMap.h>
#include <nav_msgs/OccupancyGrid.h>
// OpenCV is available within a vision_opencv ROS stack
#include <opencv2/highgui/highgui.hpp>
#include <opencv2/imgproc/imgproc.hpp>
//#include <cv_bridge/cv_bridge.h>


//#include <geometry_msgs/Twist.h>


//class PathPlanner; NOTE CAN BE USED FOR THE RRT

/*struct LaserDataLocal
{
  short nb;
  std::vector<Point2dDouble> data; 
  
};*/

struct mObstSafetySruc
{
 geometry_msgs::PointStamped f, l;
};
//this stru define obstacle paramaters
struct mObstacleStru
{
 geometry_msgs::PoseStamped c; 
 float size;
};

//this stru defines obstacle paramaters
struct mObstacleSize
{
 Point2dDouble f, l, c, maxp;//mm
 short Class;//mm
 float Dir;//Deg
 float Size; int Closer;//mm
 float Depth; //mm from the curent tobt position
};

struct LaserObstacleAvoidnessParts
{
	double FirstRot, FirstTrans, SecondRot, SecondTrans;
};

class GetNewPath
{
	public:
		GetNewPath(float W=20, float H=20, float R=0.05);
		~GetNewPath();

		//VectorPointD GetPath(geometry_msgs::PoseStamped Orig, geometry_msgs::PoseStamped Goal);
		geometry_msgs::PoseArray GetAvoidancePath(geometry_msgs::PoseArray OriginalPath, /*geometry_msgs::PoseStamped*/ geometry_msgs::Pose2D Orig, std::vector<mObstacleSize> mCircleObjDisOri);
		//VectorPointD pathPlan();
		//double testkk(double inp);
		
		//but_laser_segment::LaserObjectArray TransformFrame(but_laser_segment::LaserObjectArray detections_rob, geometry_msgs::PoseStamped robotInMap, float robotOeintation);
		
		//get the safe path into global framce
		VectorPointD TransformPathPointsToGlobalFrame(/*geometry_msgs::PoseArray OriginalPath,*/ VectorPointD SafePath, geometry_msgs::Pose2D RobotPose);
		
		//get robot orientation
		float GetRobotOrientation(geometry_msgs::PoseStamped pMap);
		
		//vecotor contacins all objects
	        //std::vector<mObstSafetySruc> mExistingObjects;
		//VectorPointD mExistingObstaclesForRRT;
		//bool mFirstUpdate;
		//chage a vector of point from map framce to RRT frame
		/*rrt frame
		x
		|__ y
		
		   x
		y__| 
		*/
		//Point2dDouble MapFrameToRRT(Point2dDouble p);
		//from mm to metre
		Point2dDouble FromMMToMetre(Point2dDouble p);
		//Point2dDouble RRTFrameToMap(Point2dDouble p);
		//add obstacle for rrt
		//void AddObstacles(mObstSafetySruc fl, bool checkThisPoint=false);
		//return new if there are new objects
		//bool UpdateObjects(but_laser_segment::LaserObjectArray detected_objects_in_map);
		//bool mThereAreObjects;
		
		//float mMapW, mMapH, mMapR;
		
		bool mThereIsAvoidPath;
		
		int ThisElementArray(VectorPointD InputArr, double ThisVal);
		int ThisElementArray(std::vector<double> InPutArray, double ThisVal);
	        //calculate the dist perpendicular to a segments
		double DistancePointToLinek(const Point2dDouble ff, const Point2dDouble cc, const Point2dDouble ll);
		//calculate the point cc perpendicular to a segments
		Point2dDouble DistanceToLinek(const Point2dDouble ff, const Point2dDouble cc, const Point2dDouble ll);
		//calculate the dist between 2 point
		double DistanceTwoPointsk(const Point2dDouble firstPoint, const Point2dDouble lastPoint);
		//calculate the dist between 2 point
		double DistanceTwoPointsk(const double xCurrLaser, const double yCurrLaser);
		//calculate the direction between 2 point
		double AngleDistanceTwoPointsk(const double x, const double y);
		//min value in this array
		double MinArrayk(const std::vector<double> & InputArr);
		//Decimating path to segments
		void DecimateLinek(const VectorPointD & vect, VectorPointD & res, double distMin, double distMaxOnLine);
		//checking if this element is in this vector
		bool found(std::vector<int> ve, int thisV);
		//smouthing fuction
		VectorPointD GenerateSmouthPathSecond(VectorPointD SafePath);
		//point extrem to see how the LGV is able to avoid obstacle
		Point2dDouble mPointFare;
		//point fare to be used to cam back to the original path
		Point2dDouble mPointExtreme;
		//mmin distance to cosidr obstacles
		double mSecurityDis;
		//mUsedFarePointAfterObstacles
		bool mUsedFarePointAfterObstacles;
		//calculate the oath back to the original path
		bool mBackToOriginalPath;
		
		Point2dDouble mClosestObsPointToRobot;
	protected:
	  
		//trasform point and vectors from robot frame to global frame
	        VectorPointD GenerateSmouthPath(geometry_msgs::PoseArray OriginalPath, VectorPointD SafePath, float alpha, float distanceToThisDirection, geometry_msgs::Pose2D RobotPose);
		
		Point2dDouble TransformSinglePointToGlobalFrame(Point2dDouble inP, geometry_msgs::Pose2D RobotPose);
               //if the lath is valid inside the limites
		bool PathIsValid(Point2dDouble inP, geometry_msgs::Pose2D RobotPose);
		
		std::vector<mObstacleStru> mObstacleInTheWay();
		//VectorPointD getObstFromFile();
		//void getBorders();
	  
		//PathPlanner * mPathPlanner;//NOTE OR THE RRT LATER
		
// 		//PathPlanner * mRRTPathPlanner;
		
		//int spline();
		bool mPublishComments;
		

};


#endif // GETNEWPATH_H
