/*******************************************************\
* Copyright (C) 2006, ApS s.r.o Brno, AllRightsReserved *
\*******************************************************/

#ifndef CODASIPSUBTARGET_H
#define CODASIPSUBTARGET_H

#include "llvm/Target/TargetSubtargetInfo.h"
#include "llvm/Target/TargetMachine.h"

#include <string>

#define GET_SUBTARGETINFO_ENUM
#define GET_SUBTARGETINFO_HEADER
#include "CodasipGenSubtargetInfo.inc"

namespace llvm {
  
  class CodasipSubtarget: public CodasipGenSubtargetInfo {
    
    protected:
      InstrItineraryData InstrItins;
    
    public:
      /// This constructor initializes the data members to match that
      /// of the specified module.
      CodasipSubtarget(const std::string &TT, const std::string &FS);
      
      /// ParseSubtargetFeatures - Parses features string setting specified
      /// subtarget options. Definition of function is auto generated by tblgen.
      void ParseSubtargetFeatures(StringRef CPU, StringRef FS);

    private:
      /// this is here because llvm 2.8 wants some subtarget features
      bool codasip;
  };
  
}

#endif
