/*******************************************************\
* Copyright (C) 2006, ApS s.r.o Brno, AllRightsReserved *
\*******************************************************/

#define DEBUG_TYPE "codasip-reg-info"

#include "llvm/Function.h"
#include "llvm/ADT/BitVector.h"
#include "llvm/ADT/StringRef.h"
#include "llvm/CodeGen/MachineFunction.h"
#include "llvm/CodeGen/MachineFrameInfo.h"
#include "llvm/CodeGen/MachineRegisterInfo.h"
#include "llvm/CodeGen/MachineInstrBuilder.h"
#include "llvm/Support/Debug.h"
#include "llvm/Support/raw_ostream.h"
#include "llvm/Target/TargetFrameLowering.h"
#include "llvm/Target/TargetInstrInfo.h"
#include "llvm/Target/TargetMachine.h"
#include "llvm/Target/TargetOptions.h"

#include "CodasipMachineFunction.h"
#include "CodasipGenRegisterInfo.h"
#include "CodasipInstrInfo.h"

#define GET_REGINFO_TARGET_DESC
#include "CodasipGenRegisterInfo.inc"

#include <cstdio>

using namespace llvm;

CodasipGen2RegisterInfo::CodasipGen2RegisterInfo(const TargetInstrInfo &tii)
: CodasipGenRegisterInfo(0/*RA*/), TII(tii) {}

const unsigned int* CodasipGen2RegisterInfo::getCalleeSavedRegs(const MachineFunction *MF) const
{
  assert(false && "this is not allowed");
  static const unsigned CalleeSavedRegs[] = {0};
  return CalleeSavedRegs;
}

BitVector CodasipGen2RegisterInfo::getReservedRegs(const MachineFunction &MF) const
{
  BitVector Reserved(getNumRegs());
  
  //Reserved.set(Codasip::gpregs_1);

  return Reserved;
}

// rearrange if out of bounds
void CodasipGen2RegisterInfo::eliminateFrameIndex(MachineBasicBlock::iterator II, int SPAdj, RegScavenger *RS) const
{
  assert(false && "this is not allowed");
}

int CodasipGen2RegisterInfo::getDwarfRegNum(unsigned RegNum, bool isEH) const
{
  return RegNum;
}

// (base pointer)
unsigned CodasipGen2RegisterInfo::getFrameRegister(const MachineFunction &MF) const
{
  assert(false && "this is not allowed");
  // base pointer
  //return Codasip::gpregs_2;
}

// (return address register - like on mips)
unsigned CodasipGen2RegisterInfo::getRARegister() const
{
  assert(false && "this is not allowed");
  //return Codasip::gpregs_31;
}

// we detect only one pointer class
const TargetRegisterClass* CodasipGen2RegisterInfo::getPointerRegClass(unsigned Kind) const
{
  assert(false && "is this allowed?");
  return &Codasip::gpregsRegClass;
}

// eliminate call start/end (and other things)
void CodasipGen2RegisterInfo::eliminateCallFramePseudoInstr(MachineFunction &MF, MachineBasicBlock &MB, MachineBasicBlock::iterator II) const
{
  assert(false && "this is not allowed");
}

