/*******************************************************\
* Copyright (C) 2006, ApS s.r.o Brno, AllRightsReserved *
\*******************************************************/

#include "MCTargetDesc/CodasipMCAsmInfo.h"
#include "CodasipTargetMachine.h"
#include "llvm/Module.h"
#include "llvm/PassManager.h"
#include "llvm/Support/TargetRegistry.h"
#include "llvm/CodeGen/Passes.h"

using namespace llvm;

// called from llc::main
extern "C" void LLVMInitializeCodasipTarget() {
  RegisterTargetMachine<CodasipTargetMachine> X(TheCodasipTarget);
}

// note: data defined here will be (in an encapsulated way) used by constructors of other objects
CodasipTargetMachine::CodasipTargetMachine
(const Target &T, StringRef &TT, StringRef &FS, StringRef &CPU, Reloc::Model RM, CodeModel::Model CM)
: LLVMTargetMachine(T,TT,CPU,FS,RM,CM), Subtarget(TT,FS), DataLayout( "E-p:32:32:32" ), InstrInfo(*this),
  FrameInfo(*this), TLInfo(*this), TSInfo(*this) {}

// Register DAG2DAG pass.
bool CodasipTargetMachine::addInstSelector(PassManagerBase &PM, CodeGenOpt::Level OptLevel)
{
  PM.add(createCodasipISelDag(*this));
  return false;
}

bool CodasipTargetMachine::addPreRegAlloc(PassManagerBase &PM, CodeGenOpt::Level OptLevel)
{
  //add peephole optimaliser here
  return false;
}

// pre-emit pass: vliw_scheduler
bool CodasipTargetMachine::addPreEmitPass(PassManagerBase &PM, CodeGenOpt::Level OptLevel)
{
  PM.add(createCodasipDelaySlotFillerPass(*this));
  
  return true;
}
