//===- TableGen'erated file -------------------------------------*- C++ -*-===//
//
// DAG Instruction Selector for the Codasip target
//
// Automatically generated file, do not edit!
//
//===----------------------------------------------------------------------===//

// *** NOTE: This file is #included into the middle of the target
// *** instruction selector class.  These functions are really methods.

// The main instruction selector code.
SDNode *SelectCode(SDNode *N) {
  // Some target values are emitted as 2 bytes, TARGET_VAL handles
  // this.
  #define TARGET_VAL(X) X & 255, unsigned(X) >> 8
  static const unsigned char MatcherTable[] = {
/*0*/     OPC_SwitchOpcode /*21 cases */, 61,  TARGET_VAL(ISD::SRA),// ->65
/*4*/       OPC_Scope, 46, /*->52*/ // 2 children in Scope
/*6*/         OPC_MoveChild, 0,
/*8*/         OPC_CheckOpcode, TARGET_VAL(ISD::SHL),
/*11*/        OPC_RecordChild0, // #0 = $op1in
/*12*/        OPC_MoveChild, 1,
/*14*/        OPC_Scope, 17, /*->33*/ // 2 children in Scope
/*16*/          OPC_CheckInteger, 24, 
/*18*/          OPC_MoveParent,
/*19*/          OPC_MoveParent,
/*20*/          OPC_MoveChild, 1,
/*22*/          OPC_CheckInteger, 24, 
/*24*/          OPC_MoveParent,
/*25*/          OPC_MorphNodeTo, TARGET_VAL(Codasip::i_ext__opc_sext8__rmem__rmem__), 0,
                    1/*#VTs*/, MVT::i32, 1/*#Ops*/, 0, 
                // Src: (sra:i32 (shl:i32 gpregs:i32:$op1in, 24:i32), 24:i32) - Complexity = 16
                // Dst: (i_ext__opc_sext8__rmem__rmem__:i32 gpregs:i32:$op1in)
/*33*/        /*Scope*/ 17, /*->51*/
/*34*/          OPC_CheckInteger, 16, 
/*36*/          OPC_MoveParent,
/*37*/          OPC_MoveParent,
/*38*/          OPC_MoveChild, 1,
/*40*/          OPC_CheckInteger, 16, 
/*42*/          OPC_MoveParent,
/*43*/          OPC_MorphNodeTo, TARGET_VAL(Codasip::i_ext__opc_sext32__rmem__rmem__), 0,
                    1/*#VTs*/, MVT::i32, 1/*#Ops*/, 0, 
                // Src: (sra:i32 (shl:i32 gpregs:i32:$op1in, 16:i32), 16:i32) - Complexity = 16
                // Dst: (i_ext__opc_sext32__rmem__rmem__:i32 gpregs:i32:$op1in)
/*51*/        0, /*End of Scope*/
/*52*/      /*Scope*/ 11, /*->64*/
/*53*/        OPC_RecordChild0, // #0 = $op1in
/*54*/        OPC_RecordChild1, // #1 = $op2in
/*55*/        OPC_MorphNodeTo, TARGET_VAL(Codasip::i_3_reg_ops__opc_sra__rmem__rmem__rmem__), 0,
                  1/*#VTs*/, MVT::i32, 2/*#Ops*/, 0, 1, 
              // Src: (sra:i32 gpregs:i32:$op1in, gpregs:i32:$op2in) - Complexity = 3
              // Dst: (i_3_reg_ops__opc_sra__rmem__rmem__rmem__:i32 gpregs:i32:$op1in, gpregs:i32:$op2in)
/*64*/      0, /*End of Scope*/
          /*SwitchOpcode*/ 38,  TARGET_VAL(ISD::SHL),// ->106
/*68*/      OPC_RecordChild0, // #0 = $op0
/*69*/      OPC_Scope, 23, /*->94*/ // 2 children in Scope
/*71*/        OPC_MoveChild, 0,
/*73*/        OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*76*/        OPC_CheckPredicate, 0, // Predicate_zext16imm
/*78*/        OPC_MoveParent,
/*79*/        OPC_MoveChild, 1,
/*81*/        OPC_CheckInteger, 16, 
/*83*/        OPC_MoveParent,
/*84*/        OPC_EmitConvertToTarget, 0,
/*86*/        OPC_MorphNodeTo, TARGET_VAL(Codasip::i_movhi__opc_movhi__rmem__uimm16__), 0,
                  1/*#VTs*/, MVT::i32, 1/*#Ops*/, 1, 
              // Src: (shl:i32 (imm:i32)<<P:Predicate_zext16imm>>:$op0, 16:i32) - Complexity = 12
              // Dst: (i_movhi__opc_movhi__rmem__uimm16__:i32 (imm:i32):$op0)
/*94*/      /*Scope*/ 10, /*->105*/
/*95*/        OPC_RecordChild1, // #1 = $op2in
/*96*/        OPC_MorphNodeTo, TARGET_VAL(Codasip::i_3_reg_ops__opc_sll__rmem__rmem__rmem__), 0,
                  1/*#VTs*/, MVT::i32, 2/*#Ops*/, 0, 1, 
              // Src: (shl:i32 gpregs:i32:$op1in, gpregs:i32:$op2in) - Complexity = 3
              // Dst: (i_3_reg_ops__opc_sll__rmem__rmem__rmem__:i32 gpregs:i32:$op1in, gpregs:i32:$op2in)
/*105*/     0, /*End of Scope*/
          /*SwitchOpcode*/ 60,  TARGET_VAL(ISD::LOAD),// ->169
/*109*/     OPC_RecordMemRef,
/*110*/     OPC_RecordNode,   // #0 = 'ld' chained node
/*111*/     OPC_Scope, 36, /*->149*/ // 2 children in Scope
/*113*/       OPC_MoveChild, 1,
/*115*/       OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*118*/       OPC_RecordChild0, // #1 = $op2in
/*119*/       OPC_RecordChild1, // #2 = $op0
/*120*/       OPC_MoveChild, 1,
/*122*/       OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*125*/       OPC_CheckPredicate, 1, // Predicate_sext16imm
/*127*/       OPC_MoveParent,
/*128*/       OPC_CheckType, MVT::i32,
/*130*/       OPC_MoveParent,
/*131*/       OPC_CheckPredicate, 2, // Predicate_unindexedload
/*133*/       OPC_CheckPredicate, 3, // Predicate_load
/*135*/       OPC_CheckType, MVT::i32,
/*137*/       OPC_EmitMergeInputChains1_0,
/*138*/       OPC_EmitConvertToTarget, 2,
/*140*/       OPC_MorphNodeTo, TARGET_VAL(Codasip::i_load_store__opc_load__rmem__rmem__simm16__), 0|OPFL_Chain|OPFL_MemRefs,
                  1/*#VTs*/, MVT::i32, 2/*#Ops*/, 1, 3, 
              // Src: (ld:i32 (add:i32 gpregs:i32:$op2in, (imm:i32)<<P:Predicate_sext16imm>>:$op0))<<P:Predicate_unindexedload>><<P:Predicate_load>> - Complexity = 11
              // Dst: (i_load_store__opc_load__rmem__rmem__simm16__:i32 gpregs:i32:$op2in, (imm:i32):$op0)
/*149*/     /*Scope*/ 18, /*->168*/
/*150*/       OPC_RecordChild1, // #1 = $op1in
/*151*/       OPC_CheckChild1Type, MVT::i32,
/*153*/       OPC_CheckPredicate, 2, // Predicate_unindexedload
/*155*/       OPC_CheckPredicate, 3, // Predicate_load
/*157*/       OPC_CheckType, MVT::i32,
/*159*/       OPC_EmitMergeInputChains1_0,
/*160*/       OPC_MorphNodeTo, TARGET_VAL(Codasip::i_load_store__opc_load__rmem__rmem__simm16____SPEC_op0_0), 0|OPFL_Chain|OPFL_MemRefs,
                  1/*#VTs*/, MVT::i32, 1/*#Ops*/, 1, 
              // Src: (ld:i32 gpregs:i32:$op1in)<<P:Predicate_unindexedload>><<P:Predicate_load>> - Complexity = 4
              // Dst: (i_load_store__opc_load__rmem__rmem__simm16____SPEC_op0_0:i32 gpregs:i32:$op1in)
/*168*/     0, /*End of Scope*/
          /*SwitchOpcode*/ 59,  TARGET_VAL(ISD::STORE),// ->231
/*172*/     OPC_RecordMemRef,
/*173*/     OPC_RecordNode,   // #0 = 'st' chained node
/*174*/     OPC_RecordChild1, // #1 = $op1in
/*175*/     OPC_CheckChild1Type, MVT::i32,
/*177*/     OPC_Scope, 34, /*->213*/ // 2 children in Scope
/*179*/       OPC_MoveChild, 2,
/*181*/       OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*184*/       OPC_RecordChild0, // #2 = $op2in
/*185*/       OPC_RecordChild1, // #3 = $op0
/*186*/       OPC_MoveChild, 1,
/*188*/       OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*191*/       OPC_CheckPredicate, 1, // Predicate_sext16imm
/*193*/       OPC_MoveParent,
/*194*/       OPC_CheckType, MVT::i32,
/*196*/       OPC_MoveParent,
/*197*/       OPC_CheckPredicate, 4, // Predicate_unindexedstore
/*199*/       OPC_CheckPredicate, 5, // Predicate_store
/*201*/       OPC_EmitMergeInputChains1_0,
/*202*/       OPC_EmitConvertToTarget, 3,
/*204*/       OPC_MorphNodeTo, TARGET_VAL(Codasip::i_load_store__opc_store__rmem__rmem__simm16__), 0|OPFL_Chain|OPFL_MemRefs,
                  0/*#VTs*/, 3/*#Ops*/, 1, 2, 4, 
              // Src: (st gpregs:i32:$op1in, (add:i32 gpregs:i32:$op2in, (imm:i32)<<P:Predicate_sext16imm>>:$op0))<<P:Predicate_unindexedstore>><<P:Predicate_store>> - Complexity = 11
              // Dst: (i_load_store__opc_store__rmem__rmem__simm16__ gpregs:i32:$op1in, gpregs:i32:$op2in, (imm:i32):$op0)
/*213*/     /*Scope*/ 16, /*->230*/
/*214*/       OPC_RecordChild2, // #2 = $op1in
/*215*/       OPC_CheckChild2Type, MVT::i32,
/*217*/       OPC_CheckPredicate, 4, // Predicate_unindexedstore
/*219*/       OPC_CheckPredicate, 5, // Predicate_store
/*221*/       OPC_EmitMergeInputChains1_0,
/*222*/       OPC_MorphNodeTo, TARGET_VAL(Codasip::i_load_store__opc_store__rmem__rmem__simm16____SPEC_op0_0), 0|OPFL_Chain|OPFL_MemRefs,
                  0/*#VTs*/, 2/*#Ops*/, 1, 2, 
              // Src: (st gpregs:i32:$op0in, gpregs:i32:$op1in)<<P:Predicate_unindexedstore>><<P:Predicate_store>> - Complexity = 4
              // Dst: (i_load_store__opc_store__rmem__rmem__simm16____SPEC_op0_0 gpregs:i32:$op0in, gpregs:i32:$op1in)
/*230*/     0, /*End of Scope*/
          /*SwitchOpcode*/ 56,  TARGET_VAL(CodasipISD::Call),// ->290
/*234*/     OPC_RecordNode,   // #0 = 'CodasipCall' chained node
/*235*/     OPC_CaptureGlueInput,
/*236*/     OPC_Scope, 38, /*->276*/ // 2 children in Scope
/*238*/       OPC_MoveChild, 1,
/*240*/       OPC_CheckOpcode, TARGET_VAL(CodasipISD::GAWrap),
/*243*/       OPC_RecordChild0, // #1 = $op0
/*244*/       OPC_MoveChild, 0,
/*246*/       OPC_SwitchOpcode /*2 cases */, 11,  TARGET_VAL(ISD::TargetGlobalAddress),// ->261
/*250*/         OPC_MoveParent,
/*251*/         OPC_MoveParent,
/*252*/         OPC_EmitMergeInputChains1_0,
/*253*/         OPC_MorphNodeTo, TARGET_VAL(Codasip::i_jump_call_imm__opc_call_imm__address26__GA_), 0|OPFL_Chain|OPFL_GlueInput|OPFL_GlueOutput|OPFL_Variadic1,
                    1/*#VTs*/, MVT::i32, 1/*#Ops*/, 1, 
                // Src: (CodasipCall (GAWrap:iPTR (tglobaladdr:iPTR):$op0)) - Complexity = 9
                // Dst: (i_jump_call_imm__opc_call_imm__address26__GA_:i32 (tglobaladdr:i32):$op0)
              /*SwitchOpcode*/ 11,  TARGET_VAL(ISD::TargetExternalSymbol),// ->275
/*264*/         OPC_MoveParent,
/*265*/         OPC_MoveParent,
/*266*/         OPC_EmitMergeInputChains1_0,
/*267*/         OPC_MorphNodeTo, TARGET_VAL(Codasip::i_jump_call_imm__opc_call_imm__address26__ES_), 0|OPFL_Chain|OPFL_GlueInput|OPFL_GlueOutput|OPFL_Variadic1,
                    1/*#VTs*/, MVT::i32, 1/*#Ops*/, 1, 
                // Src: (CodasipCall (GAWrap:iPTR (texternalsym:iPTR):$op0)) - Complexity = 9
                // Dst: (i_jump_call_imm__opc_call_imm__address26__ES_:i32 (texternalsym:i32):$op0)
              0, // EndSwitchOpcode
/*276*/     /*Scope*/ 12, /*->289*/
/*277*/       OPC_RecordChild1, // #1 = $op0in
/*278*/       OPC_CheckChild1Type, MVT::i32,
/*280*/       OPC_EmitMergeInputChains1_0,
/*281*/       OPC_MorphNodeTo, TARGET_VAL(Codasip::i_jump_call_reg__opc_call_reg__rmem__), 0|OPFL_Chain|OPFL_GlueInput|OPFL_GlueOutput|OPFL_Variadic1,
                  1/*#VTs*/, MVT::i32, 1/*#Ops*/, 1, 
              // Src: (CodasipCall gpregs:i32:$op0in) - Complexity = 3
              // Dst: (i_jump_call_reg__opc_call_reg__rmem__:i32 gpregs:i32:$op0in)
/*289*/     0, /*End of Scope*/
          /*SwitchOpcode*/ 25,  TARGET_VAL(ISD::CALLSEQ_END),// ->318
/*293*/     OPC_RecordNode,   // #0 = 'callseq_end' chained node
/*294*/     OPC_CaptureGlueInput,
/*295*/     OPC_RecordChild1, // #1 = $imm
/*296*/     OPC_MoveChild, 1,
/*298*/     OPC_CheckOpcode, TARGET_VAL(ISD::TargetConstant),
/*301*/     OPC_MoveParent,
/*302*/     OPC_RecordChild2, // #2 = $imm2
/*303*/     OPC_MoveChild, 2,
/*305*/     OPC_CheckOpcode, TARGET_VAL(ISD::TargetConstant),
/*308*/     OPC_MoveParent,
/*309*/     OPC_EmitMergeInputChains1_0,
/*310*/     OPC_MorphNodeTo, TARGET_VAL(Codasip::CALLEND), 0|OPFL_Chain|OPFL_GlueInput|OPFL_GlueOutput,
                0/*#VTs*/, 2/*#Ops*/, 1, 2, 
            // Src: (callseq_end (timm:i32):$imm, (timm:i32):$imm2) - Complexity = 9
            // Dst: (CALLEND (timm:i32):$imm, (timm:i32):$imm2)
          /*SwitchOpcode*/ 41,  TARGET_VAL(ISD::AND),// ->362
/*321*/     OPC_Scope, 12, /*->335*/ // 3 children in Scope
/*323*/       OPC_CheckAndImm, 127|128,1/*255*/, 
/*326*/       OPC_RecordChild0, // #0 = $op1in
/*327*/       OPC_MorphNodeTo, TARGET_VAL(Codasip::i_ext__opc_zext8__rmem__rmem__), 0,
                  1/*#VTs*/, MVT::i32, 1/*#Ops*/, 0, 
              // Src: (and:i32 gpregs:i32:$op1in, 255:i32) - Complexity = 8
              // Dst: (i_ext__opc_zext8__rmem__rmem__:i32 gpregs:i32:$op1in)
/*335*/     /*Scope*/ 13, /*->349*/
/*336*/       OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/*340*/       OPC_RecordChild0, // #0 = $op1in
/*341*/       OPC_MorphNodeTo, TARGET_VAL(Codasip::i_ext__opc_zext16__rmem__rmem__), 0,
                  1/*#VTs*/, MVT::i32, 1/*#Ops*/, 0, 
              // Src: (and:i32 gpregs:i32:$op1in, 65535:i32) - Complexity = 8
              // Dst: (i_ext__opc_zext16__rmem__rmem__:i32 gpregs:i32:$op1in)
/*349*/     /*Scope*/ 11, /*->361*/
/*350*/       OPC_RecordChild0, // #0 = $op2in
/*351*/       OPC_RecordChild1, // #1 = $op1in
/*352*/       OPC_MorphNodeTo, TARGET_VAL(Codasip::i_3_reg_ops__opc_and__rmem__rmem__rmem__), 0,
                  1/*#VTs*/, MVT::i32, 2/*#Ops*/, 0, 1, 
              // Src: (and:i32 gpregs:i32:$op2in, gpregs:i32:$op1in) - Complexity = 3
              // Dst: (i_3_reg_ops__opc_and__rmem__rmem__rmem__:i32 gpregs:i32:$op2in, gpregs:i32:$op1in)
/*361*/     0, /*End of Scope*/
          /*SwitchOpcode*/ 51,  TARGET_VAL(ISD::OR),// ->416
/*365*/     OPC_Scope, 13, /*->380*/ // 2 children in Scope
/*367*/       OPC_CheckOrImm, 127|128,127|128,3/*65535*/, 
/*371*/       OPC_RecordChild0, // #0 = $op1in
/*372*/       OPC_MorphNodeTo, TARGET_VAL(Codasip::i_arithm_imm__opc_ori__rmem__rmem__uimm16____SPEC_op0_65535), 0,
                  1/*#VTs*/, MVT::i32, 1/*#Ops*/, 0, 
              // Src: (or:i32 gpregs:i32:$op1in, 65535:i32) - Complexity = 8
              // Dst: (i_arithm_imm__opc_ori__rmem__rmem__uimm16____SPEC_op0_65535:i32 gpregs:i32:$op1in)
/*380*/     /*Scope*/ 34, /*->415*/
/*381*/       OPC_RecordChild0, // #0 = $op2in
/*382*/       OPC_RecordChild1, // #1 = $op0
/*383*/       OPC_Scope, 19, /*->404*/ // 2 children in Scope
/*385*/         OPC_MoveChild, 1,
/*387*/         OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*390*/         OPC_CheckPredicate, 0, // Predicate_zext16imm
/*392*/         OPC_MoveParent,
/*393*/         OPC_EmitConvertToTarget, 1,
/*395*/         OPC_MorphNodeTo, TARGET_VAL(Codasip::i_arithm_imm__opc_ori__rmem__rmem__uimm16__), 0,
                    1/*#VTs*/, MVT::i32, 2/*#Ops*/, 0, 2, 
                // Src: (or:i32 gpregs:i32:$op2in, (imm:i32)<<P:Predicate_zext16imm>>:$op0) - Complexity = 7
                // Dst: (i_arithm_imm__opc_ori__rmem__rmem__uimm16__:i32 gpregs:i32:$op2in, (imm:i32):$op0)
/*404*/       /*Scope*/ 9, /*->414*/
/*405*/         OPC_MorphNodeTo, TARGET_VAL(Codasip::i_3_reg_ops__opc_or__rmem__rmem__rmem__), 0,
                    1/*#VTs*/, MVT::i32, 2/*#Ops*/, 0, 1, 
                // Src: (or:i32 gpregs:i32:$op2in, gpregs:i32:$op1in) - Complexity = 3
                // Dst: (i_3_reg_ops__opc_or__rmem__rmem__rmem__:i32 gpregs:i32:$op2in, gpregs:i32:$op1in)
/*414*/       0, /*End of Scope*/
/*415*/     0, /*End of Scope*/
          /*SwitchOpcode*/ 34,  TARGET_VAL(ISD::ADD),// ->453
/*419*/     OPC_RecordChild0, // #0 = $op2in
/*420*/     OPC_RecordChild1, // #1 = $op0
/*421*/     OPC_Scope, 19, /*->442*/ // 2 children in Scope
/*423*/       OPC_MoveChild, 1,
/*425*/       OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*428*/       OPC_CheckPredicate, 1, // Predicate_sext16imm
/*430*/       OPC_MoveParent,
/*431*/       OPC_EmitConvertToTarget, 1,
/*433*/       OPC_MorphNodeTo, TARGET_VAL(Codasip::i_arithm_imm__opc_addi__rmem__rmem__uimm16__), 0,
                  1/*#VTs*/, MVT::i32, 2/*#Ops*/, 0, 2, 
              // Src: (add:i32 gpregs:i32:$op2in, (imm:i32)<<P:Predicate_sext16imm>>:$op0) - Complexity = 7
              // Dst: (i_arithm_imm__opc_addi__rmem__rmem__uimm16__:i32 gpregs:i32:$op2in, (imm:i32):$op0)
/*442*/     /*Scope*/ 9, /*->452*/
/*443*/       OPC_MorphNodeTo, TARGET_VAL(Codasip::i_3_reg_ops__opc_vadd__rmem__rmem__rmem__), 0,
                  1/*#VTs*/, MVT::i32, 2/*#Ops*/, 0, 1, 
              // Src: (add:i32 gpregs:i32:$op2in, gpregs:i32:$op1in) - Complexity = 3
              // Dst: (i_3_reg_ops__opc_vadd__rmem__rmem__rmem__:i32 gpregs:i32:$op2in, gpregs:i32:$op1in)
/*452*/     0, /*End of Scope*/
          /*SwitchOpcode*/ 58,  TARGET_VAL(ISD::BRCOND),// ->514
/*456*/     OPC_RecordNode,   // #0 = 'brcond' chained node
/*457*/     OPC_MoveChild, 1,
/*459*/     OPC_CheckOpcode, TARGET_VAL(ISD::SETCC),
/*462*/     OPC_RecordChild0, // #1 = $op1in
/*463*/     OPC_CheckChild0Type, MVT::i32,
/*465*/     OPC_RecordChild1, // #2 = $op2in
/*466*/     OPC_MoveChild, 2,
/*468*/     OPC_Scope, 21, /*->491*/ // 2 children in Scope
/*470*/       OPC_CheckCondCode, ISD::SETEQ,
/*472*/       OPC_MoveParent,
/*473*/       OPC_MoveParent,
/*474*/       OPC_RecordChild2, // #3 = $op0
/*475*/       OPC_MoveChild, 2,
/*477*/       OPC_CheckOpcode, TARGET_VAL(ISD::BasicBlock),
/*480*/       OPC_MoveParent,
/*481*/       OPC_EmitMergeInputChains1_0,
/*482*/       OPC_MorphNodeTo, TARGET_VAL(Codasip::i_jump_cond__opc_jumpeq__rmem__rmem__simm16_rel__), 0|OPFL_Chain,
                  0/*#VTs*/, 3/*#Ops*/, 1, 2, 3, 
              // Src: (brcond (setcc:i32 gpregs:i32:$op1in, gpregs:i32:$op2in, SETEQ:Other), (bb:Other):$op0) - Complexity = 6
              // Dst: (i_jump_cond__opc_jumpeq__rmem__rmem__simm16_rel__ gpregs:i32:$op1in, gpregs:i32:$op2in, (bb:Other):$op0)
/*491*/     /*Scope*/ 21, /*->513*/
/*492*/       OPC_CheckCondCode, ISD::SETNE,
/*494*/       OPC_MoveParent,
/*495*/       OPC_MoveParent,
/*496*/       OPC_RecordChild2, // #3 = $op0
/*497*/       OPC_MoveChild, 2,
/*499*/       OPC_CheckOpcode, TARGET_VAL(ISD::BasicBlock),
/*502*/       OPC_MoveParent,
/*503*/       OPC_EmitMergeInputChains1_0,
/*504*/       OPC_MorphNodeTo, TARGET_VAL(Codasip::i_jump_cond__opc_jumpneq__rmem__rmem__simm16_rel__), 0|OPFL_Chain,
                  0/*#VTs*/, 3/*#Ops*/, 1, 2, 3, 
              // Src: (brcond (setcc:i32 gpregs:i32:$op1in, gpregs:i32:$op2in, SETNE:Other), (bb:Other):$op0) - Complexity = 6
              // Dst: (i_jump_cond__opc_jumpneq__rmem__rmem__simm16_rel__ gpregs:i32:$op1in, gpregs:i32:$op2in, (bb:Other):$op0)
/*513*/     0, /*End of Scope*/
          /*SwitchOpcode*/ 16,  TARGET_VAL(ISD::CALLSEQ_START),// ->533
/*517*/     OPC_RecordNode,   // #0 = 'callseq_start' chained node
/*518*/     OPC_RecordChild1, // #1 = $off
/*519*/     OPC_MoveChild, 1,
/*521*/     OPC_CheckOpcode, TARGET_VAL(ISD::TargetConstant),
/*524*/     OPC_MoveParent,
/*525*/     OPC_EmitMergeInputChains1_0,
/*526*/     OPC_MorphNodeTo, TARGET_VAL(Codasip::CALLSTART), 0|OPFL_Chain|OPFL_GlueOutput,
                0/*#VTs*/, 1/*#Ops*/, 1, 
            // Src: (callseq_start (timm:i32):$off) - Complexity = 6
            // Dst: (CALLSTART (timm:i32):$off)
          /*SwitchOpcode*/ 12|128,1/*140*/,  TARGET_VAL(CodasipISD::GAWrap),// ->677
/*537*/     OPC_RecordChild0, // #0 = $op00
/*538*/     OPC_MoveChild, 0,
/*540*/     OPC_SwitchOpcode /*5 cases */, 24,  TARGET_VAL(ISD::TargetGlobalAddress),// ->568
/*544*/       OPC_MoveParent,
/*545*/       OPC_EmitNodeXForm, 0, 0, // HI_G
/*548*/       OPC_EmitNode, TARGET_VAL(Codasip::i_movhi__opc_movhi__rmem__uimm16__), 0,
                  1/*#VTs*/, MVT::i32, 1/*#Ops*/, 1,  // Results = #2 
/*556*/       OPC_EmitNodeXForm, 1, 0, // LO_G
/*559*/       OPC_MorphNodeTo, TARGET_VAL(Codasip::i_arithm_imm__opc_ori__rmem__rmem__uimm16__), 0,
                  1/*#VTs*/, MVT::i32, 2/*#Ops*/, 2, 3, 
              // Src: (GAWrap:i32 (tglobaladdr:i32):$op00) - Complexity = 6
              // Dst: (i_arithm_imm__opc_ori__rmem__rmem__uimm16__:i32 (i_movhi__opc_movhi__rmem__uimm16__:i32 (HI_G:i32 (tglobaladdr:i32):$op00)), (LO_G:i32 (tglobaladdr:i32):$op00))
            /*SwitchOpcode*/ 24,  TARGET_VAL(ISD::TargetExternalSymbol),// ->595
/*571*/       OPC_MoveParent,
/*572*/       OPC_EmitNodeXForm, 2, 0, // HI_E
/*575*/       OPC_EmitNode, TARGET_VAL(Codasip::i_movhi__opc_movhi__rmem__uimm16__), 0,
                  1/*#VTs*/, MVT::i32, 1/*#Ops*/, 1,  // Results = #2 
/*583*/       OPC_EmitNodeXForm, 3, 0, // LO_E
/*586*/       OPC_MorphNodeTo, TARGET_VAL(Codasip::i_arithm_imm__opc_ori__rmem__rmem__uimm16__), 0,
                  1/*#VTs*/, MVT::i32, 2/*#Ops*/, 2, 3, 
              // Src: (GAWrap:i32 (texternalsym:i32):$op00) - Complexity = 6
              // Dst: (i_arithm_imm__opc_ori__rmem__rmem__uimm16__:i32 (i_movhi__opc_movhi__rmem__uimm16__:i32 (HI_E:i32 (texternalsym:i32):$op00)), (LO_E:i32 (texternalsym:i32):$op00))
            /*SwitchOpcode*/ 24,  TARGET_VAL(ISD::TargetJumpTable),// ->622
/*598*/       OPC_MoveParent,
/*599*/       OPC_EmitNodeXForm, 4, 0, // HI_J
/*602*/       OPC_EmitNode, TARGET_VAL(Codasip::i_movhi__opc_movhi__rmem__uimm16__), 0,
                  1/*#VTs*/, MVT::i32, 1/*#Ops*/, 1,  // Results = #2 
/*610*/       OPC_EmitNodeXForm, 5, 0, // LO_J
/*613*/       OPC_MorphNodeTo, TARGET_VAL(Codasip::i_arithm_imm__opc_ori__rmem__rmem__uimm16__), 0,
                  1/*#VTs*/, MVT::i32, 2/*#Ops*/, 2, 3, 
              // Src: (GAWrap:i32 (tjumptable:i32):$op00) - Complexity = 6
              // Dst: (i_arithm_imm__opc_ori__rmem__rmem__uimm16__:i32 (i_movhi__opc_movhi__rmem__uimm16__:i32 (HI_J:i32 (tjumptable:i32):$op00)), (LO_J:i32 (tjumptable:i32):$op00))
            /*SwitchOpcode*/ 24,  TARGET_VAL(ISD::TargetConstantPool),// ->649
/*625*/       OPC_MoveParent,
/*626*/       OPC_EmitNodeXForm, 6, 0, // HI_C
/*629*/       OPC_EmitNode, TARGET_VAL(Codasip::i_movhi__opc_movhi__rmem__uimm16__), 0,
                  1/*#VTs*/, MVT::i32, 1/*#Ops*/, 1,  // Results = #2 
/*637*/       OPC_EmitNodeXForm, 7, 0, // LO_C
/*640*/       OPC_MorphNodeTo, TARGET_VAL(Codasip::i_arithm_imm__opc_ori__rmem__rmem__uimm16__), 0,
                  1/*#VTs*/, MVT::i32, 2/*#Ops*/, 2, 3, 
              // Src: (GAWrap:i32 (tconstpool:i32):$op00) - Complexity = 6
              // Dst: (i_arithm_imm__opc_ori__rmem__rmem__uimm16__:i32 (i_movhi__opc_movhi__rmem__uimm16__:i32 (HI_C:i32 (tconstpool:i32):$op00)), (LO_C:i32 (tconstpool:i32):$op00))
            /*SwitchOpcode*/ 24,  TARGET_VAL(ISD::TargetBlockAddress),// ->676
/*652*/       OPC_MoveParent,
/*653*/       OPC_EmitNodeXForm, 8, 0, // HI_B
/*656*/       OPC_EmitNode, TARGET_VAL(Codasip::i_movhi__opc_movhi__rmem__uimm16__), 0,
                  1/*#VTs*/, MVT::i32, 1/*#Ops*/, 1,  // Results = #2 
/*664*/       OPC_EmitNodeXForm, 9, 0, // LO_B
/*667*/       OPC_MorphNodeTo, TARGET_VAL(Codasip::i_arithm_imm__opc_ori__rmem__rmem__uimm16__), 0,
                  1/*#VTs*/, MVT::i32, 2/*#Ops*/, 2, 3, 
              // Src: (GAWrap:i32 (tblockaddress:i32):$op00) - Complexity = 6
              // Dst: (i_arithm_imm__opc_ori__rmem__rmem__uimm16__:i32 (i_movhi__opc_movhi__rmem__uimm16__:i32 (HI_B:i32 (tblockaddress:i32):$op00)), (LO_B:i32 (tblockaddress:i32):$op00))
            0, // EndSwitchOpcode
          /*SwitchOpcode*/ 41,  TARGET_VAL(ISD::Constant),// ->721
/*680*/     OPC_Scope, 9, /*->691*/ // 2 children in Scope
/*682*/       OPC_CheckInteger, 0, 
/*684*/       OPC_MorphNodeTo, TARGET_VAL(Codasip::i_movhi__opc_movhi__rmem__uimm16____SPEC_op0_0), 0,
                  1/*#VTs*/, MVT::i32, 0/*#Ops*/, 
              // Src: 0:i32 - Complexity = 5
              // Dst: (i_movhi__opc_movhi__rmem__uimm16____SPEC_op0_0:i32)
/*691*/     /*Scope*/ 28, /*->720*/
/*692*/       OPC_RecordNode, // #0 = $op00
/*693*/       OPC_EmitConvertToTarget, 0,
/*695*/       OPC_EmitNodeXForm, 10, 1, // HI_I
/*698*/       OPC_EmitNode, TARGET_VAL(Codasip::i_movhi__opc_movhi__rmem__uimm16__), 0,
                  1/*#VTs*/, MVT::i32, 1/*#Ops*/, 2,  // Results = #3 
/*706*/       OPC_EmitConvertToTarget, 0,
/*708*/       OPC_EmitNodeXForm, 11, 4, // LO_I
/*711*/       OPC_MorphNodeTo, TARGET_VAL(Codasip::i_arithm_imm__opc_ori__rmem__rmem__uimm16__), 0,
                  1/*#VTs*/, MVT::i32, 2/*#Ops*/, 3, 5, 
              // Src: (imm:i32):$op00 - Complexity = 3
              // Dst: (i_arithm_imm__opc_ori__rmem__rmem__uimm16__:i32 (i_movhi__opc_movhi__rmem__uimm16__:i32 (HI_I:i32 (imm:i32):$op00)), (LO_I:i32 (imm:i32):$op00))
/*720*/     0, /*End of Scope*/
          /*SwitchOpcode*/ 11,  TARGET_VAL(ISD::SUB),// ->735
/*724*/     OPC_RecordChild0, // #0 = $op1in
/*725*/     OPC_RecordChild1, // #1 = $op2in
/*726*/     OPC_MorphNodeTo, TARGET_VAL(Codasip::i_3_reg_ops__opc_vsub__rmem__rmem__rmem__), 0,
                1/*#VTs*/, MVT::i32, 2/*#Ops*/, 0, 1, 
            // Src: (sub:i32 gpregs:i32:$op1in, gpregs:i32:$op2in) - Complexity = 3
            // Dst: (i_3_reg_ops__opc_vsub__rmem__rmem__rmem__:i32 gpregs:i32:$op1in, gpregs:i32:$op2in)
          /*SwitchOpcode*/ 11,  TARGET_VAL(ISD::MUL),// ->749
/*738*/     OPC_RecordChild0, // #0 = $op2in
/*739*/     OPC_RecordChild1, // #1 = $op1in
/*740*/     OPC_MorphNodeTo, TARGET_VAL(Codasip::i_3_reg_ops__opc_vmul__rmem__rmem__rmem__), 0,
                1/*#VTs*/, MVT::i32, 2/*#Ops*/, 0, 1, 
            // Src: (mul:i32 gpregs:i32:$op2in, gpregs:i32:$op1in) - Complexity = 3
            // Dst: (i_3_reg_ops__opc_vmul__rmem__rmem__rmem__:i32 gpregs:i32:$op2in, gpregs:i32:$op1in)
          /*SwitchOpcode*/ 11,  TARGET_VAL(ISD::XOR),// ->763
/*752*/     OPC_RecordChild0, // #0 = $op2in
/*753*/     OPC_RecordChild1, // #1 = $op1in
/*754*/     OPC_MorphNodeTo, TARGET_VAL(Codasip::i_3_reg_ops__opc_xor__rmem__rmem__rmem__), 0,
                1/*#VTs*/, MVT::i32, 2/*#Ops*/, 0, 1, 
            // Src: (xor:i32 gpregs:i32:$op2in, gpregs:i32:$op1in) - Complexity = 3
            // Dst: (i_3_reg_ops__opc_xor__rmem__rmem__rmem__:i32 gpregs:i32:$op2in, gpregs:i32:$op1in)
          /*SwitchOpcode*/ 11,  TARGET_VAL(ISD::SRL),// ->777
/*766*/     OPC_RecordChild0, // #0 = $op1in
/*767*/     OPC_RecordChild1, // #1 = $op2in
/*768*/     OPC_MorphNodeTo, TARGET_VAL(Codasip::i_3_reg_ops__opc_srl__rmem__rmem__rmem__), 0,
                1/*#VTs*/, MVT::i32, 2/*#Ops*/, 0, 1, 
            // Src: (srl:i32 gpregs:i32:$op1in, gpregs:i32:$op2in) - Complexity = 3
            // Dst: (i_3_reg_ops__opc_srl__rmem__rmem__rmem__:i32 gpregs:i32:$op1in, gpregs:i32:$op2in)
          /*SwitchOpcode*/ 16,  TARGET_VAL(ISD::BR),// ->796
/*780*/     OPC_RecordNode,   // #0 = 'br' chained node
/*781*/     OPC_RecordChild1, // #1 = $op0
/*782*/     OPC_MoveChild, 1,
/*784*/     OPC_CheckOpcode, TARGET_VAL(ISD::BasicBlock),
/*787*/     OPC_MoveParent,
/*788*/     OPC_EmitMergeInputChains1_0,
/*789*/     OPC_MorphNodeTo, TARGET_VAL(Codasip::i_jump_call_imm__opc_jump_imm__address26__), 0|OPFL_Chain,
                0/*#VTs*/, 1/*#Ops*/, 1, 
            // Src: (br (bb:Other):$op0) - Complexity = 3
            // Dst: (i_jump_call_imm__opc_jump_imm__address26__ (bb:Other):$op0)
          /*SwitchOpcode*/ 12,  TARGET_VAL(ISD::BRIND),// ->811
/*799*/     OPC_RecordNode,   // #0 = 'brind' chained node
/*800*/     OPC_RecordChild1, // #1 = $op0in
/*801*/     OPC_CheckChild1Type, MVT::i32,
/*803*/     OPC_EmitMergeInputChains1_0,
/*804*/     OPC_MorphNodeTo, TARGET_VAL(Codasip::i_jump_call_reg__opc_jump_reg__rmem__), 0|OPFL_Chain,
                0/*#VTs*/, 1/*#Ops*/, 1, 
            // Src: (brind gpregs:i32:$op0in) - Complexity = 3
            // Dst: (i_jump_call_reg__opc_jump_reg__rmem__ gpregs:i32:$op0in)
          /*SwitchOpcode*/ 13,  TARGET_VAL(CodasipISD::Ret),// ->827
/*814*/     OPC_RecordNode,   // #0 = 'CodasipRet' chained node
/*815*/     OPC_CaptureGlueInput,
/*816*/     OPC_EmitMergeInputChains1_0,
/*817*/     OPC_EmitRegister, MVT::i32, Codasip::gpregs_7,
/*820*/     OPC_MorphNodeTo, TARGET_VAL(Codasip::i_jump_call_reg__opc_jump_reg__rmem___RETURN_CLONE_), 0|OPFL_Chain|OPFL_GlueInput,
                0/*#VTs*/, 1/*#Ops*/, 1, 
            // Src: (CodasipRet) - Complexity = 3
            // Dst: (i_jump_call_reg__opc_jump_reg__rmem___RETURN_CLONE_ gpregs_7:i32)
          /*SwitchOpcode*/ 29,  TARGET_VAL(ISD::SIGN_EXTEND_INREG),// ->859
/*830*/     OPC_RecordChild0, // #0 = $op1in0
/*831*/     OPC_MoveChild, 1,
/*833*/     OPC_Scope, 11, /*->846*/ // 2 children in Scope
/*835*/       OPC_CheckValueType, MVT::i8,
/*837*/       OPC_MoveParent,
/*838*/       OPC_MorphNodeTo, TARGET_VAL(Codasip::i_ext__opc_sext8__rmem__rmem__), 0,
                  1/*#VTs*/, MVT::i32, 1/*#Ops*/, 0, 
              // Src: (sext_inreg:i32 gpregs:i32:$op1in0, i8:Other) - Complexity = 3
              // Dst: (i_ext__opc_sext8__rmem__rmem__:i32 gpregs:i32:$op1in0)
/*846*/     /*Scope*/ 11, /*->858*/
/*847*/       OPC_CheckValueType, MVT::i16,
/*849*/       OPC_MoveParent,
/*850*/       OPC_MorphNodeTo, TARGET_VAL(Codasip::i_ext__opc_sext32__rmem__rmem__), 0,
                  1/*#VTs*/, MVT::i32, 1/*#Ops*/, 0, 
              // Src: (sext_inreg:i32 gpregs:i32:$op1in0, i16:Other) - Complexity = 3
              // Dst: (i_ext__opc_sext32__rmem__rmem__:i32 gpregs:i32:$op1in0)
/*858*/     0, /*End of Scope*/
          0, // EndSwitchOpcode
    0
  }; // Total Array size is 861 bytes

  // Opcode Histogram:
  // #OPC_Scope                          = 13
  // #OPC_RecordNode                     = 10
  // #OPC_RecordChild                    = 42
  // #OPC_RecordMemRef                   = 2
  // #OPC_CaptureGlueInput               = 3
  // #OPC_MoveChild                      = 24
  // #OPC_MoveParent                     = 35
  // #OPC_CheckSame                      = 0
  // #OPC_CheckPatternPredicate          = 0
  // #OPC_CheckPredicate                 = 13
  // #OPC_CheckOpcode                    = 16
  // #OPC_SwitchOpcode                   = 3
  // #OPC_CheckType                      = 4
  // #OPC_SwitchType                     = 0
  // #OPC_CheckChildType                 = 6
  // #OPC_CheckInteger                   = 6
  // #OPC_CheckCondCode                  = 2
  // #OPC_CheckValueType                 = 2
  // #OPC_CheckComplexPat                = 0
  // #OPC_CheckAndImm                    = 2
  // #OPC_CheckOrImm                     = 1
  // #OPC_CheckFoldableChainNode         = 0
  // #OPC_EmitInteger                    = 0
  // #OPC_EmitStringInteger              = 0
  // #OPC_EmitRegister                   = 1
  // #OPC_EmitConvertToTarget            = 7
  // #OPC_EmitMergeInputChains           = 14
  // #OPC_EmitCopyToReg                  = 0
  // #OPC_EmitNode                       = 6
  // #OPC_EmitNodeXForm                  = 12
  // #OPC_MarkGlueResults                = 0
  // #OPC_CompleteMatch                  = 0
  // #OPC_MorphNodeTo                    = 40

  #undef TARGET_VAL
  return SelectCodeCommon(N, MatcherTable,sizeof(MatcherTable));
}

bool CheckNodePredicate(SDNode *Node, unsigned PredNo) const {
  switch (PredNo) {
  default: assert(0 && "Invalid predicate in table?");
  case 0: { // Predicate_zext16imm
    ConstantSDNode*N = cast<ConstantSDNode>(Node);

  return N->getZExtValue()==(N->getZExtValue()&65535LLU);

  }
  case 1: { // Predicate_sext16imm
    ConstantSDNode*N = cast<ConstantSDNode>(Node);

  return (static_cast<uint64_t>(N->getSExtValue())&18446744073709518848LLU)==18446744073709518848LLU
      || (static_cast<uint64_t>(N->getSExtValue())&18446744073709518848LLU)==0;

  }
  case 2: { // Predicate_unindexedload
    SDNode *N = Node;

  return cast<LoadSDNode>(N)->getAddressingMode() == ISD::UNINDEXED;

  }
  case 3: { // Predicate_load
    SDNode *N = Node;

  return cast<LoadSDNode>(N)->getExtensionType() == ISD::NON_EXTLOAD;

  }
  case 4: { // Predicate_unindexedstore
    SDNode *N = Node;

  return cast<StoreSDNode>(N)->getAddressingMode() == ISD::UNINDEXED;

  }
  case 5: { // Predicate_store
    SDNode *N = Node;

  return !cast<StoreSDNode>(N)->isTruncatingStore();

  }
  }
}

SDValue RunSDNodeXForm(SDValue V, unsigned XFormNo) {
  switch (XFormNo) {
  default: assert(0 && "Invalid xform # in table?");
  case 0: {  // HI_G
    GlobalAddressSDNode *N = cast<GlobalAddressSDNode>(V.getNode());

  const GlobalValue *GV = N->getGlobal();
  DebugLoc dl = N->getDebugLoc();
  unsigned of = N->getOffset();
  assert(N->getNumValues()==1);
  EVT t = N->getValueType(0);
  return CurDAG->getTargetGlobalAddress(GV,dl,t,of,3);

  }
  case 1: {  // LO_G
    GlobalAddressSDNode *N = cast<GlobalAddressSDNode>(V.getNode());

  const GlobalValue *GV = N->getGlobal();
  DebugLoc dl = N->getDebugLoc();
  unsigned of = N->getOffset();
  assert(N->getNumValues()==1);
  EVT t = N->getValueType(0);
  return CurDAG->getTargetGlobalAddress(GV,dl,t,of,2);

  }
  case 2: {  // HI_E
    ExternalSymbolSDNode *N = cast<ExternalSymbolSDNode>(V.getNode());

  const char *sym = N->getSymbol();
  assert(N->getNumValues()==1);
  EVT t = N->getValueType(0);
  return CurDAG->getTargetExternalSymbol(sym,t,3);

  }
  case 3: {  // LO_E
    ExternalSymbolSDNode *N = cast<ExternalSymbolSDNode>(V.getNode());

  const char *sym = N->getSymbol();
  assert(N->getNumValues()==1);
  EVT t = N->getValueType(0);
  return CurDAG->getTargetExternalSymbol(sym,t,2);

  }
  case 4: {  // HI_J
    JumpTableSDNode *N = cast<JumpTableSDNode>(V.getNode());

  int ind = N->getIndex();
  assert(N->getNumValues()==1);
  EVT t = N->getValueType(0);
  return CurDAG->getTargetJumpTable(ind,t,3);

  }
  case 5: {  // LO_J
    JumpTableSDNode *N = cast<JumpTableSDNode>(V.getNode());

  int ind = N->getIndex();
  assert(N->getNumValues()==1);
  EVT t = N->getValueType(0);
  return CurDAG->getTargetJumpTable(ind,t,2);

  }
  case 6: {  // HI_C
    ConstantPoolSDNode *N = cast<ConstantPoolSDNode>(V.getNode());

  assert(!N->isMachineConstantPoolEntry());
  const Constant *C = N->getConstVal();
  assert(N->getNumValues()==1);
  EVT t = N->getValueType(0);
  unsigned a = N->getAlignment();
  int o = N->getOffset();
  return CurDAG->getTargetConstantPool(C,t,a,o,3);

  }
  case 7: {  // LO_C
    ConstantPoolSDNode *N = cast<ConstantPoolSDNode>(V.getNode());

  assert(!N->isMachineConstantPoolEntry());
  const Constant *C = N->getConstVal();
  assert(N->getNumValues()==1);
  EVT t = N->getValueType(0);
  unsigned a = N->getAlignment();
  int o = N->getOffset();
  return CurDAG->getTargetConstantPool(C,t,a,o,2);

  }
  case 8: {  // HI_B
    BlockAddressSDNode *N = cast<BlockAddressSDNode>(V.getNode());

  const BlockAddress *ba = N->getBlockAddress();
  assert(N->getNumValues()==1);
  EVT t = N->getValueType(0);
  return CurDAG->getBlockAddress(ba,t,true,3);

  }
  case 9: {  // LO_B
    BlockAddressSDNode *N = cast<BlockAddressSDNode>(V.getNode());

  const BlockAddress *ba = N->getBlockAddress();
  assert(N->getNumValues()==1);
  EVT t = N->getValueType(0);
  return CurDAG->getBlockAddress(ba,t,true,2);

  }
  case 10: {  // HI_I
    ConstantSDNode *N = cast<ConstantSDNode>(V.getNode());

  assert(N->getNumValues()==1);
  EVT t = N->getValueType(0);
  return CurDAG->getTargetConstant((unsigned)N->getZExtValue()>>16, t);

  }
  case 11: {  // LO_I
    ConstantSDNode *N = cast<ConstantSDNode>(V.getNode());

  assert(N->getNumValues()==1);
  EVT t = N->getValueType(0);
  return CurDAG->getTargetConstant((unsigned)N->getZExtValue()&0xffff, t);

  }
  }
}

