/*******************************************************\
* Copyright (C) 2006, ApS s.r.o Brno, AllRightsReserved *
\*******************************************************/

#include "CodasipInstrInfo.h"
#include "llvm/ADT/STLExtras.h"
#include "llvm/ADT/SmallVector.h"
#include "llvm/CodeGen/MachineInstrBuilder.h"
#include "llvm/CodeGen/ScheduleDAG.h"

#include "CodasipTargetMachine.h"

#define GET_INSTRINFO_CTOR
#include "CodasipGenInstrInfo.inc"

#include <cstdio>
#include <iostream>
#include <vector>

llvm::CodasipGenInstrInfo2::CodasipGenInstrInfo2(CodasipTargetMachine &TM)
: CodasipGenInstrInfo(Codasip::CALLSTART,Codasip::CALLEND), RI(*this) {}

// R2R moves
void llvm::CodasipGenInstrInfo2::
copyPhysReg(MachineBasicBlock &MBB, MachineBasicBlock::iterator I, DebugLoc DL,
            unsigned DestReg, unsigned SrcReg, bool KillSrc) const
{
  // check all supported combinations
  if ((Codasip::gpregsRegClass.contains(SrcReg)) && (Codasip::gpregsRegClass.contains(DestReg)))
  {
    BuildMI(MBB,I,DL, get(Codasip::i_2_reg_ops__opc_mov__rmem__rmem__), DestReg).addReg(SrcReg,getKillRegState(KillSrc));
  }
  else 
  {
    assert(false && "It's impossible to perform this copy.");
  }
}

// R2S stores
void llvm::CodasipGenInstrInfo2::
storeRegToStackSlot(MachineBasicBlock &MBB, MachineBasicBlock::iterator I, unsigned Reg, bool isKill, int FrameIndex,
                    const TargetRegisterClass *RC, const TargetRegisterInfo *TRI) const
{
  DebugLoc DL;
  if (I != MBB.end()) DL = I->getDebugLoc();
  // check all supported registers
  if (RC->getID()==Codasip::gpregsRegClass.getID())
  {
    BuildMI(MBB,I,DL, get(Codasip::i_load_store__opc_store__rmem__rmem__simm16__)).addReg(Reg,getKillRegState(isKill)).addFrameIndex(FrameIndex).addImm(0);
  }
  else 
  {
    assert(false && "It's impossible to store this register.");
  }
}

// S2R loads
void llvm::CodasipGenInstrInfo2::
loadRegFromStackSlot(MachineBasicBlock &MBB, MachineBasicBlock::iterator I, unsigned Reg, int FrameIndex,
                     const TargetRegisterClass *RC, const TargetRegisterInfo *TRI) const
{
  DebugLoc DL;
  if (I != MBB.end()) DL = I->getDebugLoc();
  // check all supported registers
  if (RC->getID()==Codasip::gpregsRegClass.getID())
  {
    BuildMI(MBB,I,DL, get(Codasip::i_load_store__opc_load__rmem__rmem__simm16__), Reg).addFrameIndex(FrameIndex).addImm(0);
  }
  else 
  {
    assert(false && "It's impossible to load to this register.");
  }
}

// only for tail-merging
unsigned llvm::CodasipGenInstrInfo2::
InsertBranch(MachineBasicBlock &MBB, MachineBasicBlock *TBB, MachineBasicBlock *FBB,
             const SmallVectorImpl<MachineOperand> &Cond, DebugLoc DL) const
{
  assert(Cond.empty() && FBB==NULL);
  BuildMI(&MBB,DL, get(Codasip::i_jump_call_imm__opc_jump_imm__address26__)).addMBB(TBB);
  return 1;
}

//adding NO-OP instruction to code
void llvm::CodasipGenInstrInfo2::insertNoop(MachineBasicBlock &MBB, MachineBasicBlock::iterator MI) const {
  DebugLoc DL;
  if (MI!=MBB.end()) DL=MI->getDebugLoc();
    return;

}

//adding specific NO-OP instruction to code on specific position
void llvm::CodasipGenInstrInfo2::insertNoopOnPos(MachineBasicBlock &MBB, MachineBasicBlock::iterator MI, unsigned pos) const {
  DebugLoc DL;
  if (MI!=MBB.end()) DL=MI->getDebugLoc();
  switch(pos) {
    
    default: insertNoop(MBB,MI);break;
  }
}

//function return array in vector with all positions, where
//instruction can be
void llvm::CodasipGenInstrInfo2::getAllPosInBundle(std::string &Instr, std::vector<int> &vect) const {
  
}

//method for swap instruction on position
//if instruction on the other position has another asm syntax,
//we swap it with instruction with correct syntax
void llvm::CodasipGenInstrInfo2::swapInstrInBundle(MachineFunction *MF, SUnit *unit, int pos) const {
  std::string Instr=unit->getInstr()->getDesc().getName();
  //we need information about old instruction
  //DebugLoc DL;
  //specificly about operands
  //DL=unit->getInstr()->getDebugLoc();
  //unsigned countOfOpern=unit->getInstr()->getNumOperands();
  //std::vector<MachineOperand> vectMachOper;

  //for(unsigned i=0;i<countOfOpern;++i) {
  //  vectMachOper.push_back(unit->getInstr()->getOperand(i));
  //}
  
  

  //set operands to new instruction
  //for(unsigned i=0;i<countOfOpern;++i) {
  //  unit->getInstr()->addOperand(vectMachOper[i]);
  //}
}
