/**
 * @file AnsaIP.h
 * @brief File contains extension of class IP, which can work also with multicast data and multicast
 * @author Veronika Rybova
 * @date 10.10.2011
 */

#ifndef __INET_ANSAIP_H
#define __INET_ANSAIP_H

#include "QueueBase.h"
#include "InterfaceTableAccess.h"
#include "IRoutingTable.h"
#include "ICMPAccess.h"
#include "IPControlInfo.h"
#include "IPDatagram.h"
#include "IPFragBuf.h"
#include "ProtocolMap.h"
#include "ControlManetRouting_m.h"
#include "ICMPMessage_m.h"
#include "IPv4InterfaceData.h"
#include "ARPPacket_m.h"
#include "IP.h"
#include "PimSplitter.h"
#include "MulticastRoutingTableAccess.h"


class ARPPacket;
class ICMPMessage;

//FIXME it shouldn't be there, but somewhere more globally
enum AnsaIPProtocolId
{
    IP_PROT_PIM = 103
};


/**
 * @brief Class is extension of the IP protocol implementation for multicast.
 * @details It extends class IP mainly by methods processing multicast stream.
 */
class INET_API AnsaIP : public IP
{
	private:
		MulticastRoutingTable 		*mrt;			/**< Pointer to multicast routing table. */
		NotificationBoard 			*nb; 		   	/**< Pointer to notification table. */


	protected:
		virtual void handlePacketFromNetwork(IPDatagram *datagram);
		virtual void routeMulticastPacket(IPDatagram *datagram, InterfaceEntry *destIE, InterfaceEntry *fromIE);

  public:
    AnsaIP() {}

  protected:

    virtual int numInitStages() const  {return 5;}
    virtual void initialize(int stage);
};

#endif

