/*
    Copyright (C) 2012  Stanislav Bárta

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/*
 * Soubor:  MF.c
 * Datum:   16.05.2012
 * Autor:   Stanislav Bárta, xbarta29@stud.fit.vutbr.cz
 * Projekt: BP - tvorba metadat pri odposlechu komunikace v realnem case
 * Popis:   Pomocna aplikace reprezentujici Mediation Function
 */

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <string.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <netdb.h>


#include <errno.h>
#include <signal.h>



#define BUFFER_LEN 300

// datová struktura pro ulozeni parametru
typedef struct
{
	int port;
	int ecode;
} TParametry;

//zpracování parametrů
TParametry get_params(int argc, char **argv)
{
	TParametry parametry = {0, 0,};
	if(argc != 3)
	{
		parametry.ecode = 1;
		return parametry;
	}

	if(strcmp(argv[1], "-p"))
	{
		parametry.ecode = 1;
		return parametry;
	}

	parametry.port = atoi(argv[2]);
	return parametry;
}


int main (int argc, char *argv[])
{
	TParametry parametry = get_params(argc, argv);

	if(parametry.ecode)
	{
		return EXIT_FAILURE;
	}

	int s, t, sinlen;
	struct sockaddr_in sin;

	char msg[1500];
	pid_t pid; // pro fork


	if ( (s = socket(PF_INET, SOCK_STREAM, 0 ) ) < 0)
	{
		perror("error on socket"); 
		return -1;
	}

	sin.sin_family = PF_INET;
	sin.sin_port = htons(parametry.port);
	sin.sin_addr.s_addr  = INADDR_ANY; 

	if (bind(s, (struct sockaddr *)&sin, sizeof(sin) ) < 0 )
	{
		perror("error on bind"); return -1;
	}

	if (listen(s, 5))
	{
		perror("error on listen");
		return -1;
	}

	sinlen = sizeof(sin);

	signal(SIGCHLD,SIG_IGN); // ignorování signálu potomka

	while (1)
	{

		if ( (t = accept(s, (struct sockaddr *) &sin, (socklen_t *)&sinlen) ) < 0 )
		{
			perror("error on accept");
			return -1;
		}

		pid=fork();// vytovření podprocesu
		if(pid == 0) // potomek
		{
			while(1)
			{
				// přijmutí zprávy
				bzero(msg,sizeof(msg));
				int status_prijmute_zpravy = recv(t, msg, sizeof(msg), 0);
				if ( status_prijmute_zpravy < 0)
				{
					perror("error on read");
					return -1;
				}
				else if(status_prijmute_zpravy)
				{
					printf("%s", msg);
				}
				else
				{
				//ukonceni spojeni (v potomkovi)
					if (close(t) < 0)
					{
						perror("error on close"); return -1;
					}
					exit(0); // ukončení procesu potomka
				}
			}
		} //konec potomka
		else if(pid == -1) // chyba
		{

		}
		else // rodic
		{
			//ukonceni spojeni v rodici
			if (close(t) < 0)
			{
				perror("error on close"); return -1;
			}
		}
	}

	if (close(s) < 0)
	{
		perror("error on close"); return -1;
	}

	return 0;
}

