/*
    Copyright (C) 2012  Stanislav Bárta

    This file is part of Bachelor's thesis: Creating Metadata during 
    Interception of Instant Messaging Communication.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/*
 * Soubor:  iri.c
 * Datum:   16.05.2012
 * Autor:   Stanislav Bárta, xbarta29@stud.fit.vutbr.cz
 * Projekt: BP - tvorba metadat pri odposlechu komunikace v realnem case
 * Popis:   soubor obsahujici funkce k vytvoreni a odeslani zprav IRI
 */

#include "iri.h"

char *PROTOKOL[] = {
	"\"XMPP\"",
	"\"IRC\"",
	"\"OSCAR\""
};

char *TRANSPORTNI_PROTOKOL[] = {
	"", // neuvedeno
	"\"TCP\"",
	"\"UDP\""
};

/*
char *TYP_IRI[] = {
	"IRI_REPORT",
	"IRI_BEGIN",
	"IRI_CONTINUE",
	"IRI_END"
};*/

char *TYP_IRI[] = {
	"\"REPORT\"",
	"\"BEGIN\"",
	"\"CONTINUE\"",
	"\"END\""
};

char *TYP_UDALOSTI_STR[] = {
	"\"AUTENTIZACE\"",
	"\"PRIHLASEN\"",
	"\"PRIJATA_ZPRAVA\"",
	"\"ODESLANA_ZPRAVA\"",
	"\"PRIJATO_OZNAMENI\"",
	"\"ODESLANO_OZNAMENI\"",
	"\"ODHLASEN\"",
	"\"STATUS_UPRAVEN:ONLINE\"",
	"\"STATUS_UPRAVEN:AWAY\"",
	"\"STATUS_UPRAVEN:CHAT\"",
	"\"STATUS_UPRAVEN:DND\"",
	"\"STATUS_UPRAVEN:N/A\"",
	"\"STATUS_UPRAVEN:OCCUPIED\"",
	"\"STATUS_UPRAVEN:INVISIBLE\"",
	"\"PRIPOJENI_KE_KANALU\"",
	"\"ODPOJENI_OD_KANALU\""
};

char *USPECH_AKCE_STR[] = {
	"\"NEZNAME\"",
	"\"USPESNE\"",
	"\"NEUSPESNE\""
};

/*
 * otevre TCP spojeni s MF ktere se budou zasilat vytvorene zpravy IRI
 */
int otevri_spojeni_pro_iri(char *host, char *port)
{
	struct addrinfo hints, *servinfo;

	memset(&hints, 0, sizeof hints);
	hints.ai_family = AF_UNSPEC;
	hints.ai_socktype = SOCK_STREAM;

	if(getaddrinfo(host, port, &hints, &servinfo))
	{
		fprintf(stderr, "chyba pri ziskani informaci o adrese MF\n");
		return -1;
	}
	if((socket_iri = socket(servinfo->ai_family, servinfo->ai_socktype, servinfo->ai_protocol)) == -1)
	{
		freeaddrinfo(servinfo);
		fprintf(stderr, "chyba pri vytvoreni socketu pro odesilani IRI\n");
		return -1;
	}
	if((connect(socket_iri, servinfo->ai_addr, servinfo->ai_addrlen)) == -1)
	{
		freeaddrinfo(servinfo);
		fprintf(stderr, "chyba pri pripojeni k MF\n");
		return -1;
	}

	freeaddrinfo(servinfo);
	return 0;
}

/*
 * uzavreni spojeni s MF pri ukonceni programu
 */
void uzavri_spojeni_pro_iri(void)
{
	close(socket_iri);
}

/*
 * podle zadanych parametru je vytvorena IRI v textovem formatu a je vracen ukazatel na tento retezec
 */
char *vytvor_iri(int typ_iri, int protokol, struct sezeni *Sezeni, int typ_udalosti, int uspech_udalosti, struct timeval *cas)
{
	char *oddelovac = ", ";

	char port_str[20];
	sprintf(port_str, "%d", Sezeni->port);
	char port_2_str[20];
	sprintf(port_2_str, "%d", Sezeni->port_2);

	char adresa_str[INET6_ADDRSTRLEN];
	char adresa_2_str[INET6_ADDRSTRLEN];
	if(Sezeni->typ_ip == IPverze4)
	{
		inet_ntop(AF_INET, &(Sezeni->ipv4_adresa), adresa_str, INET6_ADDRSTRLEN);
		inet_ntop(AF_INET, &(Sezeni->ipv4_adresa_2), adresa_2_str, INET6_ADDRSTRLEN);
	}
	else if(Sezeni->typ_ip == IPverze6)
	{
		inet_ntop(AF_INET6, &(Sezeni->ipv6_adresa), adresa_str, INET6_ADDRSTRLEN);
		inet_ntop(AF_INET6, &(Sezeni->ipv6_adresa_2), adresa_2_str, INET6_ADDRSTRLEN);
	}

	char timestamp[40];
	sprintf(timestamp, "%ld", (long int)cas->tv_sec);

	int velikost_zpravy = 0;
	velikost_zpravy += strlen(PROTOKOL[protokol]);
	velikost_zpravy += strlen(timestamp);
	velikost_zpravy += strlen(TYP_IRI[typ_iri]);
	velikost_zpravy += strlen(TYP_UDALOSTI_STR[typ_udalosti]);
	velikost_zpravy += strlen(USPECH_AKCE_STR[uspech_udalosti]);
	velikost_zpravy += strlen(Sezeni->ID_uzivatele);
	velikost_zpravy += strlen(TRANSPORTNI_PROTOKOL[Sezeni->transportni_protokol]);
	velikost_zpravy += strlen(adresa_str);
	velikost_zpravy += strlen(port_str);
	velikost_zpravy += strlen(adresa_2_str);
	velikost_zpravy += strlen(port_2_str);

	// pridani poctu zavorek 
	velikost_zpravy += 8; // [..., (...,...), (...(.....))]
	// uvozovky adres
	velikost_zpravy += 4;
	// pridame pocet oddelovacu mezi polozkami + ukonceni radku + ukoncujici znak '\0'
	velikost_zpravy += 10*strlen(oddelovac);
	velikost_zpravy += 2;

	char *vysledne_iri = NULL;
	vysledne_iri = (char *) malloc(velikost_zpravy*sizeof(char));

	strcpy(vysledne_iri, PROTOKOL[protokol]);
	vysledne_iri = strcat(vysledne_iri, oddelovac);
	vysledne_iri = strcat(vysledne_iri, timestamp);
	vysledne_iri = strcat(vysledne_iri, oddelovac);
	vysledne_iri = strcat(vysledne_iri, TYP_IRI[typ_iri]);
	vysledne_iri = strcat(vysledne_iri, oddelovac);
	vysledne_iri = strcat(vysledne_iri, "(");
	vysledne_iri = strcat(vysledne_iri, TYP_UDALOSTI_STR[typ_udalosti]);
	vysledne_iri = strcat(vysledne_iri, oddelovac);
	vysledne_iri = strcat(vysledne_iri, USPECH_AKCE_STR[uspech_udalosti]);
	vysledne_iri = strcat(vysledne_iri, ")");
	vysledne_iri = strcat(vysledne_iri, oddelovac);
	vysledne_iri = strcat(vysledne_iri, "[");
	vysledne_iri = strcat(vysledne_iri, Sezeni->ID_uzivatele);
	vysledne_iri = strcat(vysledne_iri, oddelovac);
	vysledne_iri = strcat(vysledne_iri, "(");
	vysledne_iri = strcat(vysledne_iri, TRANSPORTNI_PROTOKOL[Sezeni->transportni_protokol]);
	vysledne_iri = strcat(vysledne_iri, oddelovac);
	vysledne_iri = strcat(vysledne_iri, "(");
	vysledne_iri = strcat(vysledne_iri, "\"");
	vysledne_iri = strcat(vysledne_iri, adresa_str);
	vysledne_iri = strcat(vysledne_iri, "\"");
	vysledne_iri = strcat(vysledne_iri, oddelovac);
	vysledne_iri = strcat(vysledne_iri, port_str);
	vysledne_iri = strcat(vysledne_iri, oddelovac);
	vysledne_iri = strcat(vysledne_iri, "\"");
	vysledne_iri = strcat(vysledne_iri, adresa_2_str);
	vysledne_iri = strcat(vysledne_iri, "\"");
	vysledne_iri = strcat(vysledne_iri, oddelovac);
	vysledne_iri = strcat(vysledne_iri, port_2_str);
	vysledne_iri = strcat(vysledne_iri, "))]");
	vysledne_iri[velikost_zpravy-2] = '\n';
	vysledne_iri[velikost_zpravy-1] = '\0';
	return vysledne_iri;
}

/*
 * zasle vytvorenou IRI do MF pomoci drive vytvoreneho spojeni
 */
void odesli_iri(char *iri)
{
	send(socket_iri, iri, strlen(iri), 0);
}

