/*
    Copyright (C) 2012  Stanislav Bárta

    This file is part of Bachelor's thesis: Creating Metadata during 
    Interception of Instant Messaging Communication.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/*
 * Soubor:  irc.h
 * Datum:   16.05.2012
 * Autor:   Stanislav Bárta, xbarta29@stud.fit.vutbr.cz
 * Projekt: BP - tvorba metadat pri odposlechu komunikace v realnem case
 * Popis:   hlavickovy soubor pro funkce zpracovavajici irc protokol
 */

#ifndef _IRC_
#define _IRC_

#include <stdio.h>
#include <stdlib.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <string.h>
#include <limits.h>
 #include <errno.h>

#include "my_string.h"
#include "zpracovany_packet.h"
#include "iri.h"
#include "sprava.h"


struct irc_prikaz
{
	char *prefix;
	char *prikaz;
	char *parametry;
};


void zpracuj_irc(struct data_packetu *zprava, struct sezeni *Sezeni, struct seznam_sledovani *Sledovani);
void zpracuj_prikaz(char *prikaz, struct sezeni *Sezeni, struct seznam_sledovani *Sledovani, int smer, struct timeval *cas_zachyceni);
void identifikuj_pozadavek(struct irc_prikaz *pozadavek, struct sezeni *Sezeni, struct seznam_sledovani *Sledovani, int smer, struct timeval *cas_zachyceni);

char *prvni_parametr(char *parametry);
int je_cislo(char *retezec);

#endif
