/*
    Copyright (C) 2012  Stanislav Bárta

    This file is part of Bachelor's thesis: Creating Metadata during 
    Interception of Instant Messaging Communication.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/*
 * Soubor:  my_xml.h
 * Datum:   16.05.2012
 * Autor:   Stanislav Bárta, xbarta29@stud.fit.vutbr.cz
 * Projekt: BP - tvorba metadat pri odposlechu komunikace v realnem case
 * Popis:   hlavickovy soubor pro funkce zpracovavajici xml
 */

#ifndef _MY_XML_
#define _MY_XML_

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "my_string.h"
#include "zpracovany_packet.h"

struct xml
{
	char *element;
	int pocet_atributu;
	char **atributy;
	char *obsah;
	struct xml *predchudce;
	int pocet_potomku;
	struct xml **potomci;
};


struct xml *analyza_stanzy(char *stanza);
void novy_element(struct xml *xml_struktura, struct xml *predchudce, char *jmeno);
void pridej_potomka(struct xml *xml_struktura, char *jmeno);
void pridej_atribut(struct xml *xml_struktura, char *atribut);
int porovnani_typu_atributu(char *atribut, char *vzor);
int porovnani_hodnoty_atributu(char *atribut, char *vzor);
char *ziskej_hodnotu_atributu(char *atribut);
void uvolneni_xml(struct xml *xml);

#endif
