/*
    Copyright (C) 2012  Stanislav Bárta

    This file is part of Bachelor's thesis: Creating Metadata during 
    Interception of Instant Messaging Communication.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/*
 * Soubor:  iri.h
 * Datum:   16.05.2012
 * Autor:   Stanislav Bárta, xbarta29@stud.fit.vutbr.cz
 * Projekt: BP - tvorba metadat pri odposlechu komunikace v realnem case
 * Popis:   hlavickovy soubor pro funkce k vytvoreni a odeslani zprav IRI
 */

#ifndef _IRI_
#define _IRI_

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <unistd.h>
#include <netdb.h>
#include <time.h>

#include "zpracovany_packet.h"
#include "sprava.h"

#define IRI_REPORT 0
#define IRI_BEGIN 1
#define IRI_CONTINUE 2
#define IRI_END 3

enum TYPY_UDALOSTI
{
	TYP_AUTENTIZACE,
	TYP_PRIHLASEN,
	TYP_PRIJATA_ZPRAVA,
	TYP_ODESLANA_ZPRAVA,
	TYP_PRIJATO_OZNAMENI,
	TYP_ODESLANO_OZNAMENI,
	TYP_ODHLASEN,
	TYP_ONLINE,
	TYP_AWAY,
	TYP_CHAT,
	TYP_DND,
	TYP_NA,
	TYP_OCCUPIED,
	TYP_INVISIBLE,
	TYP_PRIPOJENI_KE_KANALU,
	TYP_ODPOJEN_OD_KANALU
};

enum USPECH_AKCE
{
	NEZNAMO,
	USPESNE,
	NEUSPESNE
};

// socket kam se zasílají IRI
int socket_iri;

int otevri_spojeni_pro_iri(char *host, char *port);
void uzavri_spojeni_pro_iri(void);

//char *vytvor_iri(int typ_iri, char *jiid, int cin, int protokol, int typ_udalosti, struct in_addr adresa, char *ID, struct timeval *cas);
char *vytvor_iri(int typ_iri, int protokol, struct sezeni *Sezeni, int typ_udalosti, int uspech_udalosti, struct timeval *cas);
void odesli_iri(char *iri);

#endif
