/*
    Copyright (C) 2012  Stanislav Bárta

    This file is part of Bachelor's thesis: Creating Metadata during 
    Interception of Instant Messaging Communication.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/*
 * Soubor:  detekce_protokolu.c
 * Datum:   16.05.2012
 * Autor:   Stanislav Bárta, xbarta29@stud.fit.vutbr.cz
 * Projekt: BP - tvorba metadat pri odposlechu komunikace v realnem case
 * Popis:   soubor obsahujici funkci ktera analyzuje prijaty paket a vrati zjistene udaje.
 *          v pripade, ze se jedna o podporovany protokol je ulozen i prenaseny obsah s aplikacnim protokolem
 */

#include "detekce_protokolu.h"

/*
 * ze zachyceneho packetu vyfiltruje informace tykajici se zkoumanych protokolu
 * v pripade jineho nez odposlouchavaneho protokolu je identifikovan jako neznamy
 */
struct data_packetu ziskej_obsah(const struct pcap_pkthdr *header, const u_char *packet)
{
	// struktura ktera bude obsahovat potrebne informace ze zachyceneho packetu
	struct data_packetu vyfiltrovano_z_packetu;

	vyfiltrovano_z_packetu.transportni_protokol = NEUVEDENO;
	vyfiltrovano_z_packetu.typ = NEZNAME;
	vyfiltrovano_z_packetu.cas_zachyceni = header->ts;
	vyfiltrovano_z_packetu.data = NULL;

	// pretypovani prijateho packetu na strukturu ethernetove hlavicky
	struct ether_header *ethernetova_hlavicka;
	ethernetova_hlavicka = (struct ether_header *) packet;

	// kontrola typu jestli jde o packet ipv4 nebo ipv6 
	if(ntohs(ethernetova_hlavicka->ether_type) == ETHERTYPE_IP) // ipv4
	{
		vyfiltrovano_z_packetu.verze_ip = IPverze4;
		// pretypovani na strukturu ipv4 packetu
		// posunuti ukazatele o velikost ethernetoveho ramce
		struct ip *ipv4_packet;
		ipv4_packet = (struct ip *) (packet + ETHER_HDR_LEN);
		int ipv4_length = (ipv4_packet->ip_hl)*4;

		if(ipv4_packet->ip_p == 6) // TCP protokol
		{
			vyfiltrovano_z_packetu.transportni_protokol = TCP;
			struct tcphdr *tcp_header;
			tcp_header = (struct tcphdr *) (packet + ETHER_HDR_LEN + ipv4_length);
			// vypočítáme velikost tcp hlavičky v bajtech
			int velikost_tcp_hlavicky = tcp_header->th_off*4;

			// ziskame velikost dat v zachycenem packetu
			int velikost_dat = ntohs(ipv4_packet->ip_len) - (ipv4_length + velikost_tcp_hlavicky);
			vyfiltrovano_z_packetu.velikost_dat = velikost_dat;

			// podle portu zkusime urcit o jaky se jedna protkol
			int protokol = podle_portu(ETHER_HDR_LEN + ipv4_length, packet);
			if(protokol != NEURCENO)
			{
				if((protokol == XMPP_odchozi || protokol == XMPP_prichozi) && velikost_dat > 0)
				{
					// pomocny ukazatel ukazujici na zacatek dat v packetu
					char *pomocny = (char *) (packet + ETHER_HDR_LEN + ipv4_length + velikost_tcp_hlavicky);
					// kopie dat
					kopie_retezce(pomocny, &(vyfiltrovano_z_packetu.data), velikost_dat);

					vyfiltrovano_z_packetu.typ = XMPP;

					if(protokol == XMPP_odchozi)
					{
						vyfiltrovano_z_packetu.smer = odchozi;
					}
					else if(protokol == XMPP_prichozi)
					{
						vyfiltrovano_z_packetu.smer = prichozi;
					}
				} // konec XMPP
				else if((protokol == IRC_odchozi || protokol == IRC_prichozi) && velikost_dat > 0)
				{
					// pomocny ukazatel ukazujici na zacatek dat v packetu
					char *pomocny = (char *) (packet + ETHER_HDR_LEN + ipv4_length + velikost_tcp_hlavicky);
					// kopie dat
					kopie_retezce(pomocny, &(vyfiltrovano_z_packetu.data), velikost_dat);

					vyfiltrovano_z_packetu.typ = IRC;

					if(protokol == IRC_odchozi)
					{
						vyfiltrovano_z_packetu.smer = odchozi;
					}
					else if(protokol == IRC_prichozi)
					{
						vyfiltrovano_z_packetu.smer = prichozi;
					}
				} // konec IRC
				else if((protokol == OSCAR_odchozi || protokol == OSCAR_prichozi) && velikost_dat > 0)
				{
					// ulozeni ukazatele na data (oscar je binarni a zpracovava se odlisne od predchozich protokolu)
					vyfiltrovano_z_packetu.data = (char *) (packet + ETHER_HDR_LEN + ipv4_length + velikost_tcp_hlavicky);

					vyfiltrovano_z_packetu.typ = OSCAR;

					if(protokol == OSCAR_odchozi)
					{
						vyfiltrovano_z_packetu.smer = odchozi;
					}
					else if(protokol == OSCAR_prichozi)
					{
						vyfiltrovano_z_packetu.smer = prichozi;
					}
				} // konec OSCAR

				vyfiltrovano_z_packetu.ip_zdroje = ipv4_packet->ip_src;
				vyfiltrovano_z_packetu.ip_cile = ipv4_packet->ip_dst;
				vyfiltrovano_z_packetu.port_zdroje = ntohs(tcp_header->th_sport);
				vyfiltrovano_z_packetu.port_cile = ntohs(tcp_header->th_dport);
			}
		} // konec TCP protokolu

	} // konec ipv4
/*	else if(ntohs(ethernetova_hlavicka->ether_type) == ETHERTYPE_IPV6) // ipv6
	{
		vyfiltrovano_z_packetu.verze_ip = IPverze6;
		// pretypovani na strukturu ipv6 packetu
		// posunuti ukazatele o velikost ethernetoveho ramce
		struct ip6_hdr *ipv6_packet;
		ipv6_packet = (struct ip6_hdr *) (packet + ETHER_HDR_LEN);

	} // konec ipv6*/

	return vyfiltrovano_z_packetu;
}

/*
 * podle portu vrati typ prenaseneho aplikacniho protkolu
 */
int podle_portu(int length, const u_char *packet)
{
	struct tcphdr *tcp_header;
	tcp_header = (struct tcphdr *) (packet + length);

	int zdroj = ntohs(tcp_header->th_sport);
	int cil = ntohs(tcp_header->th_dport);

	// XMPP komunikace
	if(zdroj == 5222)
	{
		return XMPP_prichozi;
	}

	if(cil == 5222)
	{
		return XMPP_odchozi;
	}

	// IRC komunikace
	if(zdroj == 6665 || zdroj == 6666 || zdroj == 6667 || zdroj == 6668 || zdroj == 6669)
	{
		return IRC_prichozi;
	}

	if(cil == 6665 || cil == 6666 || cil == 6667 || cil == 6668 || cil == 6669)
	{
		return IRC_odchozi;
	}

	// OSCAR komunikace
	if(zdroj == 5190 || zdroj == 5191 || zdroj == 5192 || zdroj == 5193)
	{
		return OSCAR_prichozi;
	}

	if(cil == 5190 || cil == 5191 || cil == 5192 || cil == 5193)
	{
		return OSCAR_odchozi;
	}

	// komunikace ktera nas nezajima
	return NEURCENO;
}

