/** @file translator.h
* hlavickovy soubor pro translator.cpp
* @author Radek Hranicky
*/

/*
LIS Deception Proxy - Tento nastroj slouzi pro demonstraci utoku na system pro zakonne odposlechy
Copyright (C) 2012 Radek Hranicky

Tento program je svobodny software: muzete jej sirit a upravovat podle ustanoveni Obecne verejne licence GNU (GNU General Public License),
vydavane Free Software Foundation a to bud podle 3. verze teto Licence, nebo (podle vaseho uvazeni) kterekoli pozdejsi verze.

Tento program je rozsirovan v nadeji, ze bude uzitecny, avas BEZ JAKEKOLIV ZARUKY. Neposkytuji se ani odvozene zaruky PRODEJNOSTI
anebo VHODNOSTI PRO URCITY UCEL. Dalsi podrobnosti hledejte v Obecne verejne licenci GNU.

Kopii Obecne verejne licence GNU jste meli obdrzet spolu s timto programem. Pokud se tak nestalo, najdete ji zde: <http://www.gnu.org/licenses/>.
*/

#ifndef TRANSLATOR_H
#define TRANSLATOR_H

#include <arpa/inet.h>

#define MAX_PREFIX_LEN 128 // Maximalni teoreticka delka prefixu

typedef struct s_in6_hex_addr {
  uint16_t addr_hextet[8];
} in6_hex_addr;


bool comparePrefix(in6_addr ipv6Addr, in6_addr prefix, int prefixLen);
int detectEndianness ();
uint16_t joinOctets(uint8_t octet_a, uint8_t octet_b);
void splitOctets(uint16_t hextet, uint8_t& octet_a, uint8_t& octet_b);
void zerosFill(in6_addr& ipv6Addr, int effectiveLength);
in6_hex_addr in6ToHexAddr(in6_addr& ipv6Addr);
in6_addr hexToIn6Addr(in6_hex_addr& hextet_form);
uint16_t calculateAdjustment(in6_hex_addr& prefixFrom, in6_hex_addr& prefixTo);
bool validateInterfaceID(in6_addr ipv6Addr);
int translateAddress(in6_addr ipv6Addr, in6_addr& ipv6AddrTranslated,
                      in6_addr prefixFrom, int prefixFromLen,
                      in6_addr prefixTo,   int prefixToLen
                    );

enum endianness {
  END_LITTLE,
  END_BIG
};

#endif
