/** @file packet.h
* hlavickovy soubor k packet.cpp
* @author Radek Hranicky
*/

/*
LIS Deception Proxy - Tento nastroj slouzi pro demonstraci utoku na system pro zakonne odposlechy
Copyright (C) 2012 Radek Hranicky

Tento program je svobodny software: muzete jej sirit a upravovat podle ustanoveni Obecne verejne licence GNU (GNU General Public License),
vydavane Free Software Foundation a to bud podle 3. verze teto Licence, nebo (podle vaseho uvazeni) kterekoli pozdejsi verze.

Tento program je rozsirovan v nadeji, ze bude uzitecny, avas BEZ JAKEKOLIV ZARUKY. Neposkytuji se ani odvozene zaruky PRODEJNOSTI
anebo VHODNOSTI PRO URCITY UCEL. Dalsi podrobnosti hledejte v Obecne verejne licenci GNU.

Kopii Obecne verejne licence GNU jste meli obdrzet spolu s timto programem. Pokud se tak nestalo, najdete ji zde: <http://www.gnu.org/licenses/>.
*/

#ifndef PACKET_H
#define PACKET_H

#include <pthread.h>

#define NEXT_HEADER_TCP 6

#define IPV6_FIXED_HEADER_LEN 40

#define ICMPV6_NEXT_HEADER 58
#define ICMPV6_HOP_LIMIT 64

#define ICMPV6_UNREACH_TYPE 1
#define ICMPV6_UNREACH_CODE 0

#define ICMPV6_PARAMETER_TYPE 4
#define ICMPV6_PARAMETER_CODE 0

#define ICMPV6_ECHO_TYPE 128
#define ICMPV6_ECHO_CODE 0

#define ICMPV6_ECHOREPLY_TYPE 129
#define ICMPV6_ECHOREPLY_CODE 0

using namespace std;

enum icmpv6Type {
  ICMPV6_UNREACH,
  ICMPV6_PARAMETER,
  ICMPV6_ECHO
};

typedef struct s_icmpv6Header {
    uint8_t type;        // typ zpravy
    uint8_t code;        // kod zpravy
    uint16_t checksum;   // kontrolni soucet
    union u_body {
      struct s_generic {
        uint32_t body;
      };
      struct s_echo {
        uint16_t identifier; // identifikator
        uint16_t sequence;   // sekvencni cislo
      };
    };
} t_icmpv6;

union u_icmpv6Body {
      struct {
        uint32_t body;
        u_char data[56];
      } s_generic;
      struct {
        uint16_t identifier; // identifikator
        uint16_t sequence;   // sekvencni cislo
        u_char data[56];
      } s_echo;
};

typedef struct s_Ip6Icmp6 { // cely datagram s ICMPv6 zpravou
    struct ip6_hdr ipv6_header;              // IPv6 hlavicka
    struct s_icmpv6Header icmpv6_header; // ICMPv6 hlavicka
    union u_icmpv6Body icmpv6_body; // ICMPv6 hlavicka
} t_Ip6Icmp6;


enum TPacketDirection {
  TO_SENDER,
  TO_RECEIVER
};

class Packet {
  private:
    TPacketDirection direction;
    string capturedInt;
    string targetInt;
    unsigned long int pNum;

    /* IPv6 */
    uint8_t *ipv6_datagram;
    ip6_hdr *ipv6_header;
    unsigned int ipv6_datagramLen;
    in6_addr ipv6_srcIP_untranslated;
    in6_addr ipv6_dstIP_untranslated;

    /* ICMPv6 */
    t_icmpv6 *icmpv6_header;

    /* TCP */
    uint8_t *tcp_datagram;
    struct tcphdr  *tcp_header;
    uint8_t *tcp_data;

  public:
    Packet (uint8_t* packetPtr, unsigned int packetLen, TPacketDirection pktDirection, unsigned long int num);
    unsigned long int get_pktNum();
    void truncPacket(unsigned int newLen);
    void setCapturedInterface(string cptIf);
    void setTargetInterface(string targetIf);
    string capturedInterface();
    string targetInterface();
    TPacketDirection packetDirection();
    unsigned int ipv6_len();
    in6_addr ipv6_srcIP();
    in6_addr ipv6_dstIP();
    in6_addr ipv6_sndIP();
    in6_addr ipv6_rcvIP();
    void set_translated_ipv6_srcIP(in6_addr addr);
    void set_translated_ipv6_dstIP(in6_addr addr);
    uint8_t ipv6_hlim();
    void set_ipv6_hlim(uint8_t newHlim);
    uint16_t ipv6_plen();
    void set_ipv6_plen(uint16_t newPlen);
    bool is_tcp();
    unsigned int tcp_header_len();
    void tcp_calculate_checksum();
    uint16_t tcp_sndPort();
    uint16_t tcp_rcvPort();
    bool tcp_syn();
    bool tcp_ack();
    bool tcp_fin();
    bool tcp_rst();
    unsigned int tcp_dataLen();
    uint32_t tcp_ackSeq();
    uint32_t tcp_seq();
    void set_tcp_seq(uint32_t newSeq);
    bool is_icmpv6();
    bool is_icmpv6_echoReply();
    uint16_t icmpv6_echoReply_id();
    uint16_t icmpv6_echoReply_seq();
    uint8_t * ipv6Ptr();
    ip6_hdr * ipv6_headerPtr();
    tcphdr * tcp_headerPtr();
    uint8_t * tcpDataPtr();
    ~Packet();
};

#endif
