/** @file errors.cpp
* zdrojovy soubor s implemenaci vypisu chybovych zprav a napovedy
* @author Radek Hranicky
*/

/*
LIS Deception Proxy - Tento nastroj slouzi pro demonstraci utoku na system pro zakonne odposlechy
Copyright (C) 2012 Radek Hranicky

Tento program je svobodny software: muzete jej sirit a upravovat podle ustanoveni Obecne verejne licence GNU (GNU General Public License),
vydavane Free Software Foundation a to bud podle 3. verze teto Licence, nebo (podle vaseho uvazeni) kterekoli pozdejsi verze.

Tento program je rozsirovan v nadeji, ze bude uzitecny, avas BEZ JAKEKOLIV ZARUKY. Neposkytuji se ani odvozene zaruky PRODEJNOSTI
anebo VHODNOSTI PRO URCITY UCEL. Dalsi podrobnosti hledejte v Obecne verejne licenci GNU.

Kopii Obecne verejne licence GNU jste meli obdrzet spolu s timto programem. Pokud se tak nestalo, najdete ji zde: <http://www.gnu.org/licenses/>.
*/

#include <iostream>

using namespace std;

const char *Error_msg[] =
{
  "",	// EOK
  "Spatne zadane parametry!",
  "Chyba pri kompilaci regularniho vyrazu!",
  "Nepodarilo se otevrit konfiguracni soubor!",
  "Je potreba definovat alespon jedno pravidlo pro preklad!",
  "Je potreba definovat alespon jedno vystupni rozhrani!",
  "Chyba pri zachytavani paketu!",
  "Chyba pri naslouchani na rozhrani!",
  "Chybne zapsany IPv6 prefix. Zkontrolujte spravnost zapisu!",
  "Prefix adresy nesmi byt delsi nez celkova delka adresy!",
  "Soubor s pravidly pro preklad je v nespravnem formatu!",
  "Chyba pri inicializaci kontextu libnetu!",
  "Neznamy konfiguracni zaznam!",
  "Nepodarilo se pristoupit k souboru s podvrzenou zpravou!",
  "", // IID obsahuje pouze nuly. Nevypisujeme nic, ale generujeme ICMPv6 Parameter Problem error,
  "Chyba pri vytvareni vlakna!",
  "Nedostatek pameti!",
  "Chyba pri inicializaci semaforu!",
  "Chyba pri inicializace cekaci podminky vlakna!",
  "Nepodarilo se vytvorit spojeni! Zrejme neni dostatek prostredku.."
};

/**
 * Vypise zpravu o chybe na chybovy vystup
 * @param errNum kod chyby
 */
void printError(int errNum) {
  cerr << Error_msg[errNum] << endl;
  return;
}

/**
 * Vypis napovedy
 */
void printHelp() {
  cout << "== LI deceive proxy ==" << endl;
  cout << "Tento nastroj slouzi pro demonstraci utoku na LIS" << endl;
  cout << "pouziti:" << endl;
  cout << "./ldp <konfiguracni soubor>" << endl;
  return;
}
