/** @file net.h
* hlavickovy soubor k net.cpp
* @author Radek Hranicky
*/

/*
LIS Deception Proxy - Tento nastroj slouzi pro demonstraci utoku na system pro zakonne odposlechy
Copyright (C) 2012 Radek Hranicky

Tento program je svobodny software: muzete jej sirit a upravovat podle ustanoveni Obecne verejne licence GNU (GNU General Public License),
vydavane Free Software Foundation a to bud podle 3. verze teto Licence, nebo (podle vaseho uvazeni) kterekoli pozdejsi verze.

Tento program je rozsirovan v nadeji, ze bude uzitecny, avas BEZ JAKEKOLIV ZARUKY. Neposkytuji se ani odvozene zaruky PRODEJNOSTI
anebo VHODNOSTI PRO URCITY UCEL. Dalsi podrobnosti hledejte v Obecne verejne licenci GNU.

Kopii Obecne verejne licence GNU jste meli obdrzet spolu s timto programem. Pokud se tak nestalo, najdete ji zde: <http://www.gnu.org/licenses/>.
*/

#ifndef NET_H
#define NET_H

#include "packet.h"

#define PROMISC 1

void sendIcmpMessage(in6_addr dest_addr, string ifName, int messageType, uint8_t hopLimit, uint16_t echo_id, uint16_t echo_seq, TConfig &cfg);
void closeInterfaces(TConfig cfg);
bool openInterfaces(list<TInterface>& interface_list, fd_set& read_set, int& max_fd);
bool isLinkLocal(in6_addr addr);
libnet_ether_addr getInterfaceMac(string ifName, TConfig &cfg);
in6_addr getInterfaceIP(string ifName, TConfig &cfg);
bool compareMac(libnet_ether_addr& mac1, libnet_ether_addr& mac2);
string ipv6ToStr(in6_addr addr);

#endif
