/* spi.h - Header file: SPI functions.
 * Author: Vlastimil Kosar ikosar@fit.vutbr.cz
 */

/*
 * Just dummy for debug.
 */

//typedef void (*XSpi_StatusHandler) (void *CallBackRef, uint32_t StatusEvent,
//                    unsigned int ByteCount);

//typedef struct {
//    uint32_t ModeFaults;     /**< Number of mode fault errors */
//    uint32_t XmitUnderruns;  /**< Number of transmit underruns */
//    uint32_t RecvOverruns;   /**< Number of receive overruns */
//    uint32_t SlaveModeFaults;    /**< Num of selects as slave while disabled */
//    uint32_t BytesTransferred;   /**< Number of bytes transferred */
//    uint32_t NumInterrupts;  /**< Number of transmit/receive interrupts */
//} XSpi_Stats;

//typedef struct {
//    XSpi_Stats Stats;   /**< Statistics */
//    uint32_t BaseAddr;       /**< Base address of device (IPIF) */
//    int IsReady;        /**< Device is initialized and ready */
//    int IsStarted;      /**< Device has been started */
//    int HasFifos;       /**< Device is configured with FIFOs or not */
//    uint32_t SlaveOnly;      /**< Device is configured to be slave only */
//    uint8_t NumSlaveBits;    /**< Number of slave selects for this device */
//    uint8_t DataWidth;       /**< Data Transfer Width 8 or 16 or 32 */
//    uint8_t SpiMode;     /**< Standard/Dual/Quad mode */
//    uint32_t SlaveSelectMask;    /**< Mask that matches the number of SS bits */
//    uint32_t SlaveSelectReg; /**< Slave select register */

//    uint8_t *SendBufferPtr;  /**< Buffer to send  */
//    uint8_t *RecvBufferPtr;  /**< Buffer to receive */
//    unsigned int RequestedBytes; /**< Total bytes to transfer (state) */
//    unsigned int RemainingBytes; /**< Bytes left to transfer (state) */
//    int IsBusy;     /**< A transfer is in progress (state) */

//    XSpi_StatusHandler StatusHandler; /**< Status Handler */
//    void *StatusRef;    /**< Callback reference for status handler */
//} XSpi;

// SD informations & SPI config
#include <xspi_l.h>
#include <xspi.h>

typedef struct
{
    uint32_t type;
    XSpi     spi_instance;
} t_sd_info;

/*
 * Init SPI for comunication with the SD card.
 * Params: 
 *   info - informations about SD card
 * Returns: 1 if everything is OK, 0 if error happend.
 */
uint32_t spi_init(t_sd_info *info);

/*
 * Send some empty data via SPI to wake up the SD card
 * Params:
 *   info - informations about SD card
 */
void spi_sd_wake_up(t_sd_info *info);

/*
 * Transfer data via SPI.
 * Params: 
 *   SendBufPtr - a pointer to a buffer of data which is to be sent.
 *                This buffer must not be NULL.
 *   RecvBufPtr - a pointer to a buffer which will be filled with
 *                received data. This argument can be NULL if the caller does not
 *                wish to receive data.
 *   ByteCount  - contains the number of bytes to send/receive. The
 *                number of bytes received always equals the number of bytes sent.
 *   info       - informations about SD card
 * Returns: 1 if everything is OK, 0 if error happend.
 */
uint32_t spi_transfer(uint8_t *SendBufPtr, uint8_t *RecvBufPtr, uint32_t ByteCount, t_sd_info *info);

/*
 * Disable and cleanup SPI for comunication with the SD card.
 * Params:
 *   info - informations about SD card
 */
void spi_destructor(t_sd_info *info);
