/* fat.h - Header file: Handling the 16 bit File Allocation Table (FAT16).
 *                      Handling the 32 bit File Allocation Table (FAT32).
 * Author: Vlastimil Kosar <ikosar@fit.vutbr.cz>
 */

// define FAT types
#define FAT16 1
#define FAT32 2

/*
 * Reads file from FAT
 * Params:
 *   file_name - padded file name of loaded image
 *   partition - partition which should contain the file
 *   address   - address to which the image will be loaded
 *   sd_info   - inforamtions about SD card
 * Returns: 1 if everything is OK, 0 if error happend.
 */
uint32_t read_file_from_fat(unsigned char file_name[11], t_partition partition, t_run_info *address, t_sd_info *sd_info);
