/* compose.c - Source file: Composition functions.
 * Author: Vlastimil Kosar <ikosar@fit.vutbr.cz>
 */

#include <stdint.h>
#include "compose.h"


/*
 * Compose 2 consequtive bytes into one 16-bit number. Convert endianness if necessery.
 * Params:
 *   data - pointer to array of bytes.
 *   source_endian - source endian LITTLE/BIG
 *   destination_endian - destination endian LITTLE/BIG
 *   Currently supported only LITTLE, LITTLE.
 *  Returns composed number.
 */
uint16_t compose_16(uint8_t *data, uint8_t source_endian, uint8_t destination_endian)
{
    uint16_t res = 0;
    
    if (source_endian == LITTLE)
    {
        if (destination_endian == LITTLE)
        {
            res = data[1];
            res = res << 8;
            res += data[0];
        }
        else
        {
        }
    }
    else
    {
        if (destination_endian == LITTLE)
        {
        }
        else
        {
        }
    }
    
    return res;
}

/*
 * Compose 4 consequtive bytes into one 32-bit number. Convert endianness if necessery.
 * Params:
 *   data - pointer to array of bytes.
 *   source_endian - source endian LITTLE/BIG
 *   destination_endian - destination endian LITTLE/BIG
 *   Currently supported only LITTLE, LITTLE.
 *  Returns composed number.
 */
uint32_t compose_32(uint8_t *data, uint8_t source_endian, uint8_t destination_endian)
{
    uint32_t res = 0;
    
    if (source_endian == LITTLE)
    {
        if (destination_endian == LITTLE)
        {
            res = data[3];
            res = res << 8;
            res += data[2];
            res = res << 8;
            res += data[1];
            res = res << 8;
            res += data[0];
        }
        else
        {
        }
    }
    else
    {
        if (destination_endian == LITTLE)
        {
        }
        else
        {
        }
    }
    
    return res;
}
