/* bootloader.c - Source file: Bootloader main source.
 * Author: Vlastimil Kosar ikosar@fit.vutbr.cz
 */
#include <stdint.h>
#include <stdlib.h>
#include <stdio.h>
#include "parameters.h"
#include "boot_global_defs.h"
#include "spi.h"
#include "sd.h"
#include "errors.h"
#include "compose.h"
#include "mbr.h"
#include "fat.h"
#include "mb_hw.h"

//image specifications
t_run_info image;

void _interrupt_handler () {}
void _exception_handler () {}
void _hw_exception_handler () {}

// TODO: change to version without std library
int main()
{
    t_sd_info sd_info;
    t_mbr_info partitions;

#ifdef DEBUG
    // Print bootloader info
    xil_printf("\r\nuSonda SD card bootloader:\r\n Card support: SD, SDHC and SDXC\r\n FS support: FAT16, FAT32\r\n\r\n");
#endif

    // Run post
    if (post() == 0)
    {
    	// disable SPI to init state
		spi_destructor(&sd_info);
		// handle errors - never returns
		handle_error();
    }

    // init sd card
    if (sd_init(&sd_info) == 0)
    {
    	// disable SPI to init state
    	spi_destructor(&sd_info);
    	// handle errors - never returns
    	handle_error();
    }
    
    // read MBR of SD card
    if (read_mbr(&partitions, &sd_info) == 0)
    {
    	// disable SPI to init state
    	spi_destructor(&sd_info);
    	// handle errors - never returns
    	handle_error();
    }
    
    // Read file from FAT
    if (PARTITION > -1)
    {
		if (read_file_from_fat(IMAGE_FILE, partitions[PARTITION], &image, &sd_info) == 0)
		{
			// disable SPI to init state
			spi_destructor(&sd_info);
			// handle errors - never returns
			handle_error();
		}
    }
    else
    {
    	uint8_t i;
    	for (i = 0; i < 3; i++)
    	{
    		if (partitions[PARTITION].valid == 1)
    		{
    			if (read_file_from_fat(IMAGE_FILE, partitions[PARTITION], &image, &sd_info) == 0)
				{
    				// disable SPI to init state
    				spi_destructor(&sd_info);
					// handle errors - never returns
					handle_error();
				}
    			else
    			{
    				break;
    			}
    		}
    	}
    }
    
    // disable SPI to init state
    spi_destructor(&sd_info);

    // Run loaded image
    kick_and_pray(&image);

    // Should never return
    return 0;
}
