
#include "serial-sync.h"

#define COMPORT "COM5" // or whatever you need. If it is beyond COM9 you need to write something like "\\COM12", ask daniele for details
#define COMBAUDRATE CBR_115200
#define COMBYTESIZE 8
#define COMSTOPBITS ONESTOPBIT
#define COMPARITY EVENPARITY
#define COMTIMEOUTMSEC 1

void CloseComPort4Sync(HANDLE *hSerial)
{
	CloseHandle(*hSerial);
}

HANDLE OpenComPort4Sync()
{
	HANDLE hSerial;
	hSerial = CreateFile(COMPORT,
				GENERIC_READ,
				0,
				0,
				OPEN_EXISTING,
				FILE_ATTRIBUTE_NORMAL,
				0);
	if(hSerial==INVALID_HANDLE_VALUE){
		if(GetLastError()==ERROR_FILE_NOT_FOUND){
			printf("No such port!\n");
		}
		printf("invalid port!\n");
		return 0;
	}
	
	DCB dcbSerialParams = {0};
	DCB dcbSerial;
	dcbSerial.DCBlength=sizeof(dcbSerialParams);
	if (!GetCommState(hSerial, &dcbSerialParams)) {
		printf("error getting port params!\n");
		return 0;
	}
	dcbSerialParams.BaudRate=COMBAUDRATE;
	dcbSerialParams.ByteSize=COMBYTESIZE;
	dcbSerialParams.StopBits=COMSTOPBITS;
	dcbSerialParams.Parity=COMPARITY;
	if(!SetCommState(hSerial, &dcbSerialParams)){
		printf("error setting port params!\n");
		return 0;
	}
	
	COMMTIMEOUTS timeouts={0};
	if(!GetCommTimeouts(hSerial, &timeouts)) {
		printf("error getting port timeout!\n");
		return 0;
	}

	//timeouts.ReadIntervalTimeout=50;
	timeouts.ReadTotalTimeoutConstant=COMTIMEOUTMSEC;
	//timeouts.ReadTotalTimeoutMultiplier=10;
	//timeouts.WriteTotalTimeoutConstant=50;
	//timeouts.WriteTotalTimeoutMultiplier=10;
	if(!SetCommTimeouts(hSerial, &timeouts)){
		printf("error setting port timeout!\n");
		return 0;
	}
	return hSerial;
}

long GetSyncNumbFromSerial(HANDLE hSerial)
{
	const int n = 11;
	static char szBuff[n+1] = {0};
	DWORD dwBytesRead = 0;
	int index;
	bool trovato;
	unsigned int *timestamp;
	
	if(!ReadFile(hSerial, szBuff, n, &dwBytesRead, NULL))
	{
		printf("error reading port\n");
		return -1;
	} 
	else 
	{
		if(dwBytesRead==0)
		{
			//printf("A\n");
			return -1;
		}
		index =(int)dwBytesRead-6;
		
		if(index<0) 
		{
			//printf("B\n");
			return -2;
		}

		trovato=false;
		while(true)
		{
			if(szBuff[index]=='T' && szBuff[index+1]=='T')
			{
				trovato=true;
				break;
			}
			index--;
			if(index<=0)
				break;
		}
		if(!trovato)
		{
			//printf("A\n");
			return -1;
		}
		timestamp=(unsigned int*)(szBuff+index+2);
		//printf("bytes read %02d -- sync %c %c -- timesp %d\n",dwBytesRead,szBuff[index+0],szBuff[index+1],*timestamp);
	}
	return (long)(*timestamp);
}
