/*
								+----------------------------------+
								|                                  |
								|  ***  Geo-Sphere primitive  ***  |
								|                                  |
								|   Copyright  -tHE SWINe- 2007   |
								|                                  |
								|           GeoSphere.h            |
								|                                  |
								+----------------------------------+
*/

/*
 *	2008-06-24
 *
 *	renamed CPolygon2::r_t_Vertex() and CPolyMesh::r_t_Vertex() to
 *	CPolygon2::r_Vertex() and CPolyMesh::r_Vertex() respectively
 *
 */

#ifndef __GEOSPHERE_GEN_INCLUDED
#define __GEOSPHERE_GEN_INCLUDED

/*
 *	class CTesselate
 *		- simple tesselation modifier without surface tension
 */
class CTesselate {
public:
	/*
	 *	static bool CTesselate::Tesselate(CPolyMesh &r_t_mesh, bool b_force_quads = false)
	 *		- tesselates r_t_mesh by turning each of it's triangles to four smaller triangles
	 *		  by bisecting edges of the original triangle and winding triangles between them
	 *		- in case mesh is not just triangles or b_force_quads is true, each polygon
	 *		  is turned to as many quads as polygon vertices, using bisected edges again
	 *		  and all sharing one more vertex in center of the polygon
	 *		- returns true on success, false on failure
	 */
	static bool Tesselate(CPolyMesh &r_t_mesh, bool b_force_quads = false);
};

/*
 *	class CSpherify
 *		- spherify modifier; moves mesh vertices to a sphere
 */
class CSpherify {
public:
	/*
	 *	static void CSpherify::Spherify(CPolyMesh &r_t_mesh, Vector3f v_center, float f_radius)
	 *		- projects all vertices of r_t_mesh onto sphere with
	 *		  center at v_center and radius f_radius
	 */
	static void Spherify(CPolyMesh &r_t_mesh, Vector3f v_center, float f_radius);

	/*
	 *	static void CSpherify::Spherify(CPolyMesh &r_t_mesh)
	 *		- automatic spherify; radius and center are chosen based on bounding box
	 */
	static void Spherify(CPolyMesh &r_t_mesh);
};

/*
 *	class CMakeGeoSphere
 *		- geodesic spehre factory class
 */
class CMakeGeoSphere {
protected:
	static const float m_p_vertex[12][3];
	static const int m_p_face[20][3];
	// uses icosahedron as base

public:
	/*
	 *	static bool CMakeGeoSphere::MakeGeoSphere(CPolyMesh &r_t_mesh,
	 *		int n_tesselation, bool b_force_quads = false, float f_radius = 1)
	 *		- creates geodesic sphere with center at origin, radius f_radius
	 *		  and tesselation n_tesselation (tesselation 0 yields icosahedron)
	 *		- if b_force_quads is true, tesselated mesh will contain quadriliterals,
	 *		  otherwise triangles; non-tesselated mesh is always made of triangles
	 *		- r_t_mesh is filled with sphere data; any original contents are deleted
	 *		- returns true on success, false on failure
	 */
	static bool MakeGeoSphere(CPolyMesh &r_t_mesh,
		int n_tesselation, bool b_force_quads = false, float f_radius = 1);
};

#endif //__GEOSPHERE_GEN_INCLUDED
