/*
								+---------------------------------+
								|                                 |
								|        ***   Targa   ***        |
								|                                 |
								|  Copyright   -tHE SWINe- 2002  |
								|                                 |
								|             Tga.cpp             |
								|                                 |
								+---------------------------------+
*/

/*
 *	passed code revision at 2006-06-08
 *
 *	rewrote to C++, used templates and template functions to reduce code length
 *
 *	2006-07-31
 *
 *	added slight template hack to be compilable under g++/linux
 *
 *	2007-03-26
 *
 *	removed template hack, fixed the code so there's same codepath for both g++/linux and msvc/win
 *
 *	2007-12-24
 *
 *	improved linux compatibility by using posix integer types
 *
 *	2008-03-04
 *
 *	now using Integer.h header, created CTgaCodec class, exposing color conversion routines,
 *	added CTgaCodec::Save_TGA() for writing TGA images
 *
 *	2008-05-08
 *
 *	fixed minor issues in CTgaCodec::Save_TGA (RGB / BGR, alpha channel)
 *
 *	2008-11-09
 *
 *	fixed bug in CTgaCodec::Save_TGA in greyscale RLE code, runs shorter than 3 pixels came
 *	undetected, there was also typo in RGB / grey decission (= instead of ==)
 *
 *	2009-05-04
 *
 *	fixed mixed windows / linux line endings
 *
 *	2009-10-20
 *
 *	fixed some warnings when compiling under VC 2005, implemented "Security
 *	Enhancements in the CRT " for VC 2008. compare against MyProjects_2009-10-19_
 *
 */

#ifndef __BMP_INCLUDED
#define __BMP_INCLUDED

#include "Integer.h"

struct TBmp {
	char n_former_bpp; // former bpp, before conversion to RGBA8
	bool b_grayscale;
	bool b_alpha;
	int n_width, n_height;
	uint32_t *p_buffer;

	/**
	 *	@brief deletes data buffer
	 */
	inline void Free()
	{
		delete[] p_buffer;
	}

	/**
	 *	@brief deletes data buffer and this
	 */
	inline void Delete()
	{
		delete[] p_buffer;
		delete this;
	}
};

#endif //__BMP_INCLUDED

#ifndef __TARGA_INCLUDED
#define __TARGA_INCLUDED

class CTgaCodec {
public:
	/*
	 *	template <class TPaletteIndex>
	 *	struct TPaletteColor
	 *		- conversion from palette index TPaletteIndex to RGBA8
	 */
	template <class TPaletteIndex>
	struct TPaletteColor {
		typedef TPaletteIndex TDataType;

	protected:
		const uint32_t *m_p_palette;
		int m_n_palette_entries;
		int m_n_offset;

	public:
		TPaletteColor(const uint32_t *p_palette, int n_palette_entries, int n_offset)
			:m_p_palette(p_palette), m_n_palette_entries(n_palette_entries), m_n_offset(n_offset)
		{}

		inline uint32_t operator()(const TPaletteIndex &r_t_color) const
		{
			return (r_t_color + m_n_offset >= 0 &&
				r_t_color + m_n_offset < m_n_palette_entries)? m_p_palette[r_t_color + m_n_offset] : 0;
		}
	};

	/*
	 *	struct T_RGB8_Color
	 *		- conversion from RGB8 to RGBA8
	 */
	struct T_RGB8_Color {
		typedef uint8_t TDataType[3];

		inline uint32_t operator()(const TDataType &r_t_color) const
		{
			return ((uint32_t)r_t_color[0] << 16) | ((uint32_t)r_t_color[1] << 8) |
				(uint32_t)r_t_color[2] | 0xff000000;
		}
	};

	/*
	 *	struct T_BGRA8_Color
	 *		- conversion from BGRA8 to RGBA8
	 */
	struct T_BGRA8_Color {
		typedef uint32_t TDataType;

		inline uint32_t operator()(const TDataType &r_t_color) const
		{
			return (r_t_color & 0xff00ff00) | ((r_t_color & 0xff0000) >> 16) |
				((r_t_color & 0xff) << 16);
		}
	};

	/*
	 *	struct T_RGB5_Color
	 *		- conversion from RGB5 to RGBA8
	 */
	struct T_RGB5_Color {
		typedef uint16_t TDataType;

		inline uint32_t operator()(const TDataType &r_t_color) const
		{
			return n_5_to_8((r_t_color >> 10) & 0x1f) |
				  (n_5_to_8((r_t_color >> 5) & 0x1f) << 8) |
				  (n_5_to_8(r_t_color & 0x1f) << 16) | 0xff000000;
		}

	protected:
		static inline int n_5_to_8(int n_x)
		{
			return (n_x * 255 / 31) & 0xff;
		}
	};

public:
	/*
	 *	static TBmp *CTgaCodec::p_Load_TGA(const char *p_s_filename)
	 *		- loads image from p_s_filename
	 *		- returns pointer to bitmap object or 0 if loading failed
	 */
	static TBmp *p_Load_TGA(const char *p_s_filename);

	/*
	 *	static bool CTgaCodec::Save_TGA(const char *p_s_filename, const TBmp &r_t_bmp)
	 *		- write RGB targa image to file p_s_file
	 *		- if r_t_bmp.b_alpha is set, image is written as RGBA,
	 *		  otherwise as RGB
	 *		- if r_t_bmp.b_grayscale is set (while r_t_bmp.b_alpha is not),
	 *		  image is written as RLE - compressed greyscale
	 *		- note the n_former_bpp field is ignored, images are always saved as 8bpp
	 *		- returns true on success, false on failure
	 */
	static bool Save_TGA(const char *p_s_filename, const TBmp &r_t_bmp);

protected:
	static inline uint8_t n_Red(uint32_t n_rgba);
};

#endif //__TARGA_INCLUDED
