/*
								+---------------------------------+
								|                                 |
								|  ***   Simple HTML parser  ***  |
								|                                 |
								|  Copyright   -tHE SWINe- 2008  |
								|                                 |
								|          HTML_Parser.h          |
								|                                 |
								+---------------------------------+
*/

#ifndef __HTML_PARSER_INCLUDED
#define __HTML_PARSER_INCLUDED

#include "../UberLame_src/Unused.h"

bool __isspace(int c);

class CSGMLNode {
public:
	enum {
		node_Root,
		node_Element,
		node_Text,
		node_Dummy
	};

protected:
	int n_type;
	std::string s_name, s_text;
	std::vector<std::pair<std::string, std::string> > *p_param_list;
	std::vector<CSGMLNode*> subnode_list;

	static size_t n_ref_count;
	static CSGMLNode *p_dummy;

public:
	CSGMLNode(int _n_type);
	CSGMLNode(int _n_type, const char *p_s_name);
	CSGMLNode(int _n_type, std::string &r_s_name); // swaps the string
	~CSGMLNode();

	static size_t n_Population()
	{
		return n_ref_count; // number of nodes
	}

	size_t n_MemFootprint()
	{
		size_t n_params_overhead = (p_param_list)? p_param_list->capacity() * sizeof(std::pair<std::string, std::string>) : 0;
		if(p_param_list) {
			for(size_t i = 0, n = p_param_list->size(); i < n; ++ i)
				n_params_overhead += ((*p_param_list)[i].first.capacity() + (*p_param_list)[i].second.capacity()) * sizeof(char);
		}
		size_t n_node_overhead = n_params_overhead + sizeof(CSGMLNode) + (s_name.capacity() +
			s_text.capacity()) * sizeof(char) + subnode_list.capacity() * sizeof(CSGMLNode*);
		for(size_t i = 0, n = subnode_list.size(); i < n; ++ i) {
			size_t n_sub_node_overhead = subnode_list[i]->n_MemFootprint();
			if(n_node_overhead < SIZE_MAX - n_sub_node_overhead)
				n_node_overhead += n_sub_node_overhead;
			else
				return SIZE_MAX;
		}
		return n_node_overhead;
	}

	size_t n_IdealMemFootprint()
	{
		size_t n_params_overhead = (p_param_list)? p_param_list->size() * sizeof(std::pair<std::string, std::string>) : 0;
		if(p_param_list) {
			for(size_t i = 0, n = p_param_list->size(); i < n; ++ i)
				n_params_overhead += ((*p_param_list)[i].first.length() + (*p_param_list)[i].second.length()) * sizeof(char);
		}
		size_t n_node_overhead = n_params_overhead + sizeof(CSGMLNode) + (s_name.length() +
			s_text.length()) * sizeof(char) + subnode_list.size() * sizeof(CSGMLNode*);
		for(size_t i = 0, n = subnode_list.size(); i < n; ++ i) {
			size_t n_sub_node_overhead = subnode_list[i]->n_IdealMemFootprint();
			if(n_node_overhead < SIZE_MAX - n_sub_node_overhead)
				n_node_overhead += n_sub_node_overhead;
			else
				return SIZE_MAX;
		}
		return n_node_overhead;
	}

	size_t n_DataSize()
	{
		size_t n_params_size = 0;
		if(p_param_list) {
			for(size_t i = 0, n = p_param_list->size(); i < n; ++ i)
				n_params_size += ((*p_param_list)[i].first.length() + (*p_param_list)[i].second.length()) * sizeof(char);
		}
		size_t n_node_size = n_params_size + (s_name.length() + s_text.length()) * sizeof(char);
		for(size_t i = 0, n = subnode_list.size(); i < n; ++ i) {
			size_t n_sub_node_size = subnode_list[i]->n_DataSize();
			if(n_node_size < SIZE_MAX - n_sub_node_size)
				n_node_size += n_sub_node_size;
			else
				return SIZE_MAX;
		}
		return n_node_size;
	}

	size_t n_MemOverhead()
	{
		return n_MemFootprint() - n_DataSize();
	}

	inline bool b_Valid() const
	{
		return !s_name.empty() && n_type != node_Dummy;
	}

	static inline CSGMLNode *p_DummyNode()
	{
		if(!p_dummy && n_ref_count)
			p_dummy = new(std::nothrow) CSGMLNode(node_Dummy);
		return p_dummy;
	}

	bool AddChild(CSGMLNode *p_child);

	inline int n_Type() const
	{
		return n_type;
	}

	inline const std::string &s_Name() const
	{
		return s_name;
	}

	inline const std::string &s_InnerText() const
	{
		return s_text;
	}

	inline const std::vector<CSGMLNode*> &r_Subnode_List() const
	{
		return subnode_list;
	}

	const inline CSGMLNode *p_FirstChild() const
	{
		if(!subnode_list.empty())
			return subnode_list.front();
		return p_DummyNode();
	}

	const inline CSGMLNode *p_LastChild() const
	{
		if(!subnode_list.empty())
			return subnode_list.back();
		return p_DummyNode();
	}

	const CSGMLNode *p_FindChild(const char *p_s_name) const;
	const CSGMLNode *p_FindNextChild(const char *p_s_name, const CSGMLNode *p_prev) const;
	const char *p_s_FindParam(const char *p_s_name) const;

	void Dump(int n_level = -1);

	static CSGMLNode *p_Parse(const std::string &r_s_page_source);
	static CSGMLNode *p_Parse(const char *p_s_page_source);
	static CSGMLNode *p_Parse(const char *p_page_source, size_t n_length); // for not null-terminated strings (eg. file contents)

protected:
	static inline void DeleteNode(CSGMLNode *p_node);
	CSGMLNode(const CSGMLNode &UNUSED(r_node)) {} // don't copy nodes. use pointers instead
	CSGMLNode operator =(const CSGMLNode &UNUSED(r_node)) { return *this; } // don't copy nodes. use pointers instead
	static int n_Line(const std::string &r_str, int n_position);
	void Indent(int n_level);
};

#endif //__HTML_PARSER_INCLUDED
