#include <stdlib.h>
#include "match.h"

void matchInit(struct match_t * match)
{
	match->nMatches = 0;
	match->matches = 0;
	match->states = 0;
	match->n1 = 0;
	match->n2 = 0;
}

void matchFree(struct match_t * match)
{
    free(match->matches);
    free(match->states);
    match->matches = 0;
}

void matchAdd(struct match_t * match, int strPos, int state)
{
	match->nMatches++;
	match->matches = (int*) realloc((void*)match->matches, match->nMatches * sizeof(match->matches));
	match->matches[match->nMatches-1] = strPos-1;
	match->states = (int*) realloc((void*)match->states, match->nMatches * sizeof(match->states));
	match->states[match->nMatches-1] = state;
}

void matchResult(struct match_t * match, int i1, int i2)
{
	match->n1 = i1;
	match->n2 = i2;
}
