/// Lukas Kekely, xkekel00@stud.fit.vutbr.cz
/// TBM.h - hlavickovy subor modulu obsahujuceho TreeBitmap algoritmus

#ifndef MOD_TBM_H
#define MOD_TBM_H

#include <stdint.h>
#include <ctype.h>

#ifndef stride
#define stride 5
#endif

#define getbit(x,i) (((x)>>(i))&1)
#define skipSpace(cfg) { while(isspace(*cfg)) cfg++; }
#define nextWord(cfg)  { while(!isspace(*cfg)) cfg++; while(isspace(*cfg)) cfg++; }


/// nastavenie parametrov podla zvolenej dlzky kroku (poctu poschodi v podstrome)
#if stride == 3
#    define uintxx_t uint8_t    // 2^stride = pocet bitov v bitmapach
#    define mask_ptr 0x7        // binarna AND maska, pocet jednotiek OD LSB = stride
#    define lvl -3              // o kolko nizsie stride od implementovaneho maxima (max=6)
#    define FORMAT_STRING "%u %u %hhu %hhu"
#elif stride == 4
#    define uintxx_t uint16_t
#    define mask_ptr 0xf
#    define lvl -2
#    define FORMAT_STRING "%u %u %hu %hu"
#elif stride == 5
#    define uintxx_t uint32_t
#    define mask_ptr 0x1f
#    define lvl -1
#    define FORMAT_STRING "%u %u %u %u"
#elif stride == 6
#    define uintxx_t uint64_t
#    define mask_ptr 0x3f
#    define lvl 0
#    define FORMAT_STRING "%u %u %lu %lu"
#endif


/// struktura na ulozenie uzla TBM stromu
typedef struct {
    uint32_t prefix_start;  //cislo prveho prefixu v tomto uzle
    uint32_t child_start;   //cislo prveho naslednika tohto uzla
    uintxx_t prefix_bmp;    //bitmapa s ukoncenymi prefixami v tomto uzle (Interna BMP)
    uintxx_t child_bmp;     //bitmapa s pokracovaniami do inych uzlov (Externa BMP)
#ifdef topo
    uint32_t count;         //ak sa pracuje s pokrytim bude v kazdom uzle naviac pocitadlo navstev
#endif
} TBM_node;
typedef TBM_node *TBM_tree; //strom je len ukazatal na root uzol


///konstruktor a destruktor stromu
#define TBM_init(count) (TBM_tree)malloc(sizeof(TBM_node)*(count))
#define TBM_free(tree) free(tree)


///funkcie rozhrania modulu
void TBM_clean(void);        //vycistenie pamate celeho modulu
int TBM_load(char * config, size_t size);              //nacitanie reprezentacie TBM stromu zo suboru
void *TBM_lookup(uint32_t * data);
//void *TBM_lookup(void * data, unsigned int size);     //vyhladavanie v TBM strome
void TBM_print_topo();              //vypis topologie vstupneho suboru vzhladom na TBM strom a prefixovu sadu

#endif
