#include <stdio.h>
#include <stdlib.h>
#include "TBM.h"


/// globalna premenna na uchovanie TBM stromu
static TBM_tree t;
/// globalna premenna na uchovanie poctu uzlov stromu
static unsigned t_size;


///rezia naviac potrebna pre topologiu
#ifdef topo
static unsigned pref_size=0;    //pocet prefixov v celom strome
static uint32_t *pref=NULL;     //pole na pocitadla pre pocty najdeni jednotlivych prefixov
///vypis topologie
void TBM_print_topo()
{
    long unsigned sumn=0,sump=0;
    for(register unsigned i=0; i<t_size; i++)
    {
        printf("N%u %u\n",i,t[i].count);        //postupne sa vypise pocet navstev kazdeho uzlo stromu
        sumn+=t[i].count;                       //zrata sa aj celkova navstevnost
    }
    for(register unsigned i=0; i<pref_size; i++)
    {
        printf("P%u %u\n",i,pref[i]);           //podobne ako pre uzly ale pre pefixy
        sump+=pref[i];
    }
    printf("NODE S: %lu\n",sumn);               //nakoniec este celkove sumy
    printf("PREF S: %lu\n",sump);
}
/// funkcia na inicializaciu pola pre pocitadla patriace prefixom
uint32_t *TBM_pref_init(unsigned pc)
{
    uint32_t *ret=(uint32_t *)malloc(sizeof(uint32_t)*pc);  //alokacia
    if(ret==NULL) return NULL;
    memset(ret,0,pc<<2);                                    //vynulovanie
    return ret;
}
#endif


/// funkcia na vycistenie dynamickej pamate modulu
void TBM_clean(void)
{
    TBM_free(t);    //vycisti strom
#ifdef topo
    free(pref);     //vycisti pocitadla najdenia prefixov
#endif
}


/// funkcia na nacitanie reprezentacie stromu z textoveho suboru
int TBM_load(char * config, size_t size)
{
    unsigned pom;
    if(!sscanf(config,"%u %u",&t_size,&pom)) return 1;     //subor zacina poctom uzlov a poctom prefixov
    nextWord(config); nextWord(config);
    t=TBM_init(t_size);  //inicializuje sa miesto pre strom
    if(t==NULL) return 1;
    for(register unsigned i=0; i<t_size; i++)
    {
        ///subor pokracuje uzlami
        // kazdy uzol == jeden riadok
        // vyznam cisel: [cislo prveho prefixu] [cislo prveho potomka] [IBM] [EBM]
        /// podla stride sa lisia datove sirky cisel => treba pouzit ine formatovacie znacky v scanfe
        if(sscanf(config,FORMAT_STRING,&(t[i].prefix_start),&(t[i].child_start),&(t[i].prefix_bmp),&(t[i].child_bmp))!=4)
        {
            TBM_clean();
            return 1;
        }
        for(int nw = 0; nw < 4; nw++)
            nextWord(config);
#ifdef topo
        t[i].count=0;  //nulujem pocitadlo
#endif
    }
/// inicializacia naviac pre topologiu => pocitadla prefixov
#ifdef topo
    pref_size=pom+1;                    //+1 lebo ako prefix s cislom 0 je brana situacia kedy sa nenajde zhoda
    pref=TBM_pref_init(pref_size);
    if(pref==NULL) {TBM_free(t); return 1;}
#endif
    return 0;
}


/// LPM vyhladavanie
//   x= ukazatel na strukturu s argumentami funkcie (vid main.h)
void *TBM_lookup(uint32_t * IPi)
//void *TBM_lookup(void * data, unsigned int size)
{
    //arg *in=(arg *)x;                               //pretypovanie ukazatela
//    uint32_t *IPi=data;                             //iterator do pola vstupnych IP
//    while(IPi<((uint32_t*)data) + size)                              ///cyklus cez cele pole vstupov
    {
        uint32_t IP=*IPi;                           //vyberiem IP odkazovanu iteratorom
        unsigned IP_piece;                          //sem sa bude vymaskovavat cast IP relevantna pre aktualne spracovavany TBM uzol
        int mask_plc=32-stride;                     //umiestnenie masky na maskovanie casti IP
        uint32_t next;                              //ID zvoleneho naslednika TBM uzlu
        uint32_t res=0;                             //ID vysledneho prefixu (LPM) POZN: 0 je ID pre nenajdenu zhodu
        uint32_t glob_prefix_start=0;               //uchovanie docasneho najlepsieho vysledku po ceste stromom
        uintxx_t glob_prefix_bmp=0;
        int glob_pos=-1;
        int res_pos;                                //pozicia prefixu vramci bitmapy

/// start algoritmu
        TBM_node *act=t;                            //aktualny prvok je na zaciatku vybrany root uzol celeho stromu
        do                                          /// cyklus kym som v strome (naslednik != NULL)
        {
#ifdef topo
            act->count++;   //pocitadlo navstevnosti uzla v pripade topo
#endif
            if(mask_plc<0)  //osetrenie pripadu kedy "stride" nedeli 32 a pozicia masky pretecie na zaporne cislo
                IP_piece=(IP<<(-mask_plc))&mask_ptr;  //POZN: posuvam IP a nie masku aby som mal cislo od 0 do (2^"stride")-1, ktore potrebujem
            else
                IP_piece=(IP>>mask_plc)&mask_ptr;

            ///LPM vramci binarneho podstromu reprezentovaneho v aktualnom uzle
            // kedze ide o LPM zacnem od spodneho poschodia v uzle (tam su najdlhsie prefixy)
            // a pri prvom najdenom prefixe (bit s hodnotou 1) koncim
            // pozicia zaujimaveho bitu vramci BMP na to urcenej je sucet dvoch:
            //     POZN: oznacme P cislo aktualneho poschodia v podstrome vramci TBM uzla,
            //           P pre root uzol je 0 a rastie smerom nadol
            //     +preskocenie bitov pre vyssie poschodia == 2^P-1
            //     +poradie bitu vramci poschodia == z vymaskovaneho kusu IP pouzijem od MSB P bitov
#if stride > 5
            ///POS =|P bitov z IP kusu|+|2^P-1|
            res_pos=(IP_piece>>(1+lvl))+31;
            if(!getbit(act->prefix_bmp,res_pos)) //P=5
            {
#endif
#if stride > 4
                res_pos=(IP_piece>>(2+lvl))+15;
                if(!getbit(act->prefix_bmp,res_pos)) //P=4
                {
#endif
#if stride > 3
                    res_pos=(IP_piece>>(3+lvl))+7;
                    if(!getbit(act->prefix_bmp,res_pos)) //P=3
                    {
#endif
                        res_pos=(IP_piece>>(4+lvl))+3;
                        if(!getbit(act->prefix_bmp,res_pos)) //P=2
                        {
                            res_pos=(IP_piece>>(5+lvl))+1;
                            if(!getbit(act->prefix_bmp,res_pos)) //P=1
                            {
                                if(act->prefix_bmp&1) res_pos=0;    //P=0
                                else res_pos=-1; //nic nenajdene!!
                            }
                        }
#if stride > 3
                    }
#endif
#if stride > 4
                }
#endif
#if stride > 5
            }
#endif

            ///vyhodnotenie ziskanej pozicie v BMP prefixov
            if(res_pos!=-1) //ak najdene => uloz si to ako doterajsi LPM
            {// POZN: kedze vypocet presneho ID prefixu je relativne casovo narocny,
             // zapamataju sa len potrebne hodnoty a vypocet sa prevedie az (len) pre celkovy LPM
                glob_prefix_start=act->prefix_start; //ID prveho prefixu v uzle
                glob_pos=res_pos;                    //pozicia bitu v BMP prefixov
                glob_prefix_bmp=act->prefix_bmp;     //BMP prefixov
            }


            ///zistenie naslednika na pokracovanie vyhladavanie v dalsom uzle TBM stromu
            if(getbit(act->child_bmp,IP_piece)) //existuje naslednik na mieste kade pokracuje IP
            {                                   //vypocet jeho ID
                next=act->child_start;
                for(register unsigned i=0; i<IP_piece; i++) //ide o algorimus na spocitanie '1' pred danym bitom v BMP
                    next+=getbit(act->child_bmp,i);
            }
            else next=0;                        // neexistuje naslednik => NULL

            act=t+next;                         //posun do naslednika
            mask_plc-=stride;                   //posun poziciem masky na IP adrese
        } while(next);

        /// tu uz mam globalny vysledok!!
        if(glob_pos!=-1) //az teraz pocitam ID tohoto prefixu
        {
            res=glob_prefix_start; //rovnako ako pre naslednika uzlu sa pouzije spocitanie '1'
            for(register int i=0; i<glob_pos; i++)
                res+=getbit(glob_prefix_bmp,i);
        }

#ifdef topo
        pref[res]++;    //pocitadlo najdenych prefixov
#endif
        *IPi=res;       //zapis vysledku hladania (prepisuje vstupnu IP)
/// koniec algoritmu

//        IPi++;          //posun na dalsiu IP
    }

    return NULL;
}
