#include <stdio.h>
#include <stdlib.h>

#include "SST.h"


/// globalna premenna na uchovanie SST stromu
static SST_tree t;
/// globalna premenna na uchovanie poctu uzlov stromu
static unsigned t_size;

///rezia naviac potrebna pre topologiu
#ifdef topo
static unsigned pref_size=0;            //pocet prefixov v celom strome
static uint32_t *pref=NULL;             //pole na pocitadla pre pocty najdeni jednotlivych prefixov
///vypis topologie
void SST_print_topo()
{
    long unsigned sumn=0,sump=0;
    for(register unsigned i=0; i<t_size; i++)
    {
        printf("N%u %u\n",i,t[i].count);        //postupne sa vypise pocet navstev kazdeho uzlo stromu
        sumn+=t[i].count;                       //zrata sa aj celkova navstevnost
    }
    for(register unsigned i=0; i<pref_size; i++)
    {
        printf("P%u %u\n",i,pref[i]);           //podobne ako pre uzly ale pre pefixy
        sump+=pref[i];
    }
    printf("NODE S: %lu\n",sumn);               //nakoniec este celkove sumy
    printf("PREF S: %lu\n",sump);
}
/// funkcia na inicializaciu pola pre pocitadla patriace prefixom
uint32_t *SST_pref_init(unsigned pc)
{
    uint32_t *ret=(uint32_t *)malloc(sizeof(uint32_t)*pc);  //alokacia
    if(ret==NULL) return NULL;
    memset(ret,0,pc<<2);                                    //vynulovanie
    return ret;
}
#endif


/// funkcia na vycistenie dynamickej pamate modulu
void SST_clean(void)
{
    SST_free(t);    //vycisti strom
#ifdef topo
    free(pref);     //vycisti pocitadla najdenia prefixov
#endif
}


/// funkcia na nacitanie reprezentacie stromu z textoveho suboru
int SST_load(char * config, size_t size)
{
    skipSpace(config);
    
    unsigned pom;
    if(!sscanf(config,"%u %u",&t_size,&pom)) return 1;     //subor zacina poctom uzlov a poctom prefixov
    nextWord(config); nextWord(config);

    t=SST_init(t_size); //inicializuje sa miesto pre strom
    if(t==NULL) return 1;
    for(register unsigned i=0; i<t_size; i++)
    {
        ///subor pokracuje uzlami
        // kazdy uzol == jeden riadok
        // vyznam cisel: [cislo prveho prefixu] [cislo prveho potomka] [SBM] [IBM] [EBM]
        /// podla K sa lisia datove sirky cisel => treba pouzit ine formatovacie znacky v scanfe
        if(sscanf(config, FORMAT_STRING, &(t[i].prefix_start),&(t[i].child_start),&(t[i].SBM),&(t[i].IBM),&(t[i].EBM))!=5)
        {
            SST_clean();
            return 1;
        }
        for(int nw = 0; nw < 5; nw++)
            nextWord(config);
#ifdef topo
        t[i].count=0; //nulujem pocitadlo
#endif
    }
/// inicializacia naviac pre topologiu => pocitadla prefixov
#ifdef topo
    pref_size=pom+1;                //+1 lebo ako prefix s cislom 0 je brana situacia kedy sa nenajde zhoda
    pref=SST_pref_init(pref_size);
    if(pref==NULL) {SST_free(t); return 1;}
#endif
    return 0;
}


/// LPM vyhladavanie
//   x= ukazatel na strukturu s argumentami funkcie (vid main.h)
//void *SST_lookup(void * data, unsigned int size)
void *SST_lookup(uint32_t * IPi)
{
    // arg *in=(arg *)x;                    //pretypovanie ukazatela
//    uint32_t *IPi=(uint32_t*)data;          //iterator do pola vstupnych IP
//    while(IPi < ((uint32_t*)data) + size)                ///cyklus cez cele pole vstupov
    {
        uint32_t IP=*IPi;                   //vyberiem IP odkazovanu iteratorom
        ///inicializacia prememnnych
        int ni=2,fi=0,pi=getbit(IP,31);     //pomocne premenne vypoctu algoritmu
        int old_fi=0, old_pi=0;             //na ulozenie starych hodnot premennych
        int x=0,y;                          //pomocne pocitadlo

/// start algoritmu
        SST_node *act=t;                    //aktualny prvok je na zaciatku vybrany root uzol celeho stromu
        uint32_t res=act->IBM&1;            //kvoli prefixu /0 (nenajdenie zhody ma ID 0 a prefix /0 ma ID vzdy 1)
        #ifdef topo
            act->count++;                   //pocitadlo navstevnosti uzla v pripade topo
        #endif
        for(register int i=30; i>=-1;i--)   /// cyklus kym mam co brat z IP adresy (po bitoch)
        {
            ///podla BMP tvaru a 1 bitu IP zisti kam sa pokracuje
            if(getbit(act->SBM,pi))  //pokracovanie je vramci aktualneho uzlu
            {
                for(register int j=old_pi; j<pi; j++)    //spocitam '1' v BMP tvaru po aktualnu poziciu podstromu vramci SS uzla
                    x+=getbit(act->SBM,j);               // => dostanem pocet uzlov v SS uzle, ktore su pred aktualnou poziciou
                if(getbit(act->IBM,x+1))                 //zistim ci je v zvolenom uzle prefix
                {
                    res=act->prefix_start;               //a zratam jeho ID (pocet jednotiek po ten uzol v internej BMP)
                    for(register int j=0; j<x; j++)
                        res+=getbit(act->IBM,j);
                }
                old_fi=fi;
                old_pi=pi;
                /// nove hodnoty pomocnych premennych
                fi+=ni;                                 //vzorec: f(i+1) = f(i)+n(i)
                ni=0;                                   //vzorec: n(i+1) = pocet_jednotiek_medzi(f(i-1),f(i))*2;
                for(register int j=old_fi; j<fi; j++)
                    ni+=getbit(act->SBM,j);
                ni<<=1; //*2 ale rychlejsie

                y=0;                                    //vzorec: p(i+1) = f(i+1)+ pocet_jednotiek_medzi(f(i),p(i+1))*2 + bit_IP(i+1)
                for(register int j=old_fi; j<pi; j++)
                    y+=getbit(act->SBM,j);
                pi=fi+(y<<1)+getbit(IP,i);
            }
            else                    //pokracovanie je v novom uzle
            {
                for(register int j=old_pi; j<pi; j++)   //spocitam '1' v BMP tvaru pred aktualnou poziciuo v podstrome vramci SS uzla
                    x+=getbit(act->SBM,j);              // => dostanem pocet uzlov v SS uzle, ktore su pred aktualnou poziciou
                x=pi-x;                                 //teraz ale potrebujem pocet 0 (pocet_0 = celkovy_pocet - pocet_1)
                if(getbit(act->EBM,x))                  //zistim ci odtialto vedie cesta do dalsieho SS uzla
                {
                    int next=act->child_start;          //a zratam jeho ID (pocet jednotiek po ten uzol v externej BMP)
                    for(register int j=0; j<x; j++)
                        next+=getbit(act->EBM,j);
                    act=t+next;                         //nastavim naslednika
#ifdef topo
                    act->count++;
#endif
                    ///urobim podobnu inicializaciu premennych ako na zaciatku
                    if(act->IBM&1) res=act->prefix_start;
                    ni=2;
                    fi=old_fi=old_pi=x=0;
                    pi=getbit(IP,i);
                }
                else break;         /// slepa cesta => algoritmus konci, doterajsi LPM je vysledkom
            }
        }
#ifdef topo
        pref[res]++;                //pocitadlo najdenych prefixov
#endif
        *IPi=res;       //zapis vysledku hladania (prepisuje vstupnu IP)
/// koniec algoritmu

//        IPi++;          //posun na dalsiu IP
    }
    return NULL;
}
