/// Lukas Kekely, xkekel00@stud.fit.vutbr.cz
/// BSP.h - hlavickovy subor modulu obsahujuceho

#ifndef MOD_BSP_H
#define MOD_BSP_H
#include <stdint.h>
#include <ctype.h>
#include "htable.h"

#define getbit(x,i) (((x)>>(i))&1)
#define skipSpace(cfg) { while(isspace(*cfg)) cfg++; }
#define nextWord(cfg)  { while(!isspace(*cfg)) cfg++; while(isspace(*cfg)) cfg++; }

/// struktura na ulozenie uzla
typedef struct {
    struct htable_t ht;
    unsigned char length;         //dlzka prefixov v tomto uzli
    unsigned char lchild;
    unsigned char rchild;
} BSP_node;

typedef struct {
    BSP_node *ptr;
    unsigned char start;
} BSP_tree;

///konstruktor a destruktor stromu
static void BSP_init(BSP_tree *t)
{
    t->ptr=(BSP_node *)malloc(sizeof(BSP_node)*(33));
    for(register unsigned i=0; i<33; i++) t->ptr[i].ht.p=NULL;
}
#define BSP_free(tree) {for(int i=0; i<33; i++) htable_free(&((tree).ptr[i].ht)); free(tree.ptr);}


///funkcie rozhrania modulu
void BSP_clean(void);        //vycistenie pamate celeho modulu
int BSP_load(char * config, size_t size);              //nacitanie reprezentacie stromu zo suboru
void *BSP_lookup(uint32_t *data);						//vyhladavanie v strome
//void *BSP_lookup(void * data, unsigned int size);     //vyhladavanie v strome

#endif
