#ifndef __JENKINS_H__
#define __JENKINS_H__

#include <stddef.h>
#include <stdint.h>

#define rot(x,k) (((x)<<(k)) | ((x)>>(32-(k))))

#define mix(a,b,c) \
{ \
  a -= c;  a ^= rot(c, 4);  c += b; \
  b -= a;  b ^= rot(a, 6);  a += c; \
  c -= b;  c ^= rot(b, 8);  b += a; \
  a -= c;  a ^= rot(c,16);  c += b; \
  b -= a;  b ^= rot(a,19);  a += c; \
  c -= b;  c ^= rot(b, 4);  b += a; \
}

#define final(a,b,c) \
{ \
  c ^= b; c -= rot(b,14); \
  a ^= c; a -= rot(c,11); \
  b ^= a; b -= rot(a,25); \
  c ^= b; c -= rot(b,16); \
  a ^= c; a -= rot(c,4);  \
  b ^= a; b -= rot(a,14); \
  c ^= b; c -= rot(b,24); \
}

/**
 * lookup3 version of Jenkins hash
 * @param key data to hash (size must be multiple of 32b)
 * @param key_length length of data to hash (in 32b words)
 */
uint32_t hash_jenkins(const uint32_t *key,
                      size_t key_length,
                      uint32_t seed);

#endif // __JENKINS_H__
