#include "jenkins.h"

uint32_t hash_jenkins(const uint32_t *key,
                      size_t key_length,
                      uint32_t seed) {

  uint32_t a,b,c;

  /* set up the internal state */
  a = b = c = 0x7bc21f90 + (((uint32_t)key_length)<<2) + seed;

  /* handle most of the key */
  while (key_length > 3)
  {
    a += key[0];
    b += key[1];
    c += key[2];
    mix(a,b,c);
    key_length -= 3;
    key += 3;
  }

  /* handle the last 3 uint32_t's */
  switch(key_length) /* all the case statements fall through */
  { 
  case 3 : c+=key[2];
  case 2 : b+=key[1];
  case 1 : a+=key[0];
    final(a,b,c);
  case 0: /* case 0: nothing left to add */
    break;
  }

  /* report the result */
  return c;

}
