#ifndef __CBF4_H__
#define __CBF4_H__

#include <stddef.h>
#include <stdbool.h>
#include <stdint.h>

/**
 * 4-bit Counting Bloom Filter
 * 4-bit counters should be sufficient for most applications
 * it supports adding and removing of elements and membership querying
 */
struct cbf4_t {
  /* number of hash functions */
  unsigned int hash_functions;
  /* seeds for hash functions */
  uint32_t *hash_seeds;
  /* number of elements in bit field */
  unsigned int field_elements;
  /* 4-bit counters */
  unsigned char *field;
};

/**
 * cbf4_init
 * @param hash_functions number of hash functions to use
 * @param hash_seeds seeds for particular hash functions
 * @param field_elements number of bits in array
 * @return false if memory allocation failed, true otherwise
 */
bool cbf4_init(struct cbf4_t *filter,
               unsigned int hash_functions,
               uint32_t *hash_seeds,
               unsigned int field_elements);

void cbf4_deinit(struct cbf4_t *filter);

/**
 * cbf4_add
 * adds the key of length key_length to the filter
 */
void cbf4_add(struct cbf4_t *filter,
              const uint32_t *key,
              size_t key_length);

/**
 * cbf4_remove
 * removes the key of length key_length to the filter
 */
void cbf4_remove(struct cbf4_t *filter,
                 const uint32_t *key,
                 size_t key_length);

/**
 * cbf4_query
 * queries if the filter contains the key
 * false positives are posible
 */
bool cbf4_query(struct cbf4_t *filter,
                const uint32_t *key,
                size_t key_length);

#endif // __CBF4_H__
