#include "jenkins.h"
#include "bloom.h"
#include <stddef.h>
#include <stdbool.h>
#include <stdlib.h>
#include <string.h>

bool bloom_filter_init(struct bloom_filter_t *filter,
                       unsigned int hash_functions,
                       uint32_t *hash_seeds,
                       unsigned int field_elements) {

  filter->hash_functions = hash_functions;
  filter->hash_seeds = hash_seeds;

  filter->field_elements = field_elements;
  /* allocate & clear bit field */
  filter->field = (unsigned char*) malloc((field_elements+7)/8);
  if (filter->field == NULL)
    return false;
  memset(filter->field, 0, field_elements/8);

  return true;

}

void bloom_filter_deinit(struct bloom_filter_t *filter) {

  // deallocate bit field
  free(filter->field);

}

/* inline */
void bloom_filter_add(struct bloom_filter_t *filter,
                      const uint32_t *key,
                      size_t key_length) {

  for (unsigned int i = 0; i < filter->hash_functions; i++) {
    // get the index to the bit field
    unsigned int index = hash_jenkins(key, key_length, filter->hash_seeds[i])
      % filter->field_elements;
    // set appropriate bit
    //filter->field[index/8] |= (1<<(index%8));
    filter->field[index>>3] |= (1<<(index&7));
  }

}

/* inline */
bool bloom_filter_query(struct bloom_filter_t *filter,
                        const uint32_t *key,
                        size_t key_length) {

  for (unsigned int i = 0; i < filter->hash_functions; i++) {
    // get the index to the bit field
    unsigned int index = hash_jenkins(key, key_length, filter->hash_seeds[i])
      % filter->field_elements;
    // if any of indexed bits is zero, the element is not in the filter
    //if (((filter->field[index/8]>>(index%8))&1) == 0)
    if (((filter->field[index>>3]>>(index&7))&1) == 0)
      return false;
  }

  return true;

}
