/**
 * Implementation for POSIX.
 */

#include <stdlib.h>
#include <stdio.h>
#include <sys/time.h>

#include "platform.h"

struct timeval start_time, end_time;

void timer_start() {
  gettimeofday(&start_time, NULL);
}

void timer_print() {
  gettimeofday(&end_time, NULL);

#ifndef PRINT_OUTPUT
  printf("% 12ld", (end_time.tv_sec-start_time.tv_sec)*1000000 + 
    (end_time.tv_usec-start_time.tv_usec));
#endif
}

int main(int argc, char **argv)
{
  return test_main(argc, argv);
}


#ifdef PRINT_OUTPUT
FILE * fout = 0;
void open_output()
{
//fout = fopen("OUTPUT_FN", "w");
  fout = stdout;
}
void close_output()
{
  fclose(fout);
}
void print_output(int out)
{
  fprintf(fout, "%i\n", out);
}
#else
inline void open_output() {}
inline void close_output() {}
inline void print_output(int out) {}
#endif

