-- ----------------------------------------------------------------------------
-- Entity for implementation of NFA_SPLIT
-- ----------------------------------------------------------------------------
library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_unsigned.all;
use IEEE.std_logic_arith.all;

-- ----------------------------------------------------------------------------
--                        Entity declaration
-- ----------------------------------------------------------------------------
entity NFA_SPLIT is
   generic(
      DATA_WIDTH   : integer := %$%;
      RULES        : integer := %$%;
      INPUT_WIDTH  : integer := %$%;
      OUTPUT_WIDTH : integer := %$%
   );
   port(
      CLK            : in std_logic;
      RESET          : in std_logic;

      -- input data interface
      DATA           :  in std_logic_vector(DATA_WIDTH - 1 downto 0);
      SOF            :  in std_logic;
      EOF            :  in std_logic;
      SRC_RDY        :  in std_logic;
      DST_RDY        : out std_logic;
      
      -- output data interface
      BITMAP         : out std_logic_vector(RULES - 1 downto 0);
      VLD            : out std_logic;
      ACK            :  in std_logic
   );

end entity NFA_SPLIT;

-- ----------------------------------------------------------------------------
--                     Architecture: full
-- ----------------------------------------------------------------------------
architecture full of NFA_SPLIT is
    signal sinput:  std_logic_vector(INPUT_WIDTH - 1 downto 0);
    signal soutput: std_logic_vector(OUTPUT_WIDTH - 1 downto 0);
    signal src:     std_logic;
    signal dst:     std_logic;
    signal dst_nd:  std_logic;
    signal dst_d:   std_logic;
begin

    dst <= dst_nd and dst_d;
    DST_RDY <= dst;
    
    src <= SRC_RDY and dst; 
       
    nfa_i: entity work.NFA_PART
    port map(
        CLK     => CLK,
        RESET   => RESET,
        DATA    => DATA,
        SOF     => SOF,
        EOF     => EOF,
        SRC_RDY => src,
        DST_RDY => dst_nd,
        INPUT   => sinput,
        OUTPUT  => soutput,
        BITMAP  => BITMAP,
        VLD     => VLD,
        ACK     => ACK
    );
    
    dfa_i_0: entity work.DFSM_LOGIC0
    port map(
        CLK     => CLK,
        RESET   => RESET,
        DATA    => DATA,
        SOF     => SOF,
        EOF     => EOF,
        SRC_RDY => src,
        DST_RDY => dst_d,
        INPUT   => soutput,
        OUTPUT  => sinput,
        BITMAP  => open,
        VLD     => open,
        ACK     => ACK
    );
end architecture full;
