-- ----------------------------------------------------------------------------
-- Entity for implementation of Clark NFA
-- ----------------------------------------------------------------------------
library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_unsigned.all;
use IEEE.std_logic_arith.all;

-- ----------------------------------------------------------------------------
--                        Entity declaration
-- ----------------------------------------------------------------------------
entity CLARK_NFA is
   generic(
      DATA_WIDTH : integer := %$%;
      RULES      : integer := %$%
   );
   port(
      CLK            : in std_logic;
      RESET          : in std_logic;

      -- input data interface
      DATA           :  in std_logic_vector(DATA_WIDTH - 1 downto 0);
      SOF            :  in std_logic;
      EOF            :  in std_logic;
      SRC_RDY        :  in std_logic;
      DST_RDY        : out std_logic;

      -- output data interface
      BITMAP         : out std_logic_vector(RULES - 1 downto 0);
      VLD            : out std_logic;
      ACK            :  in std_logic
   );

end entity CLARK_NFA;

-- ----------------------------------------------------------------------------
--                     Architecture: full
-- ----------------------------------------------------------------------------
architecture full of CLARK_NFA is
    signal local_reset : std_logic;
    signal we : std_logic;
    signal rdy : std_logic;
    signal vld_internal : std_logic;
    signal set : std_logic;
%$%
begin
    local_reset <= RESET or ACK;
    we <= SRC_RDY and rdy;
    DST_RDY <= rdy;
    VLD <= vld_internal;
    set <= SRC_RDY and EOF and rdy;
    rdy <= not vld_internal;
    
    end_reg: process(CLK)
    begin
        if (CLK'event and CLK = '1') then
            if (local_reset = '1') then
                vld_internal <= '0';
            else
                if set = '1' then
                    vld_internal <= '1';
                end if;
            end if;
        end if;
    end process end_reg;
    
%$%
    final_bitmap_u: entity work.FINAL_BITMAP
    generic map(
      DATA_WIDTH => RULES
    )
    port map(
        CLK            => CLK,
        RESET          => local_reset,

        -- input data interface
        SET            => bitmap_in,

        -- output data interface
        BITMAP         => BITMAP
    );
end architecture full;
