###############################################################################
#  sym_char_class_dfa.py: Module for PATTERN MATCH - dfa char class class
#  Copyright (C) 2010 Brno University of Technology, ANT @ FIT
#  Author(s): Vlastimil Kosar <ikosar@fit.vutbr.cz>
###############################################################################
#
#  LICENSE TERMS
#
#  Redistribution and use in source and binary forms, with or without
#  modification, are permitted provided that the following conditions
#  are met:
#  1. Redistributions of source code must retain the above copyright
#     notice, this list of conditions and the following disclaimer.
#  2. Redistributions in binary form must reproduce the above copyright
#     notice, this list of conditions and the following disclaimer in
#     the documentation and/or other materials provided with the
#     distribution.
#  3. All advertising materials mentioning features or use of this software
#     or firmware must display the following acknowledgement:
#
#       This product includes software developed by the University of
#       Technology, Faculty of Information Technology, Brno and its
#       contributors.
#
#  4. Neither the name of the Company nor the names of its contributors
#     may be used to endorse or promote products derived from this
#     software without specific prior written permission.
#
#  This software or firmware is provided ``as is'', and any express or implied
#  warranties, including, but not limited to, the implied warranties of
#  merchantability and fitness for a particular purpose are disclaimed.
#  In no event shall the company or contributors be liable for any
#  direct, indirect, incidental, special, exemplary, or consequential
#  damages (including, but not limited to, procurement of substitute
#  goods or services; loss of use, data, or profits; or business
#  interruption) however caused and on any theory of liability, whether
#  in contract, strict liability, or tort (including negligence or
#  otherwise) arising in any way out of the use of this software, even
#  if advised of the possibility of such damage.
#
#  $Id$

import b_symbol
import sym_char

class b_Sym_char_class_dfa (sym_char.b_Sym_char):
    """A base class to represent a DFA char class symbol. To be used by char pre-decoder."""
    def __init__(self, new_text, char, charClass, new_id=0):
        sym_char.b_Sym_char.__init__(self, new_text, char, new_id)        
        self.charClass = charClass
        
    def accept(self, text):
        """ If symbol is at the beginning of the text, is removed from the text and reminder is returned. Otherwise accept_exception is raised. """
        found = False
        output = str()
        for char in self.charClass:
            if char == "":
                found = True
                output = text
            if text[0] == char[0]:
                found = True
                output = text[1:]
            
        if found == True:
            return output
        else:
            raise b_symbol.accept_exception()

    def collision(self, set_of_symbols):
        """Return True if two or more symbols from set_of_symbols can be accepted for the same text."""
        for sym in set_of_symbols:
            for char in self.charClass:
                try:
                    sym.accept(char)
                except:
                    pass
                else:
                    return True
        return False
            
    def __str__(self):
        return str(self.charClass)
    
    def __eq__(self, other):
        if isinstance(other, b_Sym_char_class_dfa):
            if self.charClass.issubset(other.charClass) and self.charClass.issuperset(other.charClass):
                return True
            else:
                return False
        else:
            return False
    
    def __ne__(self, other):
        if isinstance(other, b_Sym_char_class_dfa):
            if self.charClass.issubset(other.charClass) and self.charClass.issuperset(other.charClass):
                return False
            else:
                return True
        else:
            return True

    def __hash__(self):
        return hash(frozenset(self.charClass))
    
    def __repr__(self):
        return repr(self.charClass)
        
###############################################################################
# End of File sym_char_class_dfa.py                                           #
###############################################################################