#ifndef SYMBOLTABLE
#define SYMBOLTABLE
#include <string>
#include <iostream>

using namespace std;

#define DATATYP long long

class tSymTable{
   private:
      char* Data;
      unsigned int* Sizes;
      int NumSym;
      int FreePos;
      int NumChar;
      bool Is(int Pos,int PosSym,int Char);
      int Index(int Pos,int PosSym, int Char);
      void Ordering(int* Output);
      void ColTest(bool* Ekvivalence, bool* Colisions, char* TempSym, int i, int j);
   public:
      void PrintSym1(int Pos,ostream &fout);
      tSymTable(int NumSym1, int NumChar1);
      ~tSymTable();
      void Determinize(vector<set<int> > & ChangeT);
      void CreateExtendSymbol(int* Positions, tSymTable & Source);
      char* Symbol(int Pos);
      void AddChar(int PosSym, int PosChar, unsigned char Input);
      void AddSet(int PosSym,int posChar, char* Set);
      int AddClearSym(int Input);
      int SizeSym(int Pos);
      int AddSym(char* Symbol, int Size);
      int AddDNC();
      int size();
};

inline void tSymTable::Ordering(int* Output){
   int i,j;
   unsigned int Max,MaxPos;
   unsigned int* MyThink = (unsigned int*) malloc(sizeof(unsigned int)* FreePos);
   memcpy(MyThink,Sizes,sizeof(int)*FreePos);
   for(i=0;i<FreePos;i++){
      Max = 0;
      MaxPos = 0;
      for(j=0;j<FreePos;j++)
         if(MyThink[j] > Max){
            Max = MyThink[j];
            MaxPos = j;
      }
      Output[i] = MaxPos;
      MyThink[MaxPos] = 0;
   }
   free(MyThink);
}  

inline void tSymTable::ColTest(bool* Ekvivalence, bool* Colisions, char* TempSym, int i, int j){
   long long* First = (long long*) (Data+(i*NumChar*32));
   long long* Second = (long long*) (Data+(j*NumChar*32));
   long long* Output = (long long*) TempSym;
   *Ekvivalence = true;
   unsigned int k;
   for(k=0;k<((32*NumChar)/sizeof(long long));k++){
      if(First[k] != Second[k]) *Ekvivalence = false;
      Output[k] = First[k]&&Second[k];
   }
   if(!(*Ekvivalence)){
      *Colisions = true;
      int m=0;
      for(k=0;k<(unsigned int)NumChar;k++){
         bool ParcialColisions = false;
         unsigned int l=0;
         for(l=0;l<(32/sizeof(long long));l++)
            if((unsigned long long)Output[m++]>0) ParcialColisions = true;
         if(!ParcialColisions) *Colisions = false;
      }
   }
}

inline void tSymTable::Determinize(vector<set<int> > & ChangeT){
   int StackSize = 100;
   char* DataRes = (char*) malloc(32*NumSym*NumChar);
   int* FifoStart = (int*) malloc(sizeof(int)*NumChar);
   char* TempSym = (char*) malloc(32*NumChar*StackSize);
   int Start = 0;
   int Konec = 0;
   int OutSym = 0;
   int Fullnes = 0;
   //Ordering actual Symboltable by the size
   int* Order = (int*) malloc(sizeof(int)*FreePos);
   Ordering(Order);
   int i=0;
   for(i=0;i<FreePos;i++){
      int j=0;
      bool Col = false;
      bool Ekv = false;
      for(j=0;j<Fullnes;j++){
         //Test for colisions and ekvivalence
         ColTest(&Ekv,&Col,TempSym,i,j);
         if(Ekv||Col) break;
      }
      if(Ekv) {
         //Just change Output vector
      }
      else{
         if(Col){
            //Create all new symbols and then enterred them into new table, recursion or stack needed
         }
         else{
            //Just copy symbol into first free position in output table
         }
      }
    
   }
   free(Data);
   free(FifoStart);
   Data = DataRes;
}

inline int tSymTable::size(){
   return FreePos;
}

inline int tSymTable::AddDNC(){
   unsigned char Tmp = 255;
   for(unsigned int i=0;i<(32*NumChar/sizeof(char));i++)
      Data[FreePos*32*NumChar+i] = Tmp;
   
   Sizes[FreePos] = 256;
   FreePos++;
   return FreePos-1;
}

inline int tSymTable::AddSym(char* Symbol, int Size){
   unsigned int i;
   //cout<<"DAT SIZE"<<sizeof(DATATYP)<<":"<<((32*NumChar)/sizeof(DATATYP))<<endl;
   DATATYP * Point = (DATATYP*) Symbol;
   for(i=0;i<FreePos;i++)
      if(Sizes[i] == Size) { //Possible match
         unsigned int j;
         DATATYP * Data2 = (DATATYP*) (Data+i*32*NumChar);
         bool Ekv = true;
         for(j=0;j<((32*NumChar)/sizeof(DATATYP));j++)
            if(Data2[j] != Point[j]) Ekv = false;
         if(Ekv) return i;
      }
   this->AddClearSym(FreePos);
   memcpy(Data+(FreePos*32*NumChar),Symbol,32*NumChar);
   Sizes[FreePos] = Size;
   FreePos++;
   return FreePos-1;
}

inline int tSymTable::Index(int Pos,int PosSym, int Char){
   return Pos*32*NumChar+PosSym*32+(Char/8);
}

inline bool tSymTable::Is(int Pos,int PosSym, int Char){
   unsigned char Tmp = (1 << (Char%8));
   unsigned char Tmp1 = Data[Index(Pos,PosSym,Char)];
//   if(PosSym==0&&Char == 255)cout<<Index(Pos,PosSym,Char)<<endl;
   Tmp1 &= Tmp;
   return Tmp1 > 0;
}

inline int tSymTable::SizeSym(int Pos){
   return Sizes[Pos];
}

inline int tSymTable::AddClearSym(int Input){
   if(Input>=NumSym) return -1;
   DATATYP * Hlp = (DATATYP*) (Data+(Input*32*NumChar));
   for(unsigned int i=0;i<(NumChar*32/sizeof(DATATYP));i++){
      Hlp[i] = 0;
   }
   return Input;
}

inline void tSymTable::AddChar(int PosSym, int PosChar, unsigned char Input){
   char Tmp = 1 << (Input % 8);
   Data[Index(PosSym,PosChar,(int)Input)] |= Tmp; 
   Sizes[PosSym]++;
}

inline void tSymTable::AddSet(int PosSym, int PosChar, char* Input){
   DATATYP * Point = (DATATYP*) Input;
   DATATYP *Change = (DATATYP*) (Data+PosSym*NumChar*32+32*PosChar);
   for(unsigned int i=0;i<(32 / sizeof(DATATYP));i++)
      Change[i] |= Point[i];
}

inline char* tSymTable:: Symbol(int Pos){
   return Data+(Pos*(32*NumChar));
}

inline tSymTable::tSymTable(int NumSym1, int NumChar1){
   Data = (char*) malloc(NumChar1*NumSym1*32);
   if(Data == NULL) cout<<"FAILED"<<endl;
   NumSym = NumSym1;
   NumChar = NumChar1;
   FreePos =0;
   Sizes = new unsigned int [NumSym];
   int i=0;
   for(i=0;i<NumSym1;i++)
      Sizes[i] = 0;
}

inline tSymTable::~tSymTable(){
   delete[] Sizes;
   free(Data);
}

inline void tSymTable::CreateExtendSymbol(int* Positions, tSymTable &Source){
   int i;
   for(i=0;i<NumChar;i++){
      memcpy(Data+(FreePos*32*NumChar+i*32),Source.Symbol(Positions[i]),32); 
      Sizes[FreePos] += SizeSym(Positions[i]);
   }
   FreePos++;
}

inline void tSymTable::PrintSym1(int Pos,ostream &fout){
   int Char;
   int PosSym;
   for(PosSym=0;PosSym<NumChar;PosSym++){
      for(Char=0;Char<256;Char++){
          if(Is(Pos,PosSym,Char)) {
             fout <<(int) Char<<",";
          }
   }
   fout<<"|||";
   }
}



#endif
