/**
 * \file pcre2hw.hpp
 * \brief Function to transform pcre into VHDL code and file specifications
 * \author Andrej Hank <xhanka00@liberouter.org> 
 * \date 2007
 * 
 * Copyright (C) 2007 CESNET
 * 
 * $Id: pcre2hw.hpp,v 1.2 2007/04/29 14:10:48 xhanka00 Exp $
 */

#ifndef __PCRE2HW_HPP__
#define __PCRE2HW_HPP__

#include "pcre2nfa.hpp"
#include <iostream>
#include <fstream>
#include <map>
#include <list>

//! path to template architecture file
#define  ARCHITECTURE_BEGIN_FILE    "./vhdl_templates/nfa_begin.vhd" 
//! path to signals tmp file
#define  TMP_SIGNALS_FILE           "./tmp/signals.tmp"
//! path to architecture tmp file
#define  TMP_ARCHITECTURE_FILE      "./tmp/architecture.tmp"

using namespace std;

// generate VHDL representation from pcre NFA 
void nfa2hw(tAutomata *nfa, int noOfRules, char *filename, char *pack_filename);


#endif
