#ifndef NFA2DFA
#define NFA2DFA
#include "pcre2nfa.hpp"
#include <vector>
#include <map>
#include <string>
#include <set>
#include <stack>
#include <sstream>
#include <bitset>
#include <time.h>
#include <cmath>
#include <stdlib.h>
#include <iostream>
#include <algorithm>
#include <limits.h>
//#include "symbols.h"
#include <unistd.h>
void TranslateSymbol(tSymbolTable* Vstup, int Index, set<char>* ActSet);
class Interval{
   public:
      unsigned char Start;
      unsigned char Konec;
    /*  inline bool operator<(Interval Int2){
         return Start<=Int2.Start&&Konec>=Int2.Konec;
      }*/
      inline bool operator==(Interval Int2){
         return (Start ==Int2.Start)&&(Konec==Int2.Konec);
      }
      inline bool operator!=(Interval Int2){
         return Start != Int2.Start||Konec != Int2.Konec;
      }
      /**
       * Return Interval contains intersection of actual and input interval. Both others interval are change to not contain intersection
       */ 
      inline Interval Intersect(Interval& Int2){
         Interval Res;
         Res.Start = (Start>Int2.Start)?(Start):(Int2.Start);
         Res.Konec = (Konec<Int2.Konec)?(Konec):(Int2.Konec);
         Start = (Start<Res.Start)?(Start):(Res.Konec);
         Konec = (Konec>Res.Start)?(Res.Start):(Konec);
         Int2.Start = (Int2.Start<Res.Start)?(Int2.Start):(Res.Konec);
         Int2.Konec = (Int2.Konec>Res.Start)?(Res.Start):(Int2.Konec);
         return Res;
      }
      inline bool Cross(Interval Int1){
         return (Start<Int1.Start && Konec>Int1.Start && Konec < Int1.Konec) || (Start<Int1.Konec && Konec>Int1.Konec && Start> Int1.Start);
      }
};

inline ostream& operator<<(ostream &os, Interval &Int){
         return (os<<Int.Start<<"-"<<Int.Konec);
      }

inline bool operator<(Interval Int1, Interval Int2) {
   return Int1.Start<=Int2.Start&&Int1.Konec>=Int2.Konec;

}
typedef vector<vector<Interval> > tSymbolInterval;

typedef struct tree{
   Interval Int;
   set<int> Name;
   tree* Father;
   vector<tree*> Childrens;
} tree;

inline tree* CreateTree(){
   tree* Result = new tree;
   Result->Father = NULL;
   Result->Int.Start = 0;
   Result->Int.Konec = 255;
   return Result;
}
void AddTree(tree* Father, Interval& Int, set<int>& Name);
void AddWholeTree(tree* From, tree* To);
void DestroyTree(tree* Father);
bool tree2ps(string psfile,vector<set<int> >* Vstup);

const int BIT_MAX = 64;
/*Constant for fast searching in symbols by chars. Max is 4*/
const unsigned int TREEMAX = 4;
/*
typedef struct{
   int Col;
   set<int> Intersect;
} tColsis;

typedef deque<tColsis*> tColisions;
*/

/**
 * Symbols are stored in vector. Each symbol is in vector only once therefor index to this vector is unique identificator, which is used in all algorithms
 */
typedef vector<vector<set<char> > > tSymbolTable2;   //For beter performance in MultiChar change second vector to list or something

/**
 * This is intern data structure for creating symbolTable
 */
typedef map<int,map<int,map<int,map<int,int> > > > tTree;

typedef set<int> tMoves;
typedef map<int,tMoves> tLine;
typedef vector<tLine> tTransitions;

typedef map<int,int> tDLine;
typedef vector<tDLine> tDTransitions;

typedef struct tTableNFA {
   int StateCount;
   bool Interval;
   tTransitions Transitions;
   map<int, vector<int> > endStates;
   tSymbolTable2* symbolTable;
   tSymbolInterval* symbolTable2;
   //tSymTable* symbolTable3;
} tTableNFA;

typedef struct tTableDFA {
   int StateCount;
   long int TransCount;
   int SymTableSize;
   tDTransitions Transitions;
   map<int, vector<int> > endStates;
   tSymbolTable2* symbolTable;
} tTableDFA;

/**
 * \brief This function return vector of alphabets. Each state has its own "alphabet"
 * \parameter Input is inuting DFA with nondeterministic alphabet
 */

vector<set<int> > ret_state_alphabets(tTableDFA* Input);
void Characteristics(vector<tAutomata>* Vstup);

/**
 * Count number of transitions in tableNFA
 */
long int CountTrans(tTableNFA* Input);
/**
 * Creates extendedNFA from Table representation of normal NFA. Numchar is number of char which is akcepted by one symbol
 * DON'T CARE character is represented by empty set of char. This should be changed to set of all char, but it depeds where is determinization of symbol done.
 */
tTableNFA* MultiChar(tTableNFA* Vstup, int CharNum, int *Deb);
/**
 * This function creates PDF file containing graph defined in VStup. each record in vector means one point in graph and each set contains names of point to which is actual point conected.
 */
bool Graph2ps(string psfile,vector<set<int> >* Vstup);
/**
 * Add Vstup2 to Vstup1 in the meaning OR. - New automat accept all string which was accepted by Vstup1 or Vstup2
 */ 
void Together(tAutomata* Vstup1,tAutomata* Vstup2, tAutomata* Output);

/**
 * Transform input NFA in representation of tAutomata to his table representation defined like tTableNFA
 */
tTableNFA* nfa2tableNFA(tAutomata* Vstup);
/**
 * Creates DOT file which contains graph of NFA. FileScript contains stream to which is writed command to transform this dot to gif
 */
bool tableNFA2ps(string regex, tTableNFA *Vstup, string psfile, ofstream* FileScript);
/**
 * Creates DOT file which contains graph of DFA. FileScript contains stream to which is writed commands to transform this dot to pdf
 */
bool tableDFA2ps(string regex, tTableDFA *Vstup, string psfile, ofstream* FileScript);

/**
 * Creates new NFA, which do not contains eps moves. Eps moves are represended as symbol with nuber -1
 */
tTableNFA* efreeNFA(tTableNFA* Vstup);
/**
 * Transforms Eps-free automata to deterministic automata
 */
tTableDFA* efreeNFA2TableDFA(tTableNFA* Vstup);

/**
 * Returned automata is minimal DFA form of input. Input has to be eps free automata without inacessible states
 */
tTableDFA* MinDFA(tTableDFA* Vstup);

//tTableNFA* TwoNFA2One(tTableNFA* Vstup1, tTableNFA* Vstup2);

/**
 * First parameter is input, contains DFA. Second parameter (Ouput) Contains the same automaton without states, which cannot leads to end states.
 * Output must point to alocated memory space. Used internaly in
 */
void DeleteNonEndingStates(tTableDFA* Vstup,tTableDFA* Output);
/**
 * Translate symbol table used in tAutomata to symboltable2 used in table represenation. Difference is that symbolTable in tAutomata has class, but symbolTable2 has only set of char;
 */
void TranslateSymbols(tSymbolTable2* Output,tSymbolTable* Vstup,map<int,int>* Change);
//void TranslateSymbolsF(tSymTable* Output,tSymbolTable* Vstup,map<int,int>* Change);
/**
 * Print set of char, which is one part of symbol in extended NFA
 */
void printSymbol2(ostream &fout, set<char>* with, bool epsMove, bool dot);
/**
 * Compute eclosure for State. Used in efreeNFA
 */
set<int>* eclosure(tTableNFA* Vstup,int State);
/**
 * Make sure, that intersection of all symbols are empty sets. index in output map is number of old symbol and set contains all new symbol, which contains char, which were deleted from index
 */
bool SeparateSymbols2(tSymbolTable2* Table, map<int,set<int> >* Output);
/**
 * Make sure, that intersection of all symbol is empty set, but works only for NfA, not for extended
 */
void SeparateSymbols(tSymbolTable2* Table, map<int,set<int> >* Output);
/**
 * Calls SeparateSymbols and aplicate changes to transitions dictated by Output of Separate symbols. Work only before extending to multichar NFA
 */
void DeterSymbols(tTableNFA* Input);
/**
 * Print all symbols to file specified by name in parameter Out 
 */
void printSymbolTable2(tSymbolTable2* Vstup,string Out);
//void printSymbolTable3(tSymTable* Vstup,string Out);

/**
 * Main function of this module. Make groups of automata. Each set contains numbr of rules for one group
 */
vector<set<int> >* Groups(vector<tAutomata>* Vstup, int Limit, int CharNum);

/**
 * Used in grouping. Return number of rule, which has minimum conection with others rules. Selected rules cannot be in alredyUsed set
 */
int FindMin(float* Input1,int rules,set<int>* alreadyUsed);
/**
 * Used in groupint. Return number of rule, which has minimal conection with rules contained in Input2 sets. Rule cannot be in alredyUsed set. 
 */
int FindMin(float* Input1,int rules,set<int>* Input2, set<int>* alreadyUsed);
/**
 * Find number of symbol which is given as second parameter. First parameter is symbolTable. Takes linear time. If symbol does not exist in symbolTable, this function return -1
 */
int Find(vector<vector<int> >* Input, vector<int >* InputChar);
/**
 * Find number of symbol which is given as third parameter. First parameter is symboltable for searching. If symbol does not exist, function will insert it into symbol table and return his new position. Second parameter is tree structure which is used for faster searching and which contains also symbol Table
 */
int FindInsert(vector<vector<int> >* Transitions,tTree* Input, vector<int>* InputChar);

/**
 * Returns reverse transition table. Used internaly in multichar function for faster creating ending transitions
 */
tTransitions* ReverseTransitions(tTransitions* InputTran);

/**
 * Generates starting transitions in multichar automata. Function is called recursively from multichar
 */
void GenStarts(tTableNFA* Vstup, tTableNFA* Output,int NumChar,int k, int ActState, vector<int> TempChar, vector<vector<int> >* Transitions/*, tTree* Tree*/);
/**
 * Generates multichar transitions. This function is recursively calls from MultiChar. dpth of recursion is defined by number of char in one transitions
 */
void GenNorm(tTableNFA* Vstup, tTableNFA* Output, int NumChar,int k, int SrcState,int ActState, vector<int> TempChar, vector<vector<int> >* Transitions/*, tTree* Tree*/);
/**
 * Generates multichar transitions which leads to end states. Function is recursively calls from Multichar
 */
void GenEnd(tTableNFA* Vstup, tTableNFA* Output, tTransitions* Reverse,int NumChar, int k, int EndState, int AktState, vector<int> TempChar, vector<vector<int> >* Transitions/*, tTree* Tree*/);

/**
 * Write automata to file in .fsm format, which is used by fsm library
 */
void TableNFA2FSMfile(tTableNFA* NFA, string file);

/**
 * This functions compute CRC 
 */
long int computeCRC(unsigned int From,unsigned int Symbol, int stateBits, int transBits, int polyBits, int poly);
/**
 * Compute CRC for all transitions and count all colisions
 */
map<long int,int>* ColisionTable(tTableDFA * Vstup, int StateBits, int TransBits, int PolyBits, int Polynom);
/**
 * Creates inverse transitions for deterministci automata. Is called from minimization of DFA
 */
tTransitions* ReverseDeterministicTransitions(tDTransitions* InputTran);

/**
 * Return true if two input vector are identical. Both vector must have same size
 */
inline bool EqualSymbols(vector<set<char> >* Vstup1, vector<set<char> >* Vstup2);
/**
 * Return true if two input symbols (defined by their number) is in colisions in all char. Parametr data contains colision table
 */
inline bool IsColisions(vector<map<int,set<int> > >* Data, int Vstup1, int Vstup2);
/**
 * Insert colision of two input symbols (Vstup1, Vstup2) into colision table. Parameter k show in which char of multichar symbol is colision located
 */
inline void InsertColision(vector<map<int,set<int> > >* Data, int Vstup1, int Vstup2,int k);
/**
 * Compute intersection of two input Symbols (tup1,Vstup2) and return it throught parameter Output, which must have enought size
 */
inline bool InterSymbol(vector<set<char> >* Vstup1,vector<set<char> >* Vstup2, vector<set<char> >* Output);
/**
 * Return number of symbol in Symboltable Table. Parameter Hint contains posible number of symbol. If symbol do not have number in Hint, new record in symboltable is created and his number is returned
 */
inline int SymbolNumber(tSymbolTable2* Table,set<int>* Hint,vector<set<char> >* Symbol);

/**
 * Insert symbol into symbolTable. Do not use hint,therefore search through all Symbol table, which means goes throught all sets in all lines (long)
 */
inline int SymbolNumber(tSymbolTable2* Table,vector<set<char> >* Symbol);
/**
 * Change parametr output to contains information that transitions on symbol New must be added to each transitions on symbol Old1 
 */
inline void MakeChange(int Old1, int New, map<int,set<int> >* Output, int limit);
/**
 * Recompute vector colisions which contains number of colidating symbols in each part of multichar symbol for each char (if automat accpets 2 char in oe transitions, colisions will contains 2 vector of sets and each of these vectors will contain 256 set - one per character)
 */
inline void ReColisions(vector<vector<set<int> > >* Colisions,tSymbolTable2* Table, int Old1, int Old2, int New);
/**
 * Insert colicion into colision table, but in diference to  InsertColision. This insert twocolisions (Vstup1xVstup2 AND Vstup2xVstup1)
 */
inline void InsertColTable(vector<map<int,set<int> > >* Data, int Vstup1, int Vstup2, int k);
/**
 * This function recomputes Colision table (ColPos) from vector of colisions(Colisions). Colisio table have fast ansver to information if two symbols are in colisions. Therefor there is not need to compute intersection of all symbols
 */
inline void RecomputeColisionTable(tSymbolTable2* Table,vector<map<int,set<int> > >* ColPos,vector<vector<set<int> > >* Colisions, int Old1, int New);
/**
 * CalisAll is structure contains information about colisions which can not be solved by reading another char in mutlichar symbol. only these colisions has to be deleted from Symboltable
 */
inline bool RecomputeColisAll(vector<map<int,set<int> > >* ColisAll, int Vstup1, int Vstup2, int New, vector<map<int,set<int> > >* ColPos,int k);
/**
 * make sure, that no pair of symbol in symbol Table of inputing automata has nonzero intersection. If this pair exist, new symbol is created and new transitions is also created
 */
void DeterLongSymbols(tTableDFA* Input);
/**
 * This function separates symbols. It could be called from DeterLongSymbols. This functions compute intersection of all pair of symbols in symbol table and if colision is detected, than creates new symbol into symbol table. Parameter output contains information which symbols were separated to which groups of symbol. 
 */
void Separatesymbols3(tSymbolTable2* Vstup, map<int,set<int> >* Output);

/**
 * Distribute is called from minDFA to divide one group of state to several other by condition that all states from output set have same targets for each symbol. DistSet is set to distribute, Vstup is actual DFA, mapGroup is vector translating state to its set and Output is vector of all sets, which were created. output may not be empty 
 */
inline void Distribute(set<int>* DistSet, tTableDFA* Vstup, int* mapGroup,vector<set<int> >* Output);

/**
 * Compute which symbols colide on each char. 
 */
inline void ColisionsMake(tSymbolTable2* Vstup, vector<vector<set<int> > >* Output);


/**
 * takes colisions vector and make table to tell for each symbol set of other symbols which colided with it. If symbol has some colision, it will colide also with itself, but if it has not coliding, than it will not be in Output. Output format is one map for each part of multichar symbol. This map contains for each symbol set of symbols in colision 
 */
inline void ColTableMake(vector<vector<set<int> > >* Vstup, vector<map<int,set<int> > >* Output, int NumChar);

/**
 * Compute number of colisions which is in all parts of multichar and return number of these colisions for all parts. Number of colisions should be the same for all parts, because each colision is computed max one time. It also returns map of this colision. This map contains set for each symbol which contains other symbols which are in colision, but one colision is returne only one (if 1,2 is in colision than 2,1 will not be returned as colision)
 */

inline void ColisionCounts(vector<map<int,set<int> > >* Vstup, map<int,set<int> > * OutputCol, vector<vector<set<int> > > *Colisions, int* OutputNum);

/**
 * Separates multichar symbols that no pair has same parts
 */
bool SeparateSymbols4(tSymbolTable2* Table, map<int,set<int> >* Output);
void TableDFA2FSMfile(tTableDFA* DFA, string file);
tTableDFA* DeterLong(tTableDFA* Input);
void CountUnnecesaryTransitions(tTableDFA* Vstup);
void CountUnnecesaryTransitions(tTableNFA* Vstup);
void Analyze(tSymbolTable2* Vstup,string Output);
void ComputePriority(tTableNFA* Input,int Num);
void CreateCharastristics(vector<tAutomata>* Vstup);
int CompObalka(tSymbolTable2* Input);
int CompObalka(tSymbolInterval* Input);
void Translate(tDTransitions & Input, tDTransitions & Output);
long int Rename(tTableDFA& Input,int GroupIt,int Poly, int Bit);
void CRCColOut(tTableDFA& Input, float* fulness, unsigned long* Colisions);
long CountSym(tSymbolTable2* Input);

inline int BitNum(int Num) {
   if(Num == 1) return 1;
   return (int)((log2(Num)  == floor(log2(Num)))?(log2(Num)):(floor((log2(Num)+1))));
}
void PrintHist(tTableDFA& Input,string Name);
void Histograms(vector<tAutomata>* Vstup);
void Histograms1(vector<tAutomata>* Vstup);
void WeightGraf(tTableDFA* Min,string NameOut);
int Weight(tDLine& ATrans, tDLine& BTrans);


void File2Dfa(tTableDFA& Out, string file);
void Dfa2File(tTableDFA& Out, string file);
void SaveAutomaton(vector<tAutomata>* Vstup, unsigned int AcceptedCharacters);

float Mocnina(int A, int B);
#endif
