/**
 * compat.h: Provide some utilities on systems where n/a.
 * Author: Jachym Holecek <freza@liberouter.org>
 *
 * Copyright (C) 2004 CESNET
 *
 * LICENSE TERMS
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 * 3. Neither the name of the Company nor the names of its contributors
 *    may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * ALTERNATIVELY, provided that this notice is retained in full, this
 * product may be distributed under the terms of the GNU General Public
 * License (GPL) version 2 or later, in which case the provisions
 * of the GPL apply INSTEAD OF those given above.
 *
 * This software is provided ``as is'', and any express or implied
 * warranties, including, but not limited to, the implied warranties of
 * merchantability and fitness for a particular purpose are disclaimed.
 * In no event shall the company or contributors be liable for any
 * direct, indirect, incidental, special, exemplary, or consequential
 * damages (including, but not limited to, procurement of substitute
 * goods or services; loss of use, data, or profits; or business
 * interruption) however caused and on any theory of liability, whether
 * in contract, strict liability, or tort (including negligence or
 * otherwise) arising in any way out of the use of this software, even
 * if advised of the possibility of such damage.
 *
 * $Id: compat.h,v 1.7 2006/04/03 16:25:03 cejkar Exp $
 *
 */

#ifndef _LIBEROUTER_COMPAT_H_
#define _LIBEROUTER_COMPAT_H_

#ifdef __linux__
extern const char 		*__progname;

#define setprogname(argv0) 	/* no action */
#define getprogname() 		__progname
#endif /* __linux__ */

#ifndef __RCSID

#if __GNUC__ == 3 && __GNUC_MINOR__ >= 3 || __GNUC__ > 3
#define __IDSTRING(name,string) \
	static const char name[] __attribute__((__used__)) = string
#else
#define __IDSTRING(name,string) \
	static const char name[] __attribute__((__unused__)) = string
#endif

#define __RCSID(s) __IDSTRING(rcsid,s)
#endif /* !__RCSID*/

#if defined(__NetBSD__) || defined(__FreeBSD__)

#ifndef EBADFD
#define EBADFD          114     /* File descriptor in bad state */
#endif

#endif

#ifndef ATTRIBUTE_UNUSED
#define ATTRIBUTE_UNUSED __attribute__ ((__unused__))
#endif /* !ATTRIBUTE_UNUSED */

#endif /*_LIBEROUTER_COMPAT_H_*/
