###############################################################################
#  nfa.py: Module for PATTERN MATCH
#  Copyright (C) 2010 Brno University of Technology, ANT @ FIT
#  Author(s): Vlastimil Kosar <ikosar@fit.vutbr.cz>
###############################################################################
#
#  LICENSE TERMS
#
#  Redistribution and use in source and binary forms, with or without
#  modification, are permitted provided that the following conditions
#  are met:
#  1. Redistributions of source code must retain the above copyright
#     notice, this list of conditions and the following disclaimer.
#  2. Redistributions in binary form must reproduce the above copyright
#     notice, this list of conditions and the following disclaimer in
#     the documentation and/or other materials provided with the
#     distribution.
#  3. All advertising materials mentioning features or use of this software
#     or firmware must display the following acknowledgement:
#
#       This product includes software developed by the University of
#       Technology, Faculty of Information Technology, Brno and its
#       contributors.
#
#  4. Neither the name of the Company nor the names of its contributors
#     may be used to endorse or promote products derived from this
#     software without specific prior written permission.
#
#  This software or firmware is provided ``as is'', and any express or implied
#  warranties, including, but not limited to, the implied warranties of
#  merchantability and fitness for a particular purpose are disclaimed.
#  In no event shall the company or contributors be liable for any
#  direct, indirect, incidental, special, exemplary, or consequential
#  damages (including, but not limited to, procurement of substitute
#  goods or services; loss of use, data, or profits; or business
#  interruption) however caused and on any theory of liability, whether
#  in contract, strict liability, or tort (including negligence or
#  otherwise) arising in any way out of the use of this software, even
#  if advised of the possibility of such damage.
#
#  $Id$

#!/usr/bin/python

import sys
import re
import commands
import os.path

class nfa_parser:
  def __init__(self):
    self.file = 'tmp'
    self.begin_state = 0
    self.data = []

  def __del__(self):
    if (self.file == 'tmp'):
      commands.getoutput('rm tmp')
    commands.getoutput('rm lex.yy.c error')

  def add(self, value=None, idx = None):
    if (value == None):
      self.data.append([])
    else :
      self.data[idx].append(value)

  def loadFile(self, FileName):
    self.file = FileName

  def setText(self, RegExp):
    fd = open('tmp','w')
    fd.write("%%\n")
    fd.write(RegExp)
    fd.write("\n")
    fd.flush()
    fd.close()
    self.file = 'tmp'

  def parse(self):
    com = "flex -T " + self.file + " 2>error"
    commands.getoutput(com)
    fd = open('error','r')

    for line in fd:
      if re.search(r"\*{10}",line) != None:
        b_s = re.findall(r"\d",line)
        if len(b_s) > 0:
          num = len(b_s)
          for i in range(len(b_s)):
            self.begin_state = self.begin_state + (10 ** (num-1))*int(b_s[i]) # vypocet pociatocneho stavu z rozlozeneho cisla v liste
            num = num - 1
        else:
          fd.close() # koniec NFA, vypis dat
          return
      elif re.search(r"state #\s*[0-9]*\s*-*[0-9]+:\s*[0-9]+",line):
        a = line.split()
        self.add()
        help = re.findall(r"-*[0-9]*", a[3]) # odstranenie : za ASCII hodnotou prijimaneho znaku
        a[3] = help[0]
        help = re.findall(r"[0-9]*", a[4])
        a[4] = help[0]
        index = int(a[2])-1 # cislo stavu zmensene o 1 => indexovanie od nuly
        self.add(int(a[3]),index) # pridany prechodovy symbol
        for i in range(4,6):
          self.add(int(a[i])-1, index) # posuny stavov kvoli indexom
          if (self.data[index][i-3] == -1):
            self.data[index][i-3] = 0
        if (len(a) == 7): # tento stav je koncovy
          help = re.findall(r"[0-9]*", a[6])
          self.add(int(help[1]), index)
        else :
          self.add(-1, index)
  def print_automat(self):
    for i in range(self.begin_state):
      print self.data[i]
  def get_next_nfa(self):
     return

if (__name__ == "__main__") :
  nfa = nfa_parser()
  if (os.path.isfile(sys.argv[1])):
    nfa.loadFile(sys.argv[1])
  else :
    nfa.setText(sys.argv[1])
  nfa.parse()
  nfa.print_automat()
  del nfa
