###############################################################################
#  gen_pdu_table.py: Module for PATTERN MATCH
#  Copyright (C) 2010 Brno University of Technology, ANT @ FIT
#  Author(s): Vlastimil Kosar <ikosar@fit.vutbr.cz>
###############################################################################
#
#  LICENSE TERMS
#
#  Redistribution and use in source and binary forms, with or without
#  modification, are permitted provided that the following conditions
#  are met:
#  1. Redistributions of source code must retain the above copyright
#     notice, this list of conditions and the following disclaimer.
#  2. Redistributions in binary form must reproduce the above copyright
#     notice, this list of conditions and the following disclaimer in
#     the documentation and/or other materials provided with the
#     distribution.
#  3. All advertising materials mentioning features or use of this software
#     or firmware must display the following acknowledgement:
#
#       This product includes software developed by the University of
#       Technology, Faculty of Information Technology, Brno and its
#       contributors.
#
#  4. Neither the name of the Company nor the names of its contributors
#     may be used to endorse or promote products derived from this
#     software without specific prior written permission.
#
#  This software or firmware is provided ``as is'', and any express or implied
#  warranties, including, but not limited to, the implied warranties of
#  merchantability and fitness for a particular purpose are disclaimed.
#  In no event shall the company or contributors be liable for any
#  direct, indirect, incidental, special, exemplary, or consequential
#  damages (including, but not limited to, procurement of substitute
#  goods or services; loss of use, data, or profits; or business
#  interruption) however caused and on any theory of liability, whether
#  in contract, strict liability, or tort (including negligence or
#  otherwise) arising in any way out of the use of this software, even
#  if advised of the possibility of such damage.
#
#  $Id$

import commands
import sys
import nfa_split
import msfm_parser
import aux_func

text = str()
textl = "'Pravidla';"

outFile = sys.argv[1]
maxk = int(sys.argv[2])
textl += "'zpozdeni 1 DU'; 'Spotrebovano [LUT, FF, BRAM]';"
for i in range(2, maxk + 1):
    textl += "'zpozdeni " + str(i) + "-PDU'; 'Spotrebovano [LUT, FF, BRAM]';"
text += textl + "\n"

for i in range(3, len(sys.argv)):
    textl = "'" + sys.argv[i] + "';"
    
    ns = nfa_split.nfa_split()
    if aux_func.isPickle(sys.argv[i]) == True:
        ns = ns.load(sys.argv[i])
    else:
        Test0 = msfm_parser.msfm_parser()
        Test0.load_file(sys.argv[i])
        ns.create_by_parser(Test0)
    
    for j in range(1, maxk + 1):
        ns.create_det_parts(1)
        out = ns._statistics["DFA Parts Outset"][0]
        ns.split_det_parts(j)
        splitOut = ns._statistics["DFA Parts Outset"]
        sum = 0
        for i in range(0, len(splitOut)):
            sum += splitOut[i]
        add = out - sum
        data = ns.report_logic()
        data = (data[0] + add * 3, data[1], data[2])
        maxii = 0
        for l in range(0, len(ns._det_parts)):
            if ns._det_parts[l]._statistic["Encoder stages"] > maxii:
                maxii = ns._det_parts[l]._statistic["Encoder stages"]
        textl += str(maxii + 1) + ";" + str(data) + ";"
    text += textl + "\n"
f = open(outFile + ".csv", "w");
f.write(text)
f.close()